/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.Activator;
import com.ez.analysisbrowser.actions.AbstractActionDescriptor;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionDescriptor;
import com.ez.analysisbrowser.internal.DescriptorFactory;
import com.ez.analysisbrowser.internal.Messages;
import com.ez.analysisbrowser.views.ActionPath;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.analysisbrowser.views.BrowserPanel;
import com.ez.analysisbrowser.views.PersistentContext;
import com.ez.internal.graphmodel.EZSelection;
import com.ez.internal.model.SelectionProvider;
import com.ez.workspace.analysis.EZAnalysisType;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScrollableItemsView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    private static final Logger L = LoggerFactory.getLogger(AbstractScrollableItemsView.class);
    public static final String CONTRIBUTOR_ID = "unique identifier of the property sheet page contributor";
    public static final String MOVE_TO_SEPARATE_VIEW_ACTION_ID = "move to separate view Id";
    private BrowserPanel browserPanel = null;
    ActionPath actionPath = new ActionPath();
    ImageRegistry imageRegistry = new ImageRegistry();
    protected BrowserManager bm = new BrowserManager(this, this.imageRegistry);
    private String secondaryID = null;
    private static int secondaryCount = 0;
    private SelectionProvider selectionProvider = new SelectionProvider();
    private String defaultPartName = null;
    protected boolean hasScrollabletoolbar = true;
    protected boolean hasMoveSeparateViewAction = true;

    public AbstractScrollableItemsView() {
        this.initImages();
    }

    protected String newSecondaryID() {
        return Integer.toString(++secondaryCount);
    }

    protected abstract List<ContributionItem> contributeItems();

    public abstract String getViewId();

    protected void initImages() {
        this.imageRegistry.put("LEFT_END", Activator.getImageDescriptor("icons/left-end2.png"));
        this.imageRegistry.put("LEFT", Activator.getImageDescriptor("icons/left2.png"));
        this.imageRegistry.put("RIGHT_END", Activator.getImageDescriptor("icons/right-end2.png"));
        this.imageRegistry.put("RIGHT", Activator.getImageDescriptor("icons/right2.png"));
        this.imageRegistry.put("EXPAND", Activator.getImageDescriptor("icons/expand.png"));
        this.imageRegistry.put("SETTINGS", Activator.getImageDescriptor("icons/tool.png"));
        this.imageRegistry.put("DELETE", Activator.getImageDescriptor("icons/cross.png"));
        this.imageRegistry.put("DELETE_DISABLED", Activator.getImageDescriptor("icons/cross-disabled.png"));
    }

    public void createPartControl(Composite parent) {
        this.defaultPartName = this.getPartName();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.browserPanel = new BrowserPanel(parent, this.imageRegistry, this.bm, this.hasScrollabletoolbar, this.getDescriptorId());
        this.browserPanel.setLayoutData(new GridData(1808));
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        List<ContributionItem> items = this.contributeItems();
        if (items != null) {
            for (ContributionItem item : items) {
                toolBar.add((IContributionItem)item);
            }
        }
        if (this.hasMoveSeparateViewAction) {
            Action moveSeparateViewAction = new Action(Messages.getString(AbstractScrollableItemsView.class, "move.action.name"), Activator.getImageDescriptor("icons/move.png")){

                public void run() {
                    IWorkbenchPage page = AbstractScrollableItemsView.this.getSite().getPage();
                    try {
                        String newSecId = AbstractScrollableItemsView.this.newSecondaryID();
                        IActionDescriptor descriptor = AbstractScrollableItemsView.this.browserPanel.removeCurrent();
                        String viewId = AbstractScrollableItemsView.this.getViewId();
                        IActionContext state = descriptor.getState();
                        state.getData().put("IActionContext.restored.key", true);
                        Activator.getDefault().getMVManager().addState(viewId, newSecId, state);
                        IViewPart p = page.showView(viewId, newSecId, 1);
                        IPartService service = (IPartService)p.getSite().getService(IPartService.class);
                        AbstractScrollableItemsView.this.addPartListener(service);
                        AbstractScrollableItemsView.this.browserPanel.refreshCurrent();
                    }
                    catch (PartInitException e) {
                        L.error("", (Throwable)e);
                    }
                }
            };
            moveSeparateViewAction.setEnabled(false);
            moveSeparateViewAction.setToolTipText(Messages.getString(AbstractScrollableItemsView.class, "move.action.tooltip.text"));
            ActionContributionItem moveSeparateViewItem = new ActionContributionItem((IAction)moveSeparateViewAction);
            moveSeparateViewItem.setId(MOVE_TO_SEPARATE_VIEW_ACTION_ID);
            toolBar.add((IContributionItem)moveSeparateViewItem);
            moveSeparateViewItem.getAction().setEnabled(false);
        }
    }

    protected String getDescriptorId() {
        return "com.ez.analysis.base.explore.projects";
    }

    private void addPartListener(IPartService service) {
        IPartListener2 partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                L.debug("partVisible() {}", (Object)partRef.getId());
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                L.debug("partOpened() {}", (Object)partRef.getId());
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
                L.debug("partInputChanged() {}", (Object)partRef.getId());
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                L.debug("partHidden() {}", (Object)partRef.getId());
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                L.debug("partDeactivated() {}", (Object)partRef.getId());
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof AbstractScrollableItemsView) {
                    AbstractScrollableItemsView vv = (AbstractScrollableItemsView)part;
                    if (vv.bm.getCurrentContext() == null) {
                        vv.bm.cancelAction();
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                L.debug("partBroughtToTop() {}", (Object)partRef.getId());
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                L.debug("partActivated() {}", (Object)partRef.getId());
            }
        };
        service.addPartListener(partListener);
    }

    public void setFocus() {
        this.browserPanel.setFocus();
    }

    public void dispose() {
        this.imageRegistry.dispose();
        String sid = this.getSid();
        String viewId = this.getViewId();
        Activator.getDefault().getMVManager().unregister(viewId, sid);
        this.selectionProvider = null;
        this.browserPanel.dispose();
        super.dispose();
    }

    protected String getSid() {
        String sid = this.secondaryID == null ? "" : this.secondaryID;
        return sid;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.secondaryID = site.getSecondaryId();
        boolean configured = false;
        if (memento != null) {
            this.computeSecondaryCount();
            memento = memento.getChild("analysis.browser.init");
            if (memento != null) {
                String id = memento.getString("analysis-id");
                String stateHint = memento.getString("analysis-state-hint");
                PersistentContext context = new PersistentContext(id, stateHint);
                this.bm.setStartAnalysis(context);
                configured = true;
            }
        }
        if (!configured) {
            Iterator<IActionContext> iterator;
            String viewId = this.getViewId();
            List<IActionContext> states = Activator.getDefault().getMVManager().getState(viewId, this.secondaryID);
            if (states != null && (iterator = states.iterator()).hasNext()) {
                IActionContext state = iterator.next();
                if (states.size() > 1) {
                    state.getData().put("IActionContext.actions.path", states.subList(1, states.size()));
                }
                this.bm.setStartAnalysis(state);
            }
        }
    }

    protected void computeSecondaryCount() {
        String sid = this.secondaryID == null ? "-1" : this.secondaryID;
        secondaryCount = Math.max(secondaryCount, Integer.parseInt(sid));
    }

    public void saveState(IMemento memento) {
        IActionDescriptor descriptor = this.bm.getToSave();
        if (descriptor == null) {
            return;
        }
        memento = memento.createChild("analysis.browser.init");
        memento.putString("analysis-id", descriptor.getId());
        memento.putString("analysis-state-hint", descriptor.persistState());
        String viewId = this.getViewId();
        Activator.getDefault().getMVManager().addState(viewId, this.secondaryID, descriptor.getState());
        super.saveState(memento);
    }

    public void changeTitle(String newTitle) {
        this.setPartName(this.defaultPartName);
    }

    public void setSelection(ISelection selection) {
        if (this.selectionProvider != null) {
            this.selectionProvider.setSelection(selection);
        }
    }

    public String getContributorId() {
        if (this.bm.getCurrentContext() != null && this.bm.getCurrentContext().getData() != null && this.bm.getCurrentContext().getData().containsKey(CONTRIBUTOR_ID)) {
            return (String)this.bm.getCurrentContext().getData().get(CONTRIBUTOR_ID);
        }
        return "ezresource.contributor";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            TabbedPropertySheetPage page = new TabbedPropertySheetPage(this){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    L.debug("analysisBrowserView selection: {}", (Object)selection);
                    if (selection instanceof EZSelection) {
                        super.selectionChanged(part, (ISelection)new StructuredSelection((Object)selection));
                    } else {
                        super.selectionChanged(part, selection);
                    }
                }
            };
            return page;
        }
        return super.getAdapter(adapter);
    }

    public void launch(EZAnalysisType anaysisType, IActionContext context) {
        AbstractActionDescriptor descriptor = DescriptorFactory.getActionDescriptor(anaysisType);
        if (descriptor == null) {
            throw new IllegalStateException("null descriptor");
        }
        this.bm.launch(descriptor, context);
    }
}

