/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.internal;

import com.ez.analysisbrowser.actions.AbstractActionDescriptor;
import com.ez.analysisbrowser.actions.DescriptorAdapter;
import com.ez.analysisbrowser.actions.IActionDescriptor;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.category.ICategoryEntry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DescriptorFactory.class);

    public static IActionDescriptor getActionDescriptor(ICategoryEntry ce) {
        if (ce == null) {
            return null;
        }
        AbstractActionDescriptor ad = null;
        String descriptor = ce.getDescriptor();
        EZAnalysisType at = ce.getAnalysisType();
        if (descriptor != null) {
            String bundle = ce.getBundle();
            Bundle b = Platform.getBundle((String)bundle);
            try {
                Class cls = b.loadClass(descriptor);
                if (cls != null) {
                    Object inst = cls.newInstance();
                    ad = (AbstractActionDescriptor)inst;
                    ad.setName(ce.getName());
                    ad.setId(ce.getId());
                    ad.setCategory(ce.getCategory());
                    ad.setImageDescriptor(ce.getImageDescriptor());
                }
            }
            catch (Exception e) {
                L.error("could not instantiate", (Throwable)e);
            }
        } else if (at != null) {
            ad = DescriptorFactory.getActionDescriptor(at);
        }
        return ad;
    }

    public static AbstractActionDescriptor getActionDescriptor(EZAnalysisType at) {
        AbstractActionDescriptor ad = null;
        L.trace("descriptor factory: load for {} itf: {}", (Object)at.getClazz(), (Object)IActionDescriptor.class.getName());
        EZAnalysis instance = at.getImplementorInstance();
        if (instance == null) {
            L.error("descriptor factory: could not load for {} itf: {}", (Object)at.getClazz(), (Object)IActionDescriptor.class.getName());
        } else {
            ad = (AbstractActionDescriptor)Platform.getAdapterManager().loadAdapter((Object)at.getImplementorInstance(), IActionDescriptor.class.getName());
        }
        if (ad == null) {
            ad = new DescriptorAdapter(at);
        } else {
            ad.setImageDescriptor(at.getIconDescriptor());
        }
        return ad;
    }
}

