/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.internal;

import com.ez.analysisbrowser.actions.DescriptorAdapter;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionAdapter
implements IAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ActionAdapter.class);
    public static final String ANALYSIS_TYPE_INPUTS = "ANALYSIS_TYPE_INPUTS";
    public static final String SCOPE = "SCOPE";
    private DescriptorAdapter descriptor;
    private EZAnalysisType analysisType;
    private EZInputFilter filter;
    private IActionContext context;
    private EZAnalysis analysisInstance;

    public ActionAdapter(DescriptorAdapter descriptor, EZAnalysis analysisInstance) {
        this.descriptor = descriptor;
        this.analysisType = descriptor.getAnalysisType();
        this.filter = this.analysisType.getInputFilterInstance();
        this.analysisInstance = analysisInstance;
    }

    @Override
    public boolean canHandle(IActionContext context) {
        Object oInpTypes;
        Map<String, Object> data;
        boolean canHandle = false;
        if (context != null && (data = context.getData()) != null && (oInpTypes = data.get(ANALYSIS_TYPE_INPUTS)) != null && oInpTypes instanceof Collection) {
            if (this.analysisType.acceptsInputTypes((Collection)oInpTypes)) {
                canHandle = this.filter != null ? this.filter.checkAnalysisAvailability((Collection)oInpTypes) : true;
            } else {
                L.trace("inputs do not apply");
            }
        }
        return canHandle;
    }

    @Override
    public void setInputContext(IActionContext context) {
        this.context = context;
    }

    @Override
    public IActionContext getOutputContext() {
        return null;
    }

    @Override
    public void execute(IProgressMonitor pmonitor) {
        if (this.analysisInstance == null) {
            this.analysisInstance = this.analysisType.getImplementorInstance();
        }
        EZAnalysis an = this.analysisInstance;
        if (this.context != null) {
            Object oInpTypes;
            Map<String, Object> data = this.context.getData();
            if (data != null && (oInpTypes = data.get(ANALYSIS_TYPE_INPUTS)) instanceof List) {
                an.setInputs((List)oInpTypes);
                an.addContextValue("projects", data.get("projects"));
                an.addAllContextValues(data);
                Object scopeSet = data.get(SCOPE);
                an.setScope(1, scopeSet);
                an.execute();
            }
        } else {
            L.warn("empty starting context. will not execute");
        }
    }
}

