/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser;

import com.ez.analysisbrowser.internal.MultipleViewsManager;
import com.ez.workspace.analysis.category.ICategoryEntry;
import com.ez.workspace.model.CategoryEntry;
import com.ez.workspace.model.CategoryManager;
import com.ez.workspace.model.EZWorkspace;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String PLUGIN_ID = "com.ez.analysisbrowser";
    private static Activator plugin;
    private MultipleViewsManager mvManager = new MultipleViewsManager();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.loadDescriptors();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public MultipleViewsManager getMVManager() {
        return this.mvManager;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public CategoryManager getCategoryManager() {
        return EZWorkspace.getInstance().getCategoryManager();
    }

    private void loadDescriptors() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ez.analysis.descriptor");
        CategoryManager cm = EZWorkspace.getInstance().getCategoryManager();
        if (configs != null) {
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                if (c.getName().equals("analysis")) {
                    CategoryEntry ce = this.parseAnalysis(c);
                    cm.register((ICategoryEntry)ce);
                }
                ++n2;
            }
        }
    }

    private CategoryEntry parseAnalysis(IConfigurationElement conf) {
        String contribId = conf.getContributor().getName();
        CategoryEntry ce = new CategoryEntry(conf.getAttribute("id"), conf.getAttribute("name"));
        String iconPath = conf.getAttribute("icon");
        if (iconPath != null) {
            ce.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)contribId, (String)iconPath));
        }
        ce.setCategory(conf.getAttribute("category"));
        ce.setDescriptor(conf.getAttribute("descriptor"));
        ce.setBundle(contribId);
        ce.setViewId(conf.getAttribute("viewID"));
        return ce;
    }
}

