/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge.project.sso.impl;

import com.ez.ezsource.connection.zkbridge.project.Versions;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectInfo;
import com.ez.ezsource.connection.zkbridge.project.sso.impl.AboutMe;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Translate {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(Translate.class);

    public static List<ZkProjectInfo> dataToJSON(JsonArray array) {
        ArrayList<ZkProjectInfo> lst = null;
        if (array == null) {
            return null;
        }
        lst = new ArrayList<ZkProjectInfo>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject jo = array.getJsonObject(i);
            ZkProjectInfo je = null;
            try {
                je = Translate.toEntry(jo);
            }
            catch (Exception e) {
                L.error("error getting data for project entry: {}", (Object)jo.toString(), (Object)e);
                je = null;
            }
            if (je == null) continue;
            lst.add(je);
        }
        return lst;
    }

    private static ZkProjectInfo toEntry(JsonObject jo) {
        String pjStrType;
        if (jo == null || jo.isEmpty()) {
            return null;
        }
        L.trace("parsing: {}", (Object)jo);
        UUID id = null;
        try {
            id = jo.isNull("uid") ? null : UUID.fromString(jo.getString("uid"));
        }
        catch (Exception e) {
            L.error("error getting id!", (Throwable)e);
        }
        UUID dbid = null;
        try {
            dbid = jo.isNull("dbId") ? null : UUID.fromString(jo.getString("dbId"));
        }
        catch (Exception e) {
            L.error("error getting dbid!", (Throwable)e);
        }
        boolean useBRD = jo.getBoolean("useBRD", false);
        Boolean useCross = jo.getBoolean("useCROSS", false);
        Boolean onMainfr = jo.getBoolean("onMainfr", true);
        ZkProjectInfo info = new ZkProjectInfo(id, jo.isNull("name") ? null : jo.getString("name"), jo.isNull("path") ? null : jo.getString("path"), dbid, jo.isNull("dbName") ? null : jo.getString("dbName"), jo.isNull("dbSchema") ? null : jo.getString("dbSchema"), useBRD, useCross);
        Long pjType = 0L;
        String string = pjStrType = jo.get((Object)"prjType") == null || jo.isNull("prjType") ? null : jo.getString("prjType");
        if (pjStrType != null && pjStrType.length() > 0) {
            try {
                pjType = Long.valueOf(pjStrType);
            }
            catch (NumberFormatException ex) {
                L.error("Wrong format for project type: {} (project: {})", new Object[]{pjStrType, info.getName(), ex});
            }
        }
        JsonObject metadataJson = null;
        String lastBuild = "";
        try {
            metadataJson = jo.getJsonObject("metadata");
        }
        catch (Exception e) {
            L.debug("MetadataJson is null and is not currently set for project: {}", (Object)info.getName());
        }
        try {
            lastBuild = jo.getJsonObject("modified").getString("date");
        }
        catch (Exception e) {
            L.debug("Last build date is null or cannot be retrieved for project: {}", (Object)info.getName());
        }
        info.setProjectType(pjType);
        info.setOnMainframe(onMainfr);
        info.setLastBuild(lastBuild);
        info.setMetadataJson(metadataJson);
        return info;
    }

    public static JsonValue userAsJSON(AboutMe me, boolean useAccessControl) {
        if (me == null) {
            return null;
        }
        JsonObjectBuilder b = Json.createObjectBuilder().add("user", me.name != null ? me.name : "").add("domain", me.domain != null ? me.domain : "").add("accessCtrl", useAccessControl);
        return b.build();
    }

    public static JsonValue versionAsJSON(Versions vers) {
        if (vers == null) {
            return null;
        }
        JsonObjectBuilder b = Json.createObjectBuilder().add("schema", vers.schemaVers).add("client", vers.clientVers != null ? vers.clientVers : "").add("batch", vers.batchVers != null ? vers.batchVers : "");
        return b.build();
    }
}

