/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge.project.sso.impl;

import com.ez.eclient.service.Pair;
import com.ez.eclient.service.rsrv.mfprojects.IMainframeProjectsService;
import com.ez.ezsource.connection.zkbridge.project.ProjectState;
import com.ez.ezsource.connection.zkbridge.project.Versions;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectInfo;
import com.ez.ezsource.connection.zkbridge.project.sso.ChangeEvent;
import com.ez.ezsource.connection.zkbridge.project.sso.ErrorEvent;
import com.ez.ezsource.connection.zkbridge.project.sso.ErrorListener;
import com.ez.ezsource.connection.zkbridge.project.sso.HttpRequestRunnable;
import com.ez.ezsource.connection.zkbridge.project.sso.IMFProjectsService;
import com.ez.ezsource.connection.zkbridge.project.sso.ListChangedListener;
import com.ez.ezsource.connection.zkbridge.project.sso.impl.AboutMe;
import com.ez.ezsource.connection.zkbridge.project.sso.impl.HttpReqRunn;
import com.ez.ezsource.connection.zkbridge.project.sso.impl.Translate;
import com.sun.jna.platform.win32.Netapi32Util;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFProjectsServiceImpl
implements IMFProjectsService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(MFProjectsServiceImpl.class);
    public static final String USE_ACCESS_CONTROL = "use.access.control";
    public static final String WHOAMI_SUPPLIER = "whoami.supplier";
    public static final String HTTPREQUEST_RUNNABLE = "request.runnable";
    public static final String WHITELIST = "whitelist";
    public static final String BLACKLIST = "blacklist";
    public static final String DATAFOLDER = "datafolder";
    public static final String CCSSERVICE = "ccsreader";
    public static final String MFPROJ_URL = "mfproj.url";
    public static final String MFPROJ_CHECK_URL = "mfproj.check.url";
    private static final String DOMAIN_P = "FORCED_DOMAIN";
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final String REFRESH_TIME_PROP_NAME = "ad.projects.refreshTime";
    private boolean useAccessControl = false;
    private volatile String forcedDomain = null;
    private String mfProjURL;
    private IMainframeProjectsService ccsSrv;
    private HttpRequestRunnable reqRunn;
    private volatile Supplier<Pair<String, Boolean>> whoAmISupplier;
    volatile List<ZkProjectInfo> projects = new ArrayList<ZkProjectInfo>();
    private final Set<ErrorListener> errorListeners = new HashSet<ErrorListener>();
    private Set<ListChangedListener> listeners = new HashSet<ListChangedListener>();
    private Set<String> whiteList;
    private Set<String> blackList;
    private volatile State state = State.Created;
    private UpdateThread updateTh;
    private String mfProjCheckURL;

    @Override
    public synchronized void start() {
        switch (this.state) {
            case Created: {
                this.initAndStart();
                break;
            }
            case Initialized: {
                L.warn("service is correct initialized and starting; do not try to start it again!");
                break;
            }
            case Started: {
                L.warn("service already started!");
                break;
            }
            case Destroyed: {
                L.error("service was destroyed; why is started again?!");
                break;
            }
            default: {
                L.warn("unknown state for service: {}", (Object)this.state);
            }
        }
    }

    private void initAndStart() {
        AboutMe me = this.whoAmI();
        boolean ok = this.checkPrereq(me);
        if (ok) {
            this.state = State.Initialized;
            boolean notify = this.getProjects(me);
            this.state = State.Started;
            if (notify) {
                this.fireMFListChanged();
            }
            this.updateTh = new UpdateThread(me);
            this.updateTh.start();
        } else {
            L.error("cannot continue as service is not correct initialized!");
            this.fireMFServiceErrorEvent(new RuntimeException("Cannot continue as facade to Mainframe Projects service is not initialized! Please check log files for details!"));
        }
    }

    private boolean checkPrereq(AboutMe me) {
        boolean ok = false;
        if (this.ccsSrv == null && (this.mfProjURL == null || this.mfProjURL.isEmpty())) {
            L.error("both service reading from CSS and URL needed to access MF Projects list are null!");
        } else {
            if (this.ccsSrv != null && this.mfProjURL != null && !this.mfProjURL.isEmpty()) {
                L.info("both ccsReader and project's list URL are specified! URL will prevail");
            }
            if (this.ccsSrv != null) {
                if (!this.ccsSrv.isStarted()) {
                    this.ccsSrv.start();
                    if (this.ccsSrv.isStarted()) {
                        ok = true;
                    }
                } else {
                    ok = true;
                }
            }
        }
        if (!ok) {
            ok = this.mfProjURL != null && !this.mfProjURL.isEmpty();
        }
        return ok;
    }

    @Override
    public synchronized void shutdown() {
        if (this.updateTh != null) {
            this.updateTh.setAlive(false);
        }
        if (this.projects != null) {
            this.projects.clear();
            this.projects = null;
        }
        if (this.ccsSrv != null) {
            if (this.ccsSrv.isStarted()) {
                L.info("service reading from CSS URL of MF Projects is still started!");
            }
            this.ccsSrv = null;
        }
        this.state = State.Destroyed;
    }

    private synchronized void checkstate() {
        if (!this.state.equals((Object)State.Started)) {
            L.info("projects service not ready yet (state={}); check later!", (Object)this.state);
        }
    }

    @Override
    public List<ZkProjectInfo> getAllProjectsInfo() {
        L.trace("getAllProjectInfo()");
        this.checkstate();
        return this.projects;
    }

    @Override
    public List<String[]> getAllProjects() {
        L.trace("getAllProjects()");
        this.checkstate();
        ArrayList<String[]> lst = new ArrayList<String[]>();
        for (ZkProjectInfo pinfo : this.projects) {
            String[] props = new String[]{pinfo.getName(), pinfo.getProjectType().toString(), pinfo.getId().toString()};
            lst.add(props);
        }
        L.trace("list of projects: {}", lst);
        return lst;
    }

    @Override
    public List<String> getAllMainframeProjects() {
        L.trace("getAllMainframeProjects()");
        this.checkstate();
        ArrayList<String> lst = new ArrayList<String>();
        for (ZkProjectInfo pinfo : this.projects) {
            if (pinfo.getProjectType() != null && (pinfo.getProjectType() == null || pinfo.getProjectType().equals(Long.valueOf("16384")))) continue;
            lst.add(pinfo.getName());
        }
        L.trace("list of projects: {}", lst);
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getProjects(AboutMe whoAmI) {
        boolean notify;
        block14: {
            L.trace("ask mf projects service for projects details");
            notify = false;
            try {
                String urlEndp = this.mfProjURL;
                if (urlEndp == null || urlEndp.isEmpty()) {
                    urlEndp = this.getMfProjServURL(MFPROJ_URL);
                }
                if (urlEndp != null && !urlEndp.isEmpty()) {
                    String url = this.preparePrjListURL(urlEndp, whoAmI, true);
                    Object data = this.executeRequest(this.reqRunn, url, null);
                    if (data != null) {
                        List<ZkProjectInfo> tmp = this.parseResponse((String)data);
                        notify = !this.projects.equals(tmp = this.filterProjects(tmp));
                        MFProjectsServiceImpl mFProjectsServiceImpl = this;
                        synchronized (mFProjectsServiceImpl) {
                            this.projects = tmp;
                            break block14;
                        }
                    }
                    L.info("no data returned from service; clear projects list");
                    MFProjectsServiceImpl mFProjectsServiceImpl = this;
                    synchronized (mFProjectsServiceImpl) {
                        this.projects.clear();
                    }
                    notify = true;
                    break block14;
                }
                L.debug("unknown URL; cannot get projects list!");
                throw new RuntimeException("Cannot connect Mainframe Projects service (URL is null)! Please check settings from CCS!");
            }
            catch (Throwable t) {
                L.error("Error getting projects from service. Projects list will be empty!", t);
                MFProjectsServiceImpl mFProjectsServiceImpl = this;
                synchronized (mFProjectsServiceImpl) {
                    this.projects.clear();
                }
                this.fireMFServiceErrorEvent(t);
                this.fireMFListChanged();
            }
        }
        L.trace("listeners should be notified about changes in list: {}", (Object)notify);
        return notify;
    }

    private String getMfProjServURL(String urlKey) {
        String url = null;
        if (this.ccsSrv != null) {
            if (!this.ccsSrv.isStarted()) {
                L.error("CCS mf projects service is not started! cannot find URL to ask for list of projects.");
            } else if (MFPROJ_URL.equals(urlKey)) {
                url = this.ccsSrv.getProjectListEndpoint(this.useAccessControl);
            } else if (MFPROJ_CHECK_URL.equals(urlKey)) {
                url = this.ccsSrv.getCheckProjectsEndpoint(this.useAccessControl);
            } else {
                L.warn("unknown urlKey: {}!", (Object)urlKey);
            }
        }
        return url;
    }

    private List<ZkProjectInfo> filterProjects(List<ZkProjectInfo> prjs) {
        ArrayList<ZkProjectInfo> ret = new ArrayList<ZkProjectInfo>();
        if (prjs != null) {
            int index;
            StringBuilder sb = new StringBuilder();
            L.trace("filtering list (whitelist: {}; blacklist: {})", this.whiteList, this.blackList);
            for (ZkProjectInfo prj : prjs) {
                boolean accepted = this.whiteList == null && this.blackList != null ? !MFProjectsServiceImpl.containsRegex(prj.getName(), this.blackList) : (this.whiteList != null ? MFProjectsServiceImpl.containsRegex(prj.getName(), this.whiteList) : true);
                if (!accepted) continue;
                ret.add(prj);
                sb.append(prj.getName());
                sb.append(",");
            }
            if (sb.length() > 0 && (index = sb.lastIndexOf(",")) > -1) {
                sb.deleteCharAt(index);
            }
            L.info("filtered projects: [{}]", (Object)sb.toString());
        } else {
            L.info("no projects read from data returned from MainframeProjects service");
        }
        return ret;
    }

    private static boolean containsRegex(String string, Collection<String> list) {
        boolean retVal = false;
        for (String element : list) {
            if (!element.equals(string) && !Pattern.matches(element, string)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private List<ZkProjectInfo> parseResponse(String data) {
        JsonReader reader = Json.createReader((Reader)new StringReader(data));
        JsonObject root = reader.readObject();
        List<ZkProjectInfo> lst = Translate.dataToJSON(root.getJsonArray("data"));
        return lst;
    }

    private String preparePrjListURL(String url, AboutMe whoAmI, boolean fullInfo) {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair((Object)"info", (Object)String.valueOf(fullInfo)));
        if (whoAmI != null && whoAmI.name != null) {
            params.add(new Pair((Object)"user", (Object)whoAmI.name));
            if (whoAmI.domain != null) {
                params.add((Pair<String, String>)new Pair((Object)"domain", (Object)whoAmI.domain));
            }
        }
        params.add(new Pair((Object)"os", (Object)OS));
        if (this.useAccessControl) {
            params.add((Pair<String, String>)new Pair((Object)"accessCtrl", (Object)"true"));
        }
        String ret = MFProjectsServiceImpl.prepareURL(url, params);
        return ret;
    }

    private static String prepareURL(String prefix, List<Pair<String, String>> params) {
        if (prefix == null) {
            throw new RuntimeException("Mainframe Projects service cannot be accessed!", null);
        }
        String url = null;
        try {
            url = prefix;
            if (params != null && params.size() > 0) {
                url = url + "?";
                int no = 1;
                for (Pair<String, String> parameter : params) {
                    String paramName = (String)parameter.getLeft();
                    String paramVal = (String)parameter.getRight();
                    url = url + paramName + "=" + URLEncoder.encode(paramVal, "UTF-8");
                    if (no >= params.size()) continue;
                    url = url + "&";
                    ++no;
                }
            }
        }
        catch (Exception e) {
            L.error("error preparing url. prefix={}; params={}, paramValue={}", new Object[]{prefix, params, e});
        }
        return url;
    }

    private Object executeRequest(HttpRequestRunnable runn, String url, String body) throws Throwable {
        if (runn == null) {
            L.info("default HttpRequest used");
            runn = new HttpReqRunn();
        }
        Object data = runn.runRequest(url, body);
        L.trace("returned data: {}", data);
        return data;
    }

    public synchronized void setProperties(Map<String, Object> properties) {
        this.useAccessControl = (Boolean)properties.getOrDefault(USE_ACCESS_CONTROL, false);
        this.reqRunn = (HttpRequestRunnable)properties.get(HTTPREQUEST_RUNNABLE);
        this.whoAmISupplier = (Supplier)properties.get(WHOAMI_SUPPLIER);
        this.ccsSrv = (IMainframeProjectsService)properties.get(CCSSERVICE);
        this.mfProjURL = (String)properties.get(MFPROJ_URL);
        this.mfProjCheckURL = (String)properties.get(MFPROJ_CHECK_URL);
        this.whiteList = (Set)properties.get(WHITELIST);
        this.blackList = (Set)properties.get(BLACKLIST);
    }

    private AboutMe whoAmI() {
        AboutMe aboutMe = null;
        if (this.whoAmISupplier != null) {
            L.debug("using provided whoAmISupplier");
            Pair<String, Boolean> pair = this.whoAmISupplier.get();
            if (((Boolean)pair.getRight()).booleanValue()) {
                String name = (String)pair.getLeft();
                if (name == null) {
                    return null;
                }
                aboutMe = new AboutMe((String)pair.getLeft(), "");
            }
        }
        if (aboutMe == null) {
            L.debug("guessing user and domain");
            aboutMe = this.getSystemMe();
        }
        return aboutMe;
    }

    private AboutMe getSystemMe() {
        String domain = null;
        String forced = System.getProperty(DOMAIN_P);
        String user = null;
        L.info("OS: {}", (Object)OS);
        user = System.getProperty("user.name");
        if (user == null) {
            throw new RuntimeException("Can't read system property user.name");
        }
        if (forced != null) {
            String msg = "Domain forced to " + forced;
            if (this.forcedDomain != null && !this.forcedDomain.equals(forced)) {
                L.info(msg);
            } else {
                L.debug(msg);
            }
            this.forcedDomain = domain = forced;
        } else {
            this.forcedDomain = null;
        }
        if (domain == null && OS.contains("win")) {
            L.debug("Finding domain name...");
            try {
                Netapi32Util.DomainController dc = Netapi32Util.getDC();
                if (dc != null) {
                    domain = dc.domainName;
                    L.debug("Domain found: {}", (Object)domain);
                }
            }
            catch (Throwable ex) {
                L.warn("Domain not found. Unexpected error.", (Object)ex.getMessage());
            }
        }
        L.info("Username: {}", (Object)user);
        if (domain != null) {
            L.info("Domain: {}", domain);
        }
        if (this.useAccessControl && domain == null) {
            if (OS.contains("win")) {
                L.warn("User {} not logged to a Windows domain.", (Object)user);
            } else {
                L.info("Component not runing on Windows. No domain will be provided.");
            }
        }
        return new AboutMe(user, domain);
    }

    @Override
    public synchronized boolean isStarted() {
        return this.state.equals((Object)State.Started);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIdentity(Supplier<Pair<String, Boolean>> supplier) {
        MFProjectsServiceImpl mFProjectsServiceImpl = this;
        synchronized (mFProjectsServiceImpl) {
            this.whoAmISupplier = supplier;
            if (this.state.equals((Object)State.Started)) {
                L.debug("the user changed, so make update thread to use the new one");
                this.updateTh.resetUser();
            } else {
                L.debug("service is reinitialized and started again as the user changed");
                this.initAndStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCCSReader(IMainframeProjectsService srv) {
        MFProjectsServiceImpl mFProjectsServiceImpl = this;
        synchronized (mFProjectsServiceImpl) {
            this.ccsSrv = srv;
            L.debug("service is reinitialized and started again as CCS reader srv was changed");
            this.initAndStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectsEndpoint(String url) {
        MFProjectsServiceImpl mFProjectsServiceImpl = this;
        synchronized (mFProjectsServiceImpl) {
            this.mfProjURL = url;
            L.debug("service is reinitialized and started again as URL for MfProjects service was changed");
            this.initAndStart();
        }
    }

    @Override
    public void addMFServiceErrorListener(ErrorListener errorListener) {
        this.errorListeners.add(errorListener);
    }

    @Override
    public void removeMFServiceErrorListener(ErrorListener errorListener) {
        this.errorListeners.remove(errorListener);
    }

    private void fireMFServiceErrorEvent(final Throwable t) {
        ErrorEvent event = new ErrorEvent(){

            @Override
            public Throwable getError() {
                return t;
            }
        };
        L.trace("fire error {} to listeners: {}", (Object)event, this.errorListeners);
        for (ErrorListener listener : this.errorListeners) {
            listener.errorOccured(event);
        }
    }

    @Override
    public void addMFProjectsListener(ListChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeMFProjectsListener(ListChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireMFListChanged() {
        this.fireMFListChanged(null);
    }

    private void fireMFListChanged(ChangeEvent event) {
        if (event == null) {
            event = new ChangeEvent(ChangeEvent.ChangeEventType.LIST);
        }
        L.trace("fire event {} to listeners: {}", (Object)event, this.listeners);
        for (ListChangedListener listener : this.listeners) {
            listener.listChanged(event);
        }
    }

    @Override
    public ProjectState checkProject(String project, Versions vers) {
        ProjectState state;
        block8: {
            L.trace("check project {} in mf projects service", (Object)project);
            state = ProjectState.UNKNOWN;
            String url = this.mfProjCheckURL;
            if (url == null) {
                url = this.getMfProjServURL(MFPROJ_CHECK_URL);
            }
            if (project == null || project.isEmpty()) {
                L.info("unknown project name; cannot check it!");
                throw new RuntimeException("Cannot check a project without name! Please check log files!");
            }
            if (vers == null) {
                L.info("unknown versions; cannot check project {}!", (Object)project);
                throw new RuntimeException(String.format("Cannot check project %s as had no versions! Please check log files!", project));
            }
            if (url != null && !url.isEmpty()) {
                try {
                    AboutMe me = this.whoAmI();
                    JsonObjectBuilder infob = Json.createObjectBuilder().add("project", project).add("me", Translate.userAsJSON(me, this.useAccessControl)).add("versions", Translate.versionAsJSON(vers));
                    JsonObject info = infob.build();
                    StringWriter stringWriter = new StringWriter();
                    JsonWriter writer = Json.createWriter((Writer)stringWriter);
                    writer.writeObject(info);
                    writer.close();
                    String body = stringWriter.getBuffer().toString();
                    L.trace("request for checking {} project: {}", (Object)project, (Object)body);
                    Object data = this.executeRequest(this.reqRunn, url, body);
                    if (data != null) {
                        JsonReader reader = Json.createReader((Reader)new StringReader((String)data));
                        JsonObject root = reader.readObject();
                        String response = root.getString("data");
                        state = ProjectState.valueOf(response);
                        L.trace("state of project {} returned from service: {}", (Object)project, (Object)state);
                        break block8;
                    }
                    L.info("no data returned from service; let project's state as unknown");
                }
                catch (Throwable ex) {
                    L.error("error check project: {}", (Object)project, (Object)ex);
                    this.fireMFListChanged(new ChangeEvent(project, ProjectState.UNKNOWN.name()));
                }
            } else {
                L.info("unknown URL; cannot check project {}!", (Object)project);
                throw new RuntimeException(String.format("Cannot connect Mainframe Projects service to check project %s (URL is null)! Please check settings from CCS!", project));
            }
        }
        return state;
    }

    private class UpdateThread
    extends Thread {
        private int timeout = 120;
        private boolean alive = false;
        AboutMe whoAmI = null;

        public UpdateThread(AboutMe me) {
            String timeoutV = System.getProperty(MFProjectsServiceImpl.REFRESH_TIME_PROP_NAME);
            if (timeoutV != null) {
                try {
                    this.timeout = Integer.valueOf(timeoutV);
                }
                catch (Exception e) {
                    L.warn("{} had an incorrect value: {}; default ({} sec) it will be used", new Object[]{MFProjectsServiceImpl.REFRESH_TIME_PROP_NAME, timeoutV, this.timeout});
                }
            }
            L.info("refreshTime for getting project's list: {} sec", (Object)this.timeout);
            this.timeout *= 1000;
            this.whoAmI = me;
            this.alive = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetUser() {
            MFProjectsServiceImpl mFProjectsServiceImpl = MFProjectsServiceImpl.this;
            synchronized (mFProjectsServiceImpl) {
                MFProjectsServiceImpl.this.projects.clear();
                MFProjectsServiceImpl.this.state = State.Initialized;
                this.whoAmI = MFProjectsServiceImpl.this.whoAmI();
            }
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                UpdateThread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                L.debug("interrupt the first sleep", (Throwable)e);
            }
            while (this.alive) {
                try {
                    boolean notify = MFProjectsServiceImpl.this.getProjects(this.whoAmI);
                    MFProjectsServiceImpl mFProjectsServiceImpl = MFProjectsServiceImpl.this;
                    synchronized (mFProjectsServiceImpl) {
                        switch (MFProjectsServiceImpl.this.state) {
                            case Created: 
                            case Initialized: 
                            case Started: {
                                MFProjectsServiceImpl.this.state = State.Started;
                                break;
                            }
                            case Destroyed: {
                                L.error("service was destroyed; why still refresh the list?!");
                                break;
                            }
                            default: {
                                L.warn("unknown state for service: {}", (Object)MFProjectsServiceImpl.this.state);
                            }
                        }
                    }
                    if (notify) {
                        MFProjectsServiceImpl.this.fireMFListChanged();
                    }
                    L.debug("projects read thread will sleep now");
                    UpdateThread.sleep(this.timeout);
                }
                catch (InterruptedException e) {
                    L.debug("interrupt timeout sleep", (Throwable)e);
                }
            }
            if (!this.alive) {
                L.trace("projects read stop");
            }
        }

        public synchronized void setAlive(boolean alive) {
            this.alive = alive;
            this.interrupt();
        }
    }

    private static enum State {
        Created,
        Initialized,
        Started,
        Destroyed;

    }
}

