/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge.project.sso.impl;

import com.ez.ezsource.connection.zkbridge.project.sso.HttpRequestRunnable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReqRunn
implements HttpRequestRunnable {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(HttpReqRunn.class);

    @Override
    public Object runRequest(String url) throws Exception {
        return this.runRequest(url, null);
    }

    @Override
    public Object runRequest(String endpoint, String requestBody) throws Exception {
        HttpURLConnection con = null;
        BufferedReader in = null;
        try {
            URL url = new URL(endpoint);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Content-Type", "application/json");
            con.setConnectTimeout(10000);
            if (requestBody != null) {
                con.setDoOutput(true);
                con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                OutputStream os = con.getOutputStream();
                os.write(requestBody.getBytes("UTF-8"));
                try {
                    os.close();
                }
                catch (IOException e) {
                    L.warn("Failed to close temporary input stream:", (Throwable)e);
                }
            }
            L.debug("requesting: {}", (Object)endpoint);
            con.connect();
            if (con.getResponseCode() == 200) {
                String output;
                L.debug("response code 200; continuing with the result");
                StringBuilder content = new StringBuilder();
                in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while ((output = in.readLine()) != null) {
                    content.append(output);
                }
                String string = content.toString();
                return string;
            }
            try {
                L.error("request ({}) error; response: {}", (Object)endpoint, (Object)con.getResponseCode());
                throw new RuntimeException(String.format("Service request error when running: %s! (response code: %s)", endpoint, con.getResponseCode()));
            }
            catch (Exception e) {
                L.error("error running {}", (Object)endpoint, (Object)e);
                throw e;
            }
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    L.warn("Failed to close temporary input stream:", (Throwable)e);
                }
            }
        }
    }
}

