/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge.project;

import java.util.UUID;
import javax.json.JsonObject;

public class ZkProjectInfo {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String name;
    private UUID id;
    private String localPath;
    private UUID dbId;
    private String database;
    private String databaseSchema;
    private boolean useBRD;
    private boolean useCross;
    private Long pjType;
    private boolean onMainframe = false;
    private JsonObject metadataJson;
    private String lastBuild;

    public ZkProjectInfo(UUID id, String name, String localPath, UUID dbId, String database, String databaseSchema, boolean useBRD, boolean useCross) {
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        this.localPath = localPath;
        this.id = id;
        this.name = name;
        this.dbId = dbId;
        this.database = database;
        this.databaseSchema = databaseSchema;
        this.useBRD = useBRD;
        this.useCross = useCross;
    }

    public ZkProjectInfo(UUID id, String name, String localPath, UUID dbId, String database, String databaseSchema, boolean useBRD, boolean useCross, String lastBuild) {
        this(id, name, localPath, dbId, database, databaseSchema, useBRD, useCross);
        this.lastBuild = lastBuild;
    }

    public ZkProjectInfo(UUID id, String name, String localPath, UUID dbId, String database, String databaseSchema, boolean useBRD, boolean useCross, JsonObject metadataJson) {
        this(id, name, localPath, dbId, database, databaseSchema, useBRD, useCross);
        this.metadataJson = metadataJson;
    }

    public ZkProjectInfo(UUID id, String name, String localPath, UUID dbId, String database, String databaseSchema, boolean useBRD, boolean useCross, String lastBuild, JsonObject metadataJson) {
        this(id, name, localPath, dbId, database, databaseSchema, useBRD, useCross, lastBuild);
        this.metadataJson = metadataJson;
    }

    public String getName() {
        return this.name;
    }

    public String getlocalPath() {
        return this.localPath;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getDbId() {
        return this.dbId;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public boolean useBRD() {
        return this.useBRD;
    }

    public boolean useCross() {
        return this.useCross;
    }

    public Long getProjectType() {
        return this.pjType;
    }

    public void setProjectType(Long pjType) {
        this.pjType = pjType;
    }

    public boolean isOnMainframe() {
        return this.onMainframe;
    }

    public void setOnMainframe(boolean onMainframe) {
        this.onMainframe = onMainframe;
    }

    public void setMetadataJson(JsonObject metadataJson) {
        this.metadataJson = metadataJson;
    }

    public JsonObject getMetadataJson() {
        return this.metadataJson;
    }

    public String getLastBuild() {
        return this.lastBuild;
    }

    public void setLastBuild(String lastBuild) {
        this.lastBuild = lastBuild;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getName());
        b.append("[");
        b.append("id: ");
        b.append(this.id);
        b.append(", name: ");
        b.append(this.name);
        b.append(", dbId: ");
        b.append(this.dbId);
        b.append(", database: ");
        b.append(this.database);
        b.append(", database schema: ");
        b.append(this.databaseSchema);
        b.append(", useBRD: ");
        b.append(this.useBRD);
        b.append(", useCross: ");
        b.append(this.useCross);
        b.append(", projType: ");
        b.append(this.pjType);
        b.append(", onMainframe: ");
        b.append(this.onMainframe);
        b.append(", lastBuild: ");
        b.append(this.lastBuild);
        b.append(", metadata: ");
        b.append(this.metadataJson);
        b.append("]");
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        result = 31 * result + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = 31 * result + (this.dbId == null ? 0 : this.dbId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.localPath == null ? 0 : this.localPath.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.onMainframe ? 1231 : 1237);
        result = 31 * result + (this.pjType == null ? 0 : this.pjType.hashCode());
        result = 31 * result + (this.useBRD ? 1231 : 1237);
        result = 31 * result + (this.useCross ? 1231 : 1237);
        result = 31 * result + (this.lastBuild == null ? 0 : this.lastBuild.hashCode());
        result = 31 * result + (this.metadataJson == null ? 0 : this.metadataJson.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZkProjectInfo other = (ZkProjectInfo)obj;
        if (this.database == null ? other.database != null : !this.database.equals(other.database)) {
            return false;
        }
        if (this.databaseSchema == null ? other.databaseSchema != null : !this.databaseSchema.equals(other.databaseSchema)) {
            return false;
        }
        if (this.dbId == null ? other.dbId != null : !this.dbId.equals(other.dbId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.localPath == null ? other.localPath != null : !this.localPath.equals(other.localPath)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.onMainframe != other.onMainframe) {
            return false;
        }
        if (this.pjType == null ? other.pjType != null : !this.pjType.equals(other.pjType)) {
            return false;
        }
        if (this.useBRD != other.useBRD) {
            return false;
        }
        if (this.useCross != other.useCross) {
            return false;
        }
        if (this.lastBuild == null ? other.lastBuild != null : !this.lastBuild.equals(other.lastBuild)) {
            return false;
        }
        return this.metadataJson == other.metadataJson;
    }
}

