/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge.project;

import com.ez.eclient.service.database.DatabaseService;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.impl.Lifecycle;
import com.ez.ezsource.connection.EZSourceRemoteConnectionListener;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectConnection;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectInfo;
import com.ez.ezsource.connection.zkbridge.project.sso.IMFProjectsService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkProjectConnectionImpl
implements ZkProjectConnection,
Lifecycle {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ZkProjectConnectionImpl.class);
    private IMFProjectsService projectService;
    private DatabaseService dbService;
    private final Set<EZSourceRemoteConnectionListener> remoteListeners = new HashSet<EZSourceRemoteConnectionListener>();
    private State state = State.Created;
    private final Object stateGuard = new Object();

    ZkProjectConnectionImpl(Configuration conf) {
        this.projectService = (IMFProjectsService)conf.getProperty("mfProjectsService");
        this.dbService = (DatabaseService)conf.getProperty("databaseService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != State.Created) {
                throw new IllegalStateException(this.state.toString());
            }
            boolean ok = false;
            if (this.projectService == null) {
                L.error("MFProjectsService is null!");
            } else if (!this.projectService.isStarted()) {
                this.projectService.start();
                if (this.projectService.isStarted()) {
                    ok = true;
                }
            } else {
                ok = true;
            }
            if (ok) {
                if (this.dbService == null) {
                    L.error("DatabaseService is null!");
                    ok = false;
                } else if (!this.dbService.isStarted()) {
                    this.dbService.start();
                    if (this.dbService.isStarted()) {
                        ok = true;
                    }
                } else {
                    ok = true;
                }
            }
            if (ok) {
                this.state = State.Initialized;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninitialize() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != State.Initialized) {
                L.warn("Expected Idle state but found {}", (Object)this.state);
            }
            this.projectService = null;
            this.dbService = null;
            this.state = State.Destroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteConnectionListener(EZSourceRemoteConnectionListener listener) {
        Set<EZSourceRemoteConnectionListener> set = this.remoteListeners;
        synchronized (set) {
            this.remoteListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(EZSourceRemoteConnectionListener listener) {
        Set<EZSourceRemoteConnectionListener> set = this.remoteListeners;
        synchronized (set) {
            this.remoteListeners.remove(listener);
        }
    }

    @Override
    public ZkProjectInfo getProject(String name) {
        HashMap<String, ZkProjectInfo> projects = this.getAllProjects();
        return projects.get(name);
    }

    @Override
    public ZkProjectInfo getProject(UUID id) {
        ZkProjectInfo pi = null;
        HashMap<String, ZkProjectInfo> m = this.getAllProjects();
        for (String name : m.keySet()) {
            ZkProjectInfo p = (ZkProjectInfo)m.get(name);
            if (!p.getId().equals(id)) continue;
            pi = p;
            break;
        }
        return pi;
    }

    @Override
    public List<ZkProjectInfo> getProjects() {
        return new LinkedList<ZkProjectInfo>(this.getAllProjects().values());
    }

    @Override
    public DatabaseInfo getDatabaseInfo(UUID id) {
        return this.dbService != null ? (DatabaseInfo)this.dbService.getEntities().get(id) : null;
    }

    private HashMap<String, ZkProjectInfo> getAllProjects() {
        HashMap<String, ZkProjectInfo> r = new HashMap<String, ZkProjectInfo>();
        List<ZkProjectInfo> lst = this.projectService.getAllProjectsInfo();
        for (ZkProjectInfo pinfo : lst) {
            r.put(pinfo.getName(), pinfo);
        }
        return r;
    }

    private static enum State {
        Created,
        Initialized,
        Destroyed;

    }
}

