/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge.project;

import com.ez.ezdao.impl.Lifecycle;
import com.ez.ezsource.connection.zkbridge.SessionInfo;
import com.ez.ezsource.connection.zkbridge.project.JsonTemplate;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectConnection;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectConnectionFactory;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectConnectionImpl;
import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkEventListenerAdapter;
import com.ez.keeper.client.ZkNodeEvent;
import com.ez.keeper.client.ZkRequestEvent;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionFactory;
import com.ez.keeper.client.request.ZkCreatePathRequest;
import com.ez.keeper.client.request.ZkNodeExistsRequest;
import com.ez.keeper.client.request.ZkRequest;
import com.ez.keeper.client.request.ZkResult;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkProjectConnectionFactoryImpl
implements ZkProjectConnectionFactory {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(ZkProjectConnectionFactoryImpl.class);
    private final ZkSessionFactory sessionFactory;
    private final UUID environmentId;
    private final SessionInfo si;
    private ZkSession session;
    private Future<ZkResult> sessionMappingCheck;
    private boolean initialized = false;
    private final Object GUARD = new Object();

    public ZkProjectConnectionFactoryImpl(ZkSessionFactory sessionFactory, Configuration conf) {
        if (sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory");
        }
        if (conf == null || conf.isEmpty()) {
            throw new IllegalArgumentException("configuration");
        }
        this.sessionFactory = sessionFactory;
        this.si = (SessionInfo)conf.getProperty("sessionInfo");
        if (this.si == null) {
            throw new IllegalArgumentException("sessionInfo");
        }
        this.environmentId = (UUID)conf.getProperty("environmentId");
        if (this.environmentId == null) {
            throw new IllegalArgumentException("environmentId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZkProjectConnection create(Configuration conf) {
        Object object = this.GUARD;
        synchronized (object) {
            if (!this.initialized) {
                throw new IllegalStateException("Not initialized.");
            }
        }
        ZkProjectConnectionImpl pc = new ZkProjectConnectionImpl(conf);
        pc.initialize();
        return pc;
    }

    @Override
    public void destroy(ZkProjectConnection pc) {
        Lifecycle lc = (Lifecycle)pc;
        lc.uninitialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.GUARD;
        synchronized (object) {
            if (this.initialized) {
                throw new IllegalStateException("Already initialized.");
            }
        }
        this.session = this.sessionFactory.getSession();
        if (this.session == null) {
            throw new IllegalStateException("Can't get session.");
        }
        if (this.si != null) {
            this.initializeSessionMapping();
        }
        this.initialized = true;
    }

    public void uninitialize() {
        if (this.initialized) {
            if (this.si != null) {
                this.uninitializeSessionMapping();
            }
            try {
                this.sessionFactory.release(this.session);
            }
            catch (Exception ex) {
                L.error("Can't release factory.", (Throwable)ex);
            }
            this.session = null;
            this.initialized = false;
        }
    }

    private void initializeSessionMapping() {
        try {
            String node = JsonTemplate.getSessionMappingNode(this.si.getSessionId());
            this.sessionMappingCheck = this.session.executeAsync((ZkRequest)new ZkNodeExistsRequest(node), (ZkEventListener)new ZkEventListenerAdapter(){

                public void notifyNodeDeleted(ZkNodeEvent e) {
                    L.warn("Session node deleted, try recreate...");
                    ZkProjectConnectionFactoryImpl.this.createSessionNode();
                }

                public void notifyNodeStatAvailable(ZkNodeEvent e) {
                    if (e.getData() == null) {
                        L.warn("Session node doesn't exist, recreate...");
                        ZkProjectConnectionFactoryImpl.this.createSessionNode();
                    }
                }

                public void notifyRequestFinished(ZkRequestEvent e) {
                    if (!e.hasError() && e.getResult().getData() == null) {
                        L.warn("Session node doesn't exist, recreate...");
                        ZkProjectConnectionFactoryImpl.this.createSessionNode();
                    }
                }
            });
        }
        catch (Exception ex) {
            L.error("", (Throwable)ex);
        }
    }

    private void uninitializeSessionMapping() {
        if (this.sessionMappingCheck != null) {
            try {
                if (!this.sessionMappingCheck.cancel(false)) {
                    L.warn("Can't cancel session node recreation request.");
                }
            }
            catch (Exception ex) {
                L.error("", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessionNode() {
        Object object = this.GUARD;
        synchronized (object) {
            if (!this.initialized) {
                L.warn("Not initialized.");
            }
        }
        if (this.session == null) {
            L.info("session is null; will not create any sessionNode.");
        } else {
            String node = JsonTemplate.getSessionMappingNode(this.si.getSessionId());
            String data = JsonTemplate.getSessionNodePayload(this.environmentId, this.si, null);
            if (data != null) {
                try {
                    this.session.executeAsync((ZkRequest)new ZkCreatePathRequest(node, data, true, false), (ZkEventListener)new ZkEventListenerAdapter(){});
                    L.warn("Session node recreation request sent.");
                }
                catch (Exception ex) {
                    L.error("Can't create {}", (Object)node, (Object)ex);
                }
            }
        }
    }
}

