/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge.lock;

import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.zkbridge.lock.LockImplementation;
import com.ez.ezsource.connection.zkbridge.lock.LockImplementationFactory;
import com.ez.ezsource.connection.zkbridge.lock.ZkLockImplementation;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionFactory;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkLockImplementationFactory
implements LockImplementationFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ZkLockImplementationFactory.class);
    private final ZkSessionFactory factory;
    private final UUID appSessionId;
    private final UUID environmentId;
    private final long lockAcquireWaitTimeout;
    private boolean init = false;
    private ZkSession session;

    public ZkLockImplementationFactory(ZkSessionFactory factory, UUID environmentId, UUID appSessionId, long lockAcquireWaitTimeout) {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (environmentId == null) {
            throw new IllegalArgumentException("environmentId");
        }
        if (appSessionId == null) {
            throw new IllegalArgumentException("appSessionId");
        }
        this.factory = factory;
        this.environmentId = environmentId;
        this.appSessionId = appSessionId;
        this.lockAcquireWaitTimeout = lockAcquireWaitTimeout;
    }

    @Override
    public LockImplementation create(String projectName, UUID projectId) {
        if (!this.init) {
            throw new IllegalStateException("Not initialized.");
        }
        return new ZkLockImplementation(this.session, projectName, this.environmentId, projectId, this.appSessionId, this.lockAcquireWaitTimeout);
    }

    @Override
    public void release(LockImplementation facade) {
        if (!this.init) {
            throw new IllegalStateException("Not initialized.");
        }
        if (!(facade instanceof ZkLockImplementation)) {
            throw new IllegalArgumentException("Not a valid facade class.");
        }
        LockType type = facade.getProjectLockType();
        if (type != LockType.None) {
            ZkLockImplementation zkf = (ZkLockImplementation)facade;
            if (L.isTraceEnabled()) {
                L.trace("Project {}: residual lock {}.", new Object[]{zkf, type, new RuntimeException()});
            } else {
                L.error("Project {}: residual lock {}.", (Object)zkf, (Object)type);
            }
        }
    }

    @Override
    public void initialize() {
        if (this.init) {
            throw new IllegalStateException("Already initialized.");
        }
        this.session = this.factory.getSession();
        this.init = true;
    }

    @Override
    public void uninitialize() {
        if (this.init) {
            try {
                this.factory.release(this.session);
            }
            finally {
                this.session = null;
                this.init = false;
            }
        }
    }
}

