/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge.db;

import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.IGenericEntity;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.api.DatabaseInfoBuilder;
import com.ez.json.tools.binding.Path;
import com.ibm.ad.internal.PasswordUtils;
import java.math.BigDecimal;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBEntityAdapterFactoryImpl
implements EntityAdapterFactory {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(DBEntityAdapterFactoryImpl.class);
    public static final String DB_SERVER_TYPE_LEGACY = "EZ_JDBC_DRIVER";
    static final String FORCED_DB_SERVER_TYPE = System.getProperty("EZ_JDBC_DRIVER");

    public Object create(IGenericEntity entity, String type) {
        IGenericEntity ne = entity;
        switch (type) {
            case "project": 
            case "workspace": {
                L.error("type unsupported! {}", (Object)type);
                break;
            }
            case "sqldb": {
                ne = this.createDatabase(entity);
            }
        }
        return ne;
    }

    protected DatabaseInfo createDatabase(IGenericEntity entity) {
        Boolean validProtocol;
        Object data = entity.getData();
        String instance = (String)Path.getObject((Object)data, (String)"metadata.instance", String.class, (int)0);
        String host = (String)Path.getObject((Object)data, (String)"metadata.host", String.class, (int)0);
        BigDecimal port = (BigDecimal)Path.getObject((Object)data, (String)"metadata.port", BigDecimal.class, (int)0);
        String username = (String)Path.getObject((Object)data, (String)"metadata.username", String.class, (int)0);
        String serverType = (String)Path.getObject((Object)data, (String)"metadata.type", String.class, (int)0);
        String storageGroup = (String)Path.getObject((Object)data, (String)"metadata.storageGroup", String.class, (int)0);
        String nodeName = (String)Path.getObject((Object)data, (String)"metadata.name", String.class, (int)0);
        Boolean useTLS = (Boolean)Path.getObject((Object)data, (String)"metadata.useTLS", Boolean.class, (int)0);
        String protocol = (String)Path.getObject((Object)data, (String)"metadata.protocol", String.class, (int)0);
        Boolean trustServerCertificate = (Boolean)Path.getObject((Object)data, (String)"metadata.trustServerCertificate", Boolean.class, (int)0);
        String password = "";
        String formatVersion = (String)Path.getObject((Object)data, (String)"metadata.formatVersion", String.class, (int)0);
        password = formatVersion.equals("1.0") ? (String)Path.getObject((Object)data, (String)"metadata.password", String.class, (int)0) : (String)Path.getObject((Object)data, (String)"metadata.spad", String.class, (int)0);
        if (serverType == null) {
            L.warn("Server type not set.");
        }
        if (FORCED_DB_SERVER_TYPE != null) {
            L.warn("Server type forced to {} by system property (overrides {})", (Object)FORCED_DB_SERVER_TYPE, (Object)serverType);
            serverType = FORCED_DB_SERVER_TYPE;
        }
        DatabaseInfoBuilder b = DatabaseInfoBuilder.fromHost((String)serverType, (String)host);
        b.setUseTLS(Boolean.valueOf(BooleanUtils.isTrue((Boolean)useTLS)));
        b.setNodeName(nodeName);
        if (instance != null) {
            b.setInstance(instance);
        }
        if (port != null) {
            b.setPort(Integer.valueOf(port.intValue()));
        }
        if (username != null) {
            b.setUser(username);
        }
        if ((validProtocol = Boolean.valueOf(protocol != null && protocol.length() > 0)).booleanValue()) {
            b.setProtocol(protocol);
            L.info("TLS Protocol set to: " + protocol);
        } else {
            L.warn("TLS Protocol not set (empty / null) in zookeeper.");
        }
        if (trustServerCertificate != null) {
            b.setTrustServerCertificate(trustServerCertificate);
            L.info("trustServerCertificate set to: " + trustServerCertificate);
        } else if (serverType.equalsIgnoreCase("sqlserver")) {
            L.warn("trustServerCertificate not set (empty / null) in zookeeper.");
            if (validProtocol.booleanValue()) {
                if (protocol.equals("TLSv1.2")) {
                    L.error("Configuration error in zookeeper. Please set a value for trustServerCertificate. Will use default value: TRUE for protocol TLSv1.2.");
                    b.setTrustServerCertificate(Boolean.valueOf(true));
                } else if (protocol.equals("TLSv1.3")) {
                    L.error("Configuration error in zookeeper. Please set a value for trustServerCertificate. Will use default value: FALSE for protocol TLSv1.3.");
                    b.setTrustServerCertificate(Boolean.valueOf(false));
                }
            }
        }
        if (password != null && password.length() > 0) {
            String decPasswd = PasswordUtils.decrypt((String)password);
            b.setPassword(decPasswd);
        } else {
            L.debug("Password not set (empty / null).");
        }
        if (storageGroup != null) {
            b.setStorageGroup(storageGroup);
        }
        return b.build();
    }
}

