/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge;

import com.ez.ezsource.connection.zkbridge.SessionInfo;
import java.util.UUID;

public class SessionInfoBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    SessionInfo si;

    public static SessionInfoBuilder newBuilder(UUID sessionId) {
        SessionInfoBuilder b = new SessionInfoBuilder();
        b.si = new SessionInfo(sessionId);
        return b;
    }

    public SessionInfoBuilder setApplicationId(Integer applicationId) {
        if (this.si == null) {
            throw new IllegalStateException("Already built");
        }
        this.si.applicationId = applicationId;
        return this;
    }

    public SessionInfoBuilder setApplicationName(String applicationName) {
        if (this.si == null) {
            throw new IllegalStateException("Already built");
        }
        this.si.applicationName = applicationName;
        return this;
    }

    public SessionInfoBuilder setHost(String host) {
        if (this.si == null) {
            throw new IllegalStateException("Already built");
        }
        this.si.host = host;
        return this;
    }

    public SessionInfoBuilder setUsername(String username) {
        if (this.si == null) {
            throw new IllegalStateException("Already built");
        }
        this.si.username = username;
        return this;
    }

    public SessionInfoBuilder setDomain(String domain) {
        if (this.si == null) {
            throw new IllegalStateException("Already built");
        }
        this.si.domain = domain;
        return this;
    }

    public SessionInfo build() {
        if (this.si == null) {
            throw new IllegalStateException("Already built");
        }
        SessionInfo si = this.si;
        this.si = null;
        return si;
    }
}

