/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge;

import com.ez.authentication.Authentication;
import com.ez.ezdao.impl.DataConnectionFactory;
import com.ez.ezsource.connection.ConnectionConfiguration;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceConnectionFactory;
import com.ez.ezsource.connection.EZSourceConnectionStateEvent;
import com.ez.ezsource.connection.EZSourceNotificationListener;
import com.ez.ezsource.connection.EZSourceRemoteConnectionListener;
import com.ez.ezsource.connection.ProjectMode;
import com.ez.ezsource.connection.zkbridge.ProjectConnection;
import com.ez.ezsource.connection.zkbridge.ProjectConnectionConfiguration;
import com.ez.ezsource.connection.zkbridge.lock.LockImplementationFactory;
import com.ez.ezsource.connection.zkbridge.lock.ZkLockImplementationFactory;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectConnectionFactory;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectConnectionFactoryImpl;
import com.ez.keeper.client.ZkSessionFactory;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConnectionFactory
implements EZSourceConnectionFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectConnectionFactory.class);
    public static final String DLL_NAME = "ntlmauth";
    public static final String SYSTEM_PROPERTY_EZSOURCE_LIBRARY_PATH = "EZSOURCE_LIBRARY_PATH";
    final ThreadLocal<ProjectConnection> connection = new ThreadLocal();
    final Map<String, ProjectConnection> openConnections = new HashMap<String, ProjectConnection>();
    final Set<EZSourceRemoteConnectionListener> remoteListeners = new HashSet<EZSourceRemoteConnectionListener>();
    final RemoteConnectionEventDispatcher eventDispatcher = new RemoteConnectionEventDispatcher();
    Configuration conf;
    int usageCount = 0;
    private State state;
    private final Object stateGuard = new Object();
    final ZkProjectConnectionFactory projectConnFactory;
    final LockImplementationFactory lockFactory;
    final DataConnectionFactory dataConnFactory;
    UUID environmentId;
    String hfp;
    Integer application;
    UUID instanceSid;
    Timer closeTimer;
    private boolean fillPjInfo = true;

    public ProjectConnectionFactory(ZkSessionFactory sessionFactory, Configuration userConf, boolean fillProjectInfo) {
        if (userConf == null) {
            throw new IllegalArgumentException("userConf may not be null.");
        }
        if (sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory may not be null.");
        }
        CompositeConfiguration conf = new CompositeConfiguration();
        conf.addConfiguration(userConf);
        conf.addConfiguration(ProjectConnectionConfiguration.getInstance());
        try {
            this.environmentId = (UUID)conf.getProperty("environmentId");
        }
        catch (Exception ex) {
            L.trace("", (Throwable)ex);
        }
        if (this.environmentId == null) {
            try {
                this.environmentId = UUID.fromString(conf.getString("environmentId"));
                conf.setProperty("environmentId", (Object)this.environmentId);
            }
            catch (Exception ex) {
                L.trace("", (Throwable)ex);
            }
        }
        if (this.environmentId == null) {
            throw new IllegalArgumentException("Configuration not set: environmentId");
        }
        this.dataConnFactory = new DataConnectionFactory((Configuration)conf);
        this.conf = conf;
        try {
            this.instanceSid = (UUID)this.conf.getProperty("instanceSid");
        }
        catch (Exception ex) {
            L.trace("", (Throwable)ex);
        }
        if (this.instanceSid == null) {
            try {
                this.instanceSid = UUID.fromString(this.conf.getString("instanceSid", null));
            }
            catch (Exception ex) {
                L.trace("", (Throwable)ex);
            }
        }
        if (this.instanceSid == null) {
            throw new IllegalStateException("Configuration property missing: instanceSid");
        }
        this.application = this.conf.getInteger("applicationId", null);
        if (this.application == null) {
            throw new IllegalStateException("Configuration property missing: applicationId");
        }
        this.projectConnFactory = new ZkProjectConnectionFactoryImpl(sessionFactory, this.conf);
        long lockWaitAmount = conf.getLong("lockAcquireWait", 60000L);
        this.lockFactory = new ZkLockImplementationFactory(sessionFactory, this.environmentId, this.instanceSid, lockWaitAmount);
        this.fillPjInfo = fillProjectInfo;
        this.state = State.NotInitialized;
    }

    public ProjectConnectionFactory(ZkSessionFactory zkSessionFactory, Configuration configuration) {
        this(zkSessionFactory, configuration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != State.NotInitialized) {
                throw new IllegalStateException("Can't be initialized again.");
            }
            if (!this.conf.getBoolean("disableLicensing", false)) {
                String hfp = null;
                try {
                    this.loadAuthDll(this.conf.getString("dll.location"));
                }
                catch (Throwable t) {
                    L.error("Can't load auth dll.");
                }
                try {
                    hfp = System.getProperty("HFP");
                    if (hfp == null) {
                        Authentication auth = new Authentication();
                        hfp = auth.getFingerprint();
                    }
                }
                catch (Throwable ex) {
                    L.debug("Can't get fingerprint.", ex);
                    throw new RuntimeException("Can't get fingerprint.");
                }
                if (hfp == null) {
                    throw new RuntimeException("Can't get fingerprint.");
                }
                this.hfp = hfp;
            }
            this.projectConnFactory.initialize();
            boolean lockFactoryInit = false;
            try {
                this.lockFactory.initialize();
                lockFactoryInit = true;
            }
            finally {
                if (!lockFactoryInit) {
                    try {
                        this.projectConnFactory.uninitialize();
                    }
                    catch (Exception ex) {
                        L.error("", (Throwable)ex);
                    }
                }
            }
            this.state = State.Initialized;
            L.debug("New factory state: {}", (Object)this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninitialize() {
        Object object = this.stateGuard;
        synchronized (object) {
            this.checkInitialized();
            if (this.usageCount == 0) {
                this.uninitializeInstance();
            } else {
                Long waitForConnTimeout = this.conf.getLong("factoryShutdownConnectionWaitInterval", 20000L);
                L.warn("Still active connections, maybe release() not called for them.");
                L.info("Notifying active connections to close...");
                Map<String, ProjectConnection> map = this.openConnections;
                synchronized (map) {
                    L.warn("Still {} connections active.", (Object)this.openConnections.size());
                    for (ProjectConnection c : this.openConnections.values()) {
                        try {
                            c.notifyShutdown();
                        }
                        catch (Exception ex) {
                            L.error("Unexpected error.", (Throwable)ex);
                        }
                    }
                }
                L.info("Factory destroy postponed.");
                this.state = State.Closing;
                L.debug("New factory state: {}", (Object)this.state);
                this.closeTimer = new Timer("ConnCleanupTimer", true);
                this.closeTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ProjectConnectionFactory.this.lateUnitialize();
                    }
                }, waitForConnTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ProjectConnectionFactory projectConnectionFactory = this;
        synchronized (projectConnectionFactory) {
            return this.state == State.Uninitialized;
        }
    }

    @Deprecated
    public void addListener(EZSourceNotificationListener listener) {
        L.error("DEPRECATED. Use ProjectConnection.addListener() instead.");
    }

    @Deprecated
    public void removeListener(EZSourceNotificationListener listener) {
        L.error("DEPRECATED. Use ProjectConnection.removeListener() instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addRemoteConnectionListener(EZSourceRemoteConnectionListener listener) {
        Set<EZSourceRemoteConnectionListener> set = this.remoteListeners;
        synchronized (set) {
            this.remoteListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListener(EZSourceRemoteConnectionListener listener) {
        Set<EZSourceRemoteConnectionListener> set = this.remoteListeners;
        synchronized (set) {
            this.remoteListeners.remove(listener);
        }
    }

    public EZSourceConnection createConnection(ConnectionConfiguration configuration) {
        if (configuration.getProjectMode().equals((Object)ProjectMode.Environmental)) {
            throw new IllegalArgumentException("Project mode not supported: " + ProjectMode.Environmental);
        }
        return this.getCurrent(configuration);
    }

    public EZSourceConnection getCurrent() {
        return this.getCurrent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EZSourceConnection getCurrent(ConnectionConfiguration configuration) {
        ProjectConnection remote;
        block13: {
            this.checkInitialized();
            Object object = this.stateGuard;
            synchronized (object) {
                ++this.usageCount;
            }
            try {
                remote = this.connection.get();
                if (remote == null) {
                    L.info("No connection associated to current thread, creating new one.");
                    remote = new ProjectConnection(this.projectConnFactory, this.lockFactory, this.dataConnFactory, this.conf, this.fillPjInfo);
                    remote.initialize();
                    remote.addRemoteConnectionListener(this.eventDispatcher);
                    remote.openSession();
                    object = this.stateGuard;
                    synchronized (object) {
                        this.openConnections.put(remote.getSessionId(), remote);
                    }
                    remote.increaseUsage();
                    this.connection.set(remote);
                    break block13;
                }
                L.info("A connection already associated to current thread.");
                remote.increaseUsage();
            }
            catch (Exception ex) {
                Object object2 = this.stateGuard;
                synchronized (object2) {
                    --this.usageCount;
                }
                if (ex instanceof EZSourceConnectionException) {
                    throw (EZSourceConnectionException)ex;
                }
                throw new EZSourceConnectionException((Throwable)ex);
            }
        }
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(EZSourceConnection connection) {
        this.checkMayRelease();
        ProjectConnection remote = this.connection.get();
        if (remote == null) {
            throw new IllegalStateException("No EZSource connection associated to current thread; getCurrent() wasn't call before or  release() called too many times.");
        }
        remote.decreaseUsage();
        if (remote.getUsageCount() == 0) {
            String sessionId = remote.getSessionId();
            L.info("EZSource connection counter droped to 0, destroying...");
            this.connection.remove();
            remote.removeListener(this.eventDispatcher);
            try {
                remote.closeSession();
            }
            catch (Exception ex) {
                L.info("Can't close session, ignore error and do connection cleanup.", (Throwable)ex);
            }
            try {
                remote.uninitialize();
            }
            catch (Exception ex) {
                L.info("Can't uninitialize session, ignore.", (Throwable)ex);
            }
            Object object = this.stateGuard;
            synchronized (object) {
                this.openConnections.remove(sessionId);
            }
        }
        Object object = this.stateGuard;
        synchronized (object) {
            --this.usageCount;
            if (this.state == State.Closing && this.usageCount == 0) {
                L.info("Factory signaled to close, closing now.");
                this.closeTimer.cancel();
                this.closeTimer = null;
                this.uninitializeInstance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyMessage(String sessionId, String message) {
        ProjectConnection connection;
        L.debug("Notification received -- sid: {}", (Object)sessionId);
        Object object = this.stateGuard;
        synchronized (object) {
            connection = this.openConnections.get(sessionId);
        }
        if (connection == null) {
            L.error("Can't find connection for sid: {}", (Object)sessionId);
        } else {
            connection.notificationReceived(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void lateUnitialize() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state == State.Closing) {
                L.info("Notifying still active connections to close...");
                for (ProjectConnection c : this.openConnections.values()) {
                    try {
                        c.notifyShutdown();
                    }
                    catch (Exception ex) {
                        L.error("Unexpected error.", (Throwable)ex);
                    }
                }
                L.info("Connections notified to close.");
                if (this.openConnections.size() > 0) {
                    L.warn("Still {} connections active.", (Object)this.openConnections.size());
                    this.openConnections.clear();
                }
                this.closeTimer.cancel();
                this.closeTimer = null;
                this.uninitializeInstance();
            } else {
                L.info("Nothing to do, state: {}", (Object)State.Closing);
            }
        }
    }

    private void uninitializeInstance() {
        L.debug("Uninitializing factory...");
        try {
            try {
                this.lockFactory.uninitialize();
            }
            catch (Exception ex) {
                L.error("Unexpected error.", (Throwable)ex);
            }
            try {
                this.projectConnFactory.uninitialize();
            }
            catch (Exception ex) {
                L.error("Unexpected error.", (Throwable)ex);
            }
        }
        finally {
            this.application = null;
            this.hfp = null;
            this.instanceSid = null;
            this.state = State.Uninitialized;
            L.debug("New factory state: {}", (Object)this.state);
            L.debug("Factory uninitialized.");
        }
    }

    private void checkMayRelease() {
        if (this.state != State.Initialized && this.state != State.Closing) {
            throw new IllegalStateException(String.format("Illegal state: %s, expected %s or %s.", new Object[]{this.state, State.Initialized, State.Closing}));
        }
    }

    private void checkInitialized() {
        if (this.state != State.Initialized) {
            throw new IllegalStateException("Not initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchStateEvent(EZSourceConnectionStateEvent e) {
        EZSourceRemoteConnectionListener[] ls = new EZSourceRemoteConnectionListener[]{};
        EZSourceRemoteConnectionListener[] eZSourceRemoteConnectionListenerArray = this.stateGuard;
        synchronized (this.stateGuard) {
            ls = this.remoteListeners.toArray(ls);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (EZSourceRemoteConnectionListener l : ls) {
                try {
                    l.onRemoteNetworkEvent(e);
                }
                catch (Exception ex) {
                    L.error("Listener failed.", (Throwable)ex);
                }
            }
            return;
        }
    }

    private void loadAuthDll(String dllLocation) {
        String dllDirPath;
        L.info("java.library.path={}", (Object)System.getProperty("java.library.path"));
        boolean done = false;
        if (dllLocation != null) {
            L.info("Forced dll locaton location: {}", (Object)dllLocation);
            done = this.load(dllLocation);
        }
        if (!done && (dllDirPath = System.getProperty(SYSTEM_PROPERTY_EZSOURCE_LIBRARY_PATH)) != null) {
            L.info("EZSOURCE_LIBRARY_PATH={}", (Object)dllDirPath);
            done = this.load(dllDirPath);
        }
        if (!done) {
            L.info("{} will be loaded from system default location.", (Object)DLL_NAME);
            System.loadLibrary(DLL_NAME);
        }
    }

    private boolean load(String location) {
        File dllFile = new File(location, "ntlmauth.dll");
        boolean isDllLoaded = false;
        if (dllFile != null) {
            if (!dllFile.exists()) {
                L.info("File doesn't exist: {}", (Object)dllFile);
            } else {
                L.info("{} is loaded from {}", (Object)DLL_NAME, (Object)dllFile);
                System.load(dllFile.getAbsolutePath());
                isDllLoaded = true;
            }
        }
        return isDllLoaded;
    }

    private class RemoteConnectionEventDispatcher
    implements EZSourceRemoteConnectionListener {
        private RemoteConnectionEventDispatcher() {
        }

        public void onRemoteNetworkEvent(EZSourceConnectionStateEvent e) {
        }
    }

    private static enum State {
        NotInitialized,
        Initialized,
        Closing,
        Uninitialized;

    }
}

