/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.zkbridge;

import com.ez.ezdao.api.DatabaseException;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.api.DatabaseInfoBuilder;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezdao.impl.DataConnectionFactory;
import com.ez.ezdao.impl.DataOperation;
import com.ez.ezdao.impl.JdbcDataOperation;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceConnectionListener;
import com.ez.ezsource.connection.EZSourceRemoteConnectionListener;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.ProjectInfoFactory;
import com.ez.ezsource.connection.ResourceType;
import com.ez.ezsource.connection.ResourceTypeInfo;
import com.ez.ezsource.connection.ServerType;
import com.ez.ezsource.connection.zkbridge.SqlQueries;
import com.ez.ezsource.connection.zkbridge.lock.LockImplementation;
import com.ez.ezsource.connection.zkbridge.lock.LockImplementationFactory;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectConnection;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectConnectionFactory;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectInfo;
import com.ez.ezsource.connection.zkbridge.proxy.Proxies;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConnection
implements EZSourceConnection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectConnection.class);
    private HashMap<String, String> SQL_QUERIES;
    private HashMap<String, String> SQL_FRAGMENTS;
    private int usageCount = 0;
    private final Set<EZSourceConnectionListener> notifyListeners = new HashSet<EZSourceConnectionListener>();
    private final Set<EZSourceRemoteConnectionListener> remoteNotifyListeners = new HashSet<EZSourceRemoteConnectionListener>();
    private DataOperation origDataConn;
    private ZkProjectConnection prjConnImpl;
    private DataOperation dataConn;
    private LockImplementation lockFacade;
    private int dataConnCounter = 0;
    private String sessionId;
    private boolean isShuttingDown;
    private ProjectInfo pi = null;
    private boolean fillProjInfo = true;
    private final ZkProjectConnectionFactory projConnFactory;
    private final DataConnectionFactory dataConnFactory;
    private final LockImplementationFactory lockFactory;
    private final Configuration conf;
    private final Object stateGuard = new Object();
    private final OperationController dataOpCtrl = new DataOperationController();
    private OperationController currentOpCtrl = null;
    private State state;

    ProjectConnection(ZkProjectConnectionFactory projConnFactory, LockImplementationFactory lockFactory, DataConnectionFactory connFactory, Configuration conf) {
        this(projConnFactory, lockFactory, connFactory, conf, true);
    }

    ProjectConnection(ZkProjectConnectionFactory projectConnFactory, LockImplementationFactory lockFactory, DataConnectionFactory dataConnFactory, Configuration conf, boolean fillPjInfo) {
        if (projectConnFactory == null) {
            throw new IllegalArgumentException("projConnFactory");
        }
        if (lockFactory == null) {
            throw new IllegalArgumentException("lockFactory");
        }
        if (dataConnFactory == null) {
            throw new IllegalArgumentException("dataConnFactory");
        }
        if (conf == null) {
            throw new IllegalArgumentException("conf");
        }
        this.conf = conf;
        this.projConnFactory = projectConnFactory;
        this.lockFactory = lockFactory;
        this.dataConnFactory = dataConnFactory;
        this.fillProjInfo = fillPjInfo;
        this.state = State.Created;
    }

    public void addListener(EZSourceConnectionListener listener) {
        this.checkState();
        L.info("addListener(EZSourceConnectionListener listener): DUMMY");
    }

    public void removeListener(EZSourceConnectionListener listener) {
        this.checkState(true);
        L.info("removeListener(EZSourceConnectionListener listener): DUMMY");
    }

    public synchronized void addRemoteConnectionListener(EZSourceRemoteConnectionListener listener) {
        this.checkState();
        L.info("addRemoteConnectionListener(EZSourceRemoteConnectionListener listener): DUMMY");
    }

    public synchronized void removeListener(EZSourceRemoteConnectionListener listener) {
        this.checkState(true);
        L.info("removeListener(EZSourceRemoteConnectionListener listener): DUMMY");
    }

    public String[] getProjects() {
        this.checkState();
        LinkedList<String> r = new LinkedList<String>();
        try {
            List<ZkProjectInfo> prjs = this.prjConnImpl.getProjects();
            for (ZkProjectInfo p : prjs) {
                r.add(p.getName());
            }
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return r.toArray(new String[0]);
    }

    public void updateFileTag(String projectName, String filePath, ResourceType rt) {
        throw new RuntimeException("Not implemented.");
    }

    public void updateFileTag(String projectName, String filePath, ResourceTypeInfo rti) {
        throw new RuntimeException("Not implemented.");
    }

    public void openProject(String projectName) {
        this.checkState();
        if (this.pi != null) {
            throw new IllegalStateException("Project already open: " + this.pi);
        }
        try {
            ZkProjectInfo zkpi = this.prjConnImpl.getProject(projectName);
            if (zkpi == null) {
                throw new EZSourceConnectionException("No such project: " + projectName);
            }
            this.openProject(zkpi);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public void openProject(UUID projectId) {
        this.checkState();
        if (this.pi != null) {
            throw new IllegalStateException("Project already open: " + this.pi);
        }
        try {
            ZkProjectInfo zkpi = this.prjConnImpl.getProject(projectId);
            if (zkpi == null) {
                throw new EZSourceConnectionException("No project with id: " + projectId);
            }
            this.openProject(zkpi);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public void closeProject() {
        this.checkState(true);
        if (this.pi == null) {
            throw new IllegalStateException("Project not opened.");
        }
        try {
            try {
                this.lockFacade.closeProject();
            }
            catch (Exception ex) {
                L.error("", (Throwable)ex);
            }
            try {
                if (this.dataConnCounter > 0) {
                    L.warn("Closing project: database opened.");
                    this.closeDatabaseConnection();
                }
            }
            finally {
                this.pi = null;
            }
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public void openConnection() {
        this.checkState();
        if (this.pi == null) {
            throw new IllegalStateException("Project not opened.");
        }
        try {
            this.ensureDataConnection();
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public void closeConnection() {
        this.checkState(true);
        if (this.dataConnCounter <= 0) {
            throw new IllegalStateException("Data connection already closed / not opened.");
        }
        try {
            if (this.dataConnCounter > 0) {
                this.closeDatabaseConnection();
            }
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public String[][] executeSQL(String sql, Object[] params) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        String[][] r = null;
        try {
            r = this.dataConn.executeSql(sql, params);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return r;
    }

    public String[][] executeSQL(String sql) {
        return this.executeSQL(sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] executeSQL(String sql, List<EZSourceDataType> types, List<?> values) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        String[][] rez = null;
        try {
            L.trace("in: executeSQL()");
            boolean ok = false;
            this.cleanTempTables();
            this.fillTempTable(types, values);
            try {
                rez = this.dataConn.executeSql(sql);
                ok = true;
            }
            finally {
                try {
                    this.cleanTempTables();
                }
                catch (EZSourceConnectionException ex) {
                    if (ok) {
                        throw ex;
                    }
                    L.error("Can't clean temporary tables", (Throwable)ex);
                }
            }
            L.trace("out: executeSQL()");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return rez;
    }

    public NonBlockingOperationHandle beginExecuteSQL(String sql, int rowsCount) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        NonBlockingOperationHandle h = null;
        try {
            h = this.doBeginExecuteSql(sql, null, null, rowsCount);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return h;
    }

    public NonBlockingOperationHandle beginExecuteSQL(String queryString, List<EZSourceDataType> varParamsTypes, List<?> varParams, int rowsCount) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        NonBlockingOperationHandle h = null;
        try {
            h = this.doBeginExecuteSql(queryString, varParamsTypes, varParams, rowsCount);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return h;
    }

    @Deprecated
    public String[][] execStoredProc(String procedureName, String[] paramsList) {
        throw new RuntimeException("Pseudo procedure call not implemented.");
    }

    @Deprecated
    public String[][] execStoredProc(String procedureName, String[] paramsList, List<EZSourceDataType> types, List<?> values) {
        throw new RuntimeException("Pseudo procedure call not implemented.");
    }

    public String[][] execNonTransactionalStoredProc(String procedureName, String[] paramsList) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        String[][] rez = null;
        try {
            L.trace("in: execNonTransactionalStoredProc(procedure, parameters)");
            rez = this.dataConn.execStoredProc(procedureName, paramsList != null ? paramsList : new String[]{});
            L.trace("out: execNonTransactionalStoredProc(procedure, parameters)");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return rez;
    }

    public String[][] execNonTransactionalStoredProc(String procedureName, Object[] paramsList) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        String[][] rez = null;
        try {
            L.trace("in: execNonTransactionalStoredProc(procedure, parameters)");
            rez = this.dataConn.execStoredProc(procedureName, paramsList != null ? paramsList : new Object[]{});
            L.trace("out: execNonTransactionalStoredProc(procedure, parameters)");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return rez;
    }

    public String[][] execNonTransactionalStoredProc(String procedureName, Object[] paramsList, ParameterInfo[] paramsInfo) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        String[][] rez = null;
        try {
            L.trace("in: execNonTransactionalStoredProc(procedures, parameters, parameters info)");
            rez = this.dataConn.execStoredProc(procedureName, paramsList != null ? paramsList : new Object[]{}, paramsInfo != null ? paramsInfo : new ParameterInfo[]{});
            L.trace("out: execNonTransactionalStoredProc(procedures, parameters, parameters info)");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return rez;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] execNonTransactionalStoredProc(String procedureName, String[] paramsList, List<EZSourceDataType> types, List<?> values) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        String[][] rez = null;
        try {
            boolean ok = false;
            this.cleanTempTables();
            this.fillTempTable(types, values);
            try {
                L.trace("in: execNonTransactionalStoredProc(procedure, parameters, types, values)");
                rez = this.dataConn.execStoredProc(procedureName, paramsList != null ? paramsList : new String[]{});
                L.trace("out: execNonTransactionalStoredProc(procedure, parameters, types, values)");
                ok = true;
            }
            finally {
                try {
                    this.cleanTempTables();
                }
                catch (EZSourceConnectionException ex) {
                    if (ok) {
                        throw ex;
                    }
                    L.error("Can't clean temporary tables", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return rez;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] execNonTransactionalStoredProc(String procedureName, Object[] paramsList, ParameterInfo[] paramsInfo, List<EZSourceDataType> types, List<?> values) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        String[][] rez = null;
        try {
            boolean ok = false;
            this.cleanTempTables();
            this.fillTempTable(types, values);
            try {
                L.trace("in: execNonTransactionalStoredProc(procedure, parameters, parameters info, types, values)");
                rez = this.dataConn.execStoredProc(procedureName, paramsList != null ? paramsList : new Object[]{}, paramsInfo != null ? paramsInfo : new ParameterInfo[]{});
                L.trace("out: execNonTransactionalStoredProc(procedure, parameters, parameters info, types, values)");
                ok = true;
            }
            finally {
                try {
                    this.cleanTempTables();
                }
                catch (EZSourceConnectionException ex) {
                    if (ok) {
                        throw ex;
                    }
                    L.error("Can't clean temporary tables", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return rez;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] execNonTransactionalStoredProc(String procedureName, Object[] paramsList, List<EZSourceDataType> types, List<?> values) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        String[][] rez = null;
        try {
            boolean ok = false;
            this.cleanTempTables();
            this.fillTempTable(types, values);
            try {
                L.trace("in: execNonTransactionalStoredProc(procedure, parameters, types, values) with list of parameters as Objects");
                rez = this.dataConn.execStoredProc(procedureName, paramsList != null ? paramsList : new Object[]{});
                L.trace("out: execNonTransactionalStoredProc(procedure, parameters, types, values)");
                ok = true;
            }
            finally {
                try {
                    this.cleanTempTables();
                }
                catch (EZSourceConnectionException ex) {
                    if (ok) {
                        throw ex;
                    }
                    L.error("Can't clean temporary tables", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return rez;
    }

    public NonBlockingOperationHandle beginNonTransactionalStoredProc(String procName, Object[] paramsList, int rowsCount) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        NonBlockingOperationHandle h = null;
        try {
            h = this.doBeginNonTransactionalStoredProc(procName, paramsList, null, null, rowsCount);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return h;
    }

    public NonBlockingOperationHandle beginNonTransactionalStoredProc(String procName, String[] paramsList, int rowsCount) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        NonBlockingOperationHandle h = null;
        try {
            h = this.doBeginNonTransactionalStoredProc(procName, paramsList, null, null, rowsCount);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return h;
    }

    public NonBlockingOperationHandle beginNonTransactionalStoredProc(String procName, String[] paramsList, List<EZSourceDataType> varParamsTypes, List<?> varParams, int rowsCount) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        NonBlockingOperationHandle h = null;
        try {
            h = this.doBeginNonTransactionalStoredProc(procName, paramsList, varParamsTypes, varParams, rowsCount);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return h;
    }

    public int[] execBatch(String sql, Object[][] params) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        int[] r = null;
        try {
            L.trace("in: execBatch()");
            r = this.dataConn.execBatch(sql, params);
            L.trace("out: execBatch()");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return r;
    }

    public void insertBatch(String table, String[][] recordSet, List<EZSourceDataType> types) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        try {
            L.trace("in: insertBatch()");
            this.dataConn.insertBatch(table, recordSet, types);
            L.trace("out: insertBatch()");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public void executeInsert(String sql) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        try {
            L.trace("in: executeInsert()");
            this.dataConn.executeInsert(sql);
            L.trace("out: executeInsert()");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public void executeUpdate(String sql) {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        try {
            L.trace("in: executeUpdate()");
            this.dataConn.executeUpdate(sql);
            L.trace("out: executeUpdate()");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public String getOpenedProject() {
        this.checkState();
        String pname = null;
        try {
            pname = this.pi != null ? this.pi.getProjectName() : null;
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return pname;
    }

    public ProjectInfo getProjectInfo() {
        this.checkState();
        if (this.pi == null) {
            throw new IllegalStateException("Project not opened.");
        }
        return this.pi;
    }

    public ProjectInfo getRefreshedProjectInfo() {
        this.checkState();
        if (this.pi == null) {
            throw new IllegalStateException("Project not opened.");
        }
        try {
            ZkProjectInfo zkpi = this.prjConnImpl.getProject(this.pi.getProjectName());
            if (zkpi == null) {
                throw new EZSourceConnectionException("No such project: " + this.pi.getProjectName());
            }
            ProjectInfoFactory b = new ProjectInfoFactory(this.pi);
            b.setUSeBRD(zkpi.useBRD());
            b.setUseCross(zkpi.useCross());
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return this.pi;
    }

    public void beginTransaction() {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        try {
            L.trace("in: beginTransaction()");
            this.dataConn.beginTransaction();
            L.trace("out: beginTransaction()");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public void endTransaction() {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        try {
            L.debug("in: endTransaction()");
            this.dataConn.endTransaction();
            L.debug("out: endTransaction()");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public void voteCommitTransaction() {
        this.checkState();
        if (this.dataConnCounter == 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        try {
            L.debug("in: voteCommitTransaction()");
            this.dataConn.voteCommitTransaction();
            L.debug("out: voteCommitTransaction()");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public void voteRollbackTransaction() {
        this.checkState();
        if (this.dataConnCounter <= 0) {
            throw new IllegalArgumentException("Data connection not opened.");
        }
        try {
            L.debug("in: voteCommitTransaction()");
            this.dataConn.voteRollbackTransaction();
            L.debug("out: voteRollbackTransaction()");
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
    }

    public boolean acquireProjectLock(LockType type) {
        this.checkState();
        if (this.pi == null) {
            throw new IllegalStateException("Project not opened.");
        }
        boolean ok = false;
        try {
            ok = this.lockFacade.acquireProjectLock(type);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return ok;
    }

    public boolean acquireProjectLock(LockType type, long timeout) {
        this.checkState();
        if (this.pi == null) {
            throw new IllegalStateException("Project not opened.");
        }
        boolean ok = false;
        try {
            ok = this.lockFacade.acquireProjectLock(type, timeout);
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return ok;
    }

    public boolean releaseProjectLock() {
        this.checkState();
        if (this.pi == null) {
            throw new IllegalStateException("Project not opened.");
        }
        boolean ok = false;
        try {
            ok = this.lockFacade.releaseProjectLock();
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return ok;
    }

    public LockType getProjectLockType() {
        this.checkState();
        if (this.pi == null) {
            throw new IllegalStateException("Project not opened.");
        }
        LockType type = LockType.None;
        try {
            type = this.lockFacade.getProjectLockType();
        }
        catch (Exception ex) {
            this.handleEx(ex);
        }
        return type;
    }

    public void setCurrentOperation(int operation) {
        L.debug("setCurrentOperation() DUMMY");
        this.checkState();
    }

    public void setCurrentOperation(int operation, Map<String, String> params) {
        L.info("setCurrentOperation() DUMMY");
        this.checkState();
    }

    public void unsetCurrentOperation() {
        L.info("unsetCurrentOperation() DUMMY");
        this.checkState();
    }

    public void unsetCurrentOperation(Map<String, String> params) {
        L.info("unsetCurrentOperation() DUMMY");
        this.checkState();
    }

    public boolean isOperationAllowed(int operation) {
        L.info("isOperationAllowed() DUMMY");
        this.checkState();
        return true;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    void openSession() {
        this.sessionId = UUID.randomUUID().toString();
    }

    void closeSession() {
    }

    private void openDataConnection(DatabaseInfo dbi) {
        if (this.dataConnCounter > 0) {
            throw new IllegalStateException("Database connection already opened.");
        }
        this.origDataConn = this.dataConnFactory.create(dbi.getDatabase(), dbi);
        this.dataConn = this.createDataProxy(this.origDataConn);
        this.dataConnCounter = 1;
        this.initQueries(dbi.getServerType());
        this.createTempTables(dbi);
    }

    void closeDatabaseConnection() {
        this.safeDropTempTables();
        this.uninitQueries();
        try {
            this.dataConnFactory.destroy(this.origDataConn);
        }
        finally {
            this.dataConnCounter = 0;
            this.origDataConn = null;
            this.dataConn = null;
        }
    }

    private void ensureDataConnection() {
        if (this.dataConn == null) {
            this.openDataConnection(this.pi.getDatabaseInfo());
        } else {
            ++this.dataConnCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        Object object = this.stateGuard;
        synchronized (object) {
            this.prjConnImpl = this.projConnFactory.create(this.conf);
            try {
                this.lockFacade = this.lockFactory.create(null, null);
            }
            finally {
                if (this.lockFacade == null) {
                    try {
                        L.error("Can't create lock provider, project factory will be destroyed.");
                        this.projConnFactory.destroy(this.prjConnImpl);
                    }
                    catch (Exception ex) {
                        L.error("Can't destroy project factory.", (Throwable)ex);
                    }
                    finally {
                        this.prjConnImpl = null;
                    }
                }
            }
            this.state = State.Initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninitialize() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != State.Closed) {
                try {
                    try {
                        this.lockFactory.release(this.lockFacade);
                    }
                    catch (Exception ex) {
                        L.error("", (Throwable)ex);
                    }
                    finally {
                        this.lockFacade = null;
                    }
                    try {
                        this.projConnFactory.destroy(this.prjConnImpl);
                    }
                    catch (Exception ex) {
                        L.error("", (Throwable)ex);
                    }
                    finally {
                        this.prjConnImpl = null;
                    }
                    if (this.dataConnCounter > 0) {
                        L.error("Database connection not closed.");
                        if (L.isDebugEnabled()) {
                            L.debug("Stack: {}", (Throwable)new RuntimeException());
                        }
                        this.closeDatabaseConnection();
                    }
                }
                finally {
                    this.state = State.Closed;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyShutdown() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state == State.Working) {
                if (this.currentOpCtrl != null) {
                    L.debug("Start canceling...");
                    this.currentOpCtrl.cancel();
                } else {
                    L.debug("Controller not set.");
                }
                this.state = State.Canceling;
            }
            this.isShuttingDown = true;
        }
    }

    void increaseUsage() {
        ++this.usageCount;
    }

    void decreaseUsage() {
        --this.usageCount;
    }

    int getUsageCount() {
        return this.usageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notificationReceived(String message) {
        L.debug("Notification received, dispatching...");
        HashSet<EZSourceConnectionListener> all = null;
        Set<EZSourceConnectionListener> set = this.notifyListeners;
        synchronized (set) {
            if (this.notifyListeners.size() > 0) {
                all = new HashSet<EZSourceConnectionListener>(this.notifyListeners);
            } else {
                L.debug("No listeners.");
            }
        }
        if (all != null) {
            for (EZSourceConnectionListener l : all) {
                try {
                    l.notify((EZSourceConnection)this, message);
                }
                catch (Exception ex) {
                    L.error("Can't dispatch notification.", (Throwable)ex);
                }
            }
        }
    }

    private NonBlockingOperationHandle doBeginNonTransactionalStoredProc(String procName, Object[] paramsList, List<EZSourceDataType> varParamsTypes, List<?> varParams, int rowsCount) {
        boolean cleanTmpTables;
        boolean bl = cleanTmpTables = varParams != null && varParams.size() > 0;
        if (rowsCount <= 0) {
            throw new IllegalArgumentException("rowsCount must be > 0");
        }
        L.trace("Begin nonblocking procedure call...");
        if (varParams != null && varParams.size() > 0) {
            this.cleanTempTables();
            this.fillTempTable(varParamsTypes, varParams);
        }
        L.trace("Initiating...");
        Integer totalRowsCount = this.dataConn.beginStoredProc(procName, paramsList != null ? paramsList : new String[]{}, rowsCount);
        L.trace("Initiation done.");
        NonBlockingOperationHandleImpl h = new NonBlockingOperationHandleImpl(rowsCount, totalRowsCount, cleanTmpTables, this.dataConn.finished());
        L.trace("End nonblocking procedure call.");
        return h;
    }

    private NonBlockingOperationHandle doBeginExecuteSql(String queryString, List<EZSourceDataType> varParamsTypes, List<?> varParams, int rowsCount) {
        boolean cleanTmpTables;
        boolean bl = cleanTmpTables = varParams != null && varParams.size() > 0;
        if (rowsCount <= 0) {
            throw new IllegalArgumentException("rowsCount must be > 0");
        }
        L.trace("Begin nonblocking execute sql...");
        if (varParams != null && varParams.size() > 0) {
            this.cleanTempTables();
            this.fillTempTable(varParamsTypes, varParams);
        }
        L.trace("Initiating...");
        Integer totalRowsCount = this.dataConn.beginExecuteSql(queryString, rowsCount);
        L.trace("Initiation done.");
        NonBlockingOperationHandleImpl h = new NonBlockingOperationHandleImpl(rowsCount, totalRowsCount, cleanTmpTables, this.dataConn.finished());
        L.trace("End nonblocking execute sql.");
        return h;
    }

    private void createTempTables(DatabaseInfo dbi) {
        L.trace("Creating temp table numeric_param_temp");
        try {
            this.dataConn.executeUpdate(this.getQuery("SQL_CREATE_NUM_PARAM"));
            L.trace("Table created.");
        }
        catch (Exception ex) {
            this.handleCreateTempTableEx(ex, dbi);
        }
        L.trace("Creating temp table string_param_temp");
        try {
            this.dataConn.executeUpdate(this.getQuery("SQL_CREATE_STRING_PARAM"));
            L.trace("Table created.");
        }
        catch (Exception ex) {
            this.handleCreateTempTableEx(ex, dbi);
        }
    }

    private void handleCreateTempTableEx(Exception ex, DatabaseInfo dbi) {
        Exception cex;
        boolean rethrow = true;
        L.debug("Failed to create temporary table.");
        if (ex instanceof DatabaseException && (cex = (Exception)ex.getCause()) instanceof SQLException) {
            int error = ((SQLException)cex).getErrorCode();
            L.debug("Error code: {}", (Object)error);
            if (error == 2714 && dbi.getServerType().equalsIgnoreCase("sqlserver") || error == -601 && dbi.getServerType().equalsIgnoreCase("db2z")) {
                rethrow = false;
            }
        }
        if (rethrow) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        L.debug(ex.getMessage());
    }

    private void fillTempTable(List<EZSourceDataType> types, List<?> values) {
        if (types.size() != values.size()) {
            throw new IllegalArgumentException("types and values must have same size.");
        }
        int k = 0;
        ArrayList<String[]> list1 = new ArrayList<String[]>();
        ArrayList<String[]> list2 = new ArrayList<String[]>();
        for (Object p : values) {
            EZSourceDataType t = types.get(k++);
            if (p == null) continue;
            if (t == EZSourceDataType.String) {
                if (p instanceof String) {
                    list1.add(new String[]{(String)p});
                    continue;
                }
                String str = p != null ? p.toString() : null;
                list1.add(new String[]{p != null ? p.toString() : null});
                L.warn(String.format("Non string parameter %s with type string. See trace for more details.", str == null ? "'null'" : str));
                L.trace("Non string parameter ({}) with type string.", p.getClass());
                continue;
            }
            if (p instanceof String) {
                list2.add(new String[]{(String)p});
                continue;
            }
            list2.add(new String[]{p != null ? p.toString() : null});
        }
        if (!list1.isEmpty()) {
            String[][] stringList = (String[][])list1.toArray((T[])new String[0][]);
            ArrayList<EZSourceDataType> stringTypes = new ArrayList<EZSourceDataType>();
            stringTypes.add(EZSourceDataType.String);
            this.insertBatch(this.getFragement("SQL_TABLE_STRING_PARAM"), stringList, stringTypes);
        }
        if (!list2.isEmpty()) {
            String[][] intList = (String[][])list2.toArray((T[])new String[0][]);
            ArrayList<EZSourceDataType> intTypes = new ArrayList<EZSourceDataType>();
            intTypes.add(EZSourceDataType.Integer);
            this.insertBatch(this.getFragement("SQL_TABLE_NUMERIC_PARAM"), intList, intTypes);
        }
    }

    private void cleanTempTables() {
        L.trace("clean numeric_param_temp temp table table");
        this.dataConn.executeUpdate(this.getQuery("SQL_CLEAR_NUM_PARAM"));
        L.trace("delete done.");
        L.trace("clean string_param_temp temp table");
        this.dataConn.executeUpdate(this.getQuery("SQL_CLEAR_STRING_PARAM"));
        L.trace("delete done.");
    }

    private void safeDropTempTables() {
        L.trace("Clear numeric_param_temp temp table");
        try {
            this.dataConn.executeUpdate(this.getQuery("SQL_CLEAR_NUM_PARAM"));
        }
        catch (Exception ex) {
            L.debug("Clear numeric_param_temp failed.", (Throwable)ex);
        }
        L.trace("Clear done.");
        L.trace("Clear string_param_temp temp table");
        try {
            this.dataConn.executeUpdate(this.getQuery("SQL_CLEAR_STRING_PARAM"));
        }
        catch (Exception ex) {
            L.debug("Clear string_param_temp failed.", (Throwable)ex);
        }
        L.trace("drop done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProject(ZkProjectInfo zkpi) {
        ProjectInfoFactory b;
        String projectName = zkpi.getName();
        Long projectType = zkpi.getProjectType();
        if (projectType != null && projectType.equals(Long.valueOf("16384"))) {
            try {
                b = new ProjectInfoFactory(this.fillProjInfo, projectName, zkpi.getProjectType(), zkpi.getlocalPath(), null, zkpi.useBRD(), zkpi.useCross(), zkpi.getId());
                b.setUMCDB(false);
                b.setOnMainframe(zkpi.isOnMainframe());
                b.setLastBuild(zkpi.getLastBuild());
                b.setMetadataJson(zkpi.getMetadataJson());
                this.pi = b.build();
            }
            catch (Throwable th) {
                L.error("Error building information for project: {}", (Object)projectName, (Object)th);
            }
        } else {
            UUID dbId = zkpi.getDbId();
            if (dbId == null) {
                throw new EZSourceConnectionException(String.format("Project %s: database info not set.", projectName));
            }
            String database = zkpi.getDatabase();
            if (database == null) {
                throw new EZSourceConnectionException(String.format("Project %s: database name not set.", projectName));
            }
            String schema = zkpi.getDatabaseSchema();
            DatabaseInfo dbi = this.prjConnImpl.getDatabaseInfo(dbId);
            if (dbi == null) {
                throw new EZSourceConnectionException(String.format("Project %s: database server id %s not found.", projectName, dbId));
            }
            if (dbi.useDomainAuth()) {
                L.debug("Project {}: single sign on enabled.", (Object)projectName);
            } else {
                L.debug("Project {}: database authentication enabled.", (Object)projectName);
            }
            DatabaseInfoBuilder dbib = DatabaseInfoBuilder.from((DatabaseInfo)dbi);
            dbib.setDatabase(database);
            dbib.setSchema(schema);
            dbi = dbib.build();
            try {
                b = new ProjectInfoFactory(this.fillProjInfo, projectName, zkpi.getProjectType(), zkpi.getlocalPath(), dbi, zkpi.useBRD(), zkpi.useCross(), zkpi.getId());
                b.setUMCDB(false);
                b.setOnMainframe(zkpi.isOnMainframe());
                b.setLastBuild(zkpi.getLastBuild());
                b.setMetadataJson(zkpi.getMetadataJson());
                this.pi = b.build();
            }
            catch (Throwable th) {
                L.error("Error building information for project: {}", (Object)projectName, (Object)th);
            }
        }
        boolean ok = false;
        try {
            this.lockFacade.openProject(projectName, zkpi.getId());
            ok = true;
        }
        finally {
            if (!ok) {
                this.pi = null;
            }
        }
    }

    private void checkState() {
        this.checkState(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(boolean allowClosing) {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state == State.Canceling) {
                if (!allowClosing) {
                    throw new IllegalStateException("Operation was canceled.");
                }
            } else {
                if (this.state != State.Initialized) {
                    throw new IllegalStateException(this.state.toString());
                }
                if (this.isShuttingDown && !allowClosing) {
                    throw new IllegalStateException("The factory is shutting down. The connection must be closed.");
                }
            }
        }
    }

    private DataOperation createDataProxy(Object target) {
        return (DataOperation)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{DataOperation.class}, (InvocationHandler)new ConnectionInvocationHandler(target, this.dataOpCtrl, JdbcDataOperation.class));
    }

    private void initQueries(String serverType) {
        if (serverType.equalsIgnoreCase("db2")) {
            this.SQL_QUERIES = SqlQueries.DB2_QUERIES;
            this.SQL_FRAGMENTS = SqlQueries.DB2_FRAGMENTS;
        } else if (serverType.equalsIgnoreCase("db2z")) {
            this.SQL_QUERIES = SqlQueries.DB2_ZOS_QUERIES;
            this.SQL_FRAGMENTS = SqlQueries.DB2_ZOS_FRAGMENTS;
        } else if (serverType.equalsIgnoreCase("sqlserver")) {
            this.SQL_QUERIES = SqlQueries.SQL_SERVER_QUERIES;
            this.SQL_FRAGMENTS = SqlQueries.SQL_SERVER_FRAGMENTS;
        } else {
            throw new DatabaseException("Unknown server type: " + serverType);
        }
    }

    private void uninitQueries() {
        this.SQL_QUERIES = null;
        this.SQL_FRAGMENTS = null;
    }

    private final String getQuery(String queryKey) {
        String query = this.SQL_QUERIES.get(queryKey);
        if (query == null) {
            throw new RuntimeException("No query with this key: " + queryKey);
        }
        return query;
    }

    private final String getFragement(String fragmentKey) {
        String fragment = this.SQL_FRAGMENTS.get(fragmentKey);
        if (fragment == null) {
            throw new RuntimeException("No fragment with this key: " + fragmentKey);
        }
        return fragment;
    }

    public boolean isConnectionValid() {
        boolean isValid = false;
        try {
            Connection conn = this.dataConn.getConnection();
            isValid = this.pi.getDbEngine() == ServerType.Db2Z ? conn.isValid(30) : true;
        }
        catch (SQLException e) {
            this.handleEx(e);
        }
        return isValid;
    }

    private void handleEx(Exception ex) {
        if (ex instanceof EZSourceConnectionException) {
            throw (EZSourceConnectionException)((Object)ex);
        }
        throw new EZSourceConnectionException((Throwable)ex);
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        OperationController ctrl;
        ProjectConnection c;
        Object target;
        Class<?> interfaceClazz;

        ConnectionInvocationHandler(Object target, OperationController ctrl, Class<?> interfaceClazz) {
            this.c = ProjectConnection.this;
            this.ctrl = ctrl;
            this.target = target;
            this.interfaceClazz = interfaceClazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object object;
            if (method.getDeclaringClass().equals(this.interfaceClazz)) {
                object = this.c.stateGuard;
                synchronized (object) {
                    this.c.state = State.Working;
                    this.c.currentOpCtrl = this.ctrl;
                }
            }
            try {
                object = Proxies.invoke(this.target, method, args);
                return object;
            }
            finally {
                if (method.getDeclaringClass().equals(this.interfaceClazz)) {
                    Object object2 = this.c.stateGuard;
                    synchronized (object2) {
                        if (this.c.state != State.Working && this.c.state != State.Canceling) {
                            throw new IllegalStateException(this.c.state.toString());
                        }
                        this.c.state = State.Initialized;
                        this.c.currentOpCtrl = null;
                    }
                }
            }
        }
    }

    private class DataOperationController
    extends OperationController {
        private DataOperationController() {
        }

        @Override
        public void cancel() {
            this.f.dataConn.cancel();
        }
    }

    private abstract class OperationController {
        protected final ProjectConnection f;

        private OperationController() {
            this.f = ProjectConnection.this;
        }

        public abstract void cancel();
    }

    private class NonBlockingOperationHandleImpl
    implements NonBlockingOperationHandle {
        String[][] data = null;
        boolean closed;
        boolean cleanTmpTables;
        int chunkRowsCount;
        Integer totalRowsCount;
        boolean eof;

        NonBlockingOperationHandleImpl(int chunkRowsCount, Integer totalRowsCount, boolean cleanTmpTables, boolean eof) {
            this.cleanTmpTables = cleanTmpTables;
            this.chunkRowsCount = chunkRowsCount;
            this.totalRowsCount = totalRowsCount;
            this.eof = eof;
        }

        public Integer totalRowsCount() {
            ProjectConnection.this.checkState();
            return this.totalRowsCount;
        }

        public List<String[]> getAvailableData() {
            ProjectConnection.this.checkState();
            if (this.closed) {
                throw new IllegalStateException("Handler closed.");
            }
            if (ProjectConnection.this.dataConn == null) {
                throw new IllegalStateException("Data connection closed.");
            }
            if (this.data == null && !this.eof) {
                L.debug("No data cached, no eof, do fetch...");
                this.fetchData();
            }
            List<String[]> r = this.data != null ? Arrays.asList(this.data) : Collections.emptyList();
            this.data = null;
            return r;
        }

        public boolean dataAvailable() {
            ProjectConnection.this.checkState();
            if (this.closed) {
                throw new IllegalStateException("Handler closed.");
            }
            if (ProjectConnection.this.dataConn == null) {
                throw new IllegalStateException("Data connection closed.");
            }
            if (this.data == null && !this.eof) {
                L.debug("No data cached, no eof, do fetch...");
                this.fetchData();
            }
            return this.data != null;
        }

        public void close() {
            ProjectConnection.this.checkState(true);
            if (this.closed) {
                throw new IllegalStateException("Handler already closed.");
            }
            try {
                if (ProjectConnection.this.dataConn == null) {
                    L.debug("Data connection closed, nothing to do.");
                } else {
                    L.debug("Closing active fetch.");
                    ProjectConnection.this.dataConn.end();
                    if (this.cleanTmpTables) {
                        ProjectConnection.this.cleanTempTables();
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }

        public boolean finished() {
            ProjectConnection.this.checkState(true);
            if (this.closed) {
                throw new IllegalStateException("Handler closed.");
            }
            if (ProjectConnection.this.dataConn == null) {
                throw new IllegalStateException("Data connection closed.");
            }
            return this.data == null && this.eof;
        }

        private void fetchData() {
            try {
                L.trace("Begin fetching...");
                this.data = ProjectConnection.this.dataConn.getAvailableData(this.chunkRowsCount);
            }
            catch (Exception ex) {
                throw new EZSourceConnectionException("Can't fetch data.", (Throwable)ex);
            }
            this.eof = ProjectConnection.this.dataConn.finished();
            if (this.data == null) {
                if (!this.eof) {
                    L.trace("Data not yet available.");
                }
            } else {
                L.trace(String.format("Fetched %d row(s).", this.data.length));
            }
            if (this.eof) {
                L.trace("No more data to transfer.");
            }
        }
    }

    private static enum State {
        Created,
        Initialized,
        Working,
        Canceling,
        Closed;

    }
}

