/*
 * Decompiled with CFR 0.152.
 */
package com.ez.codingrules.cobol;

import com.ez.codingrules.RuleInput;
import com.ez.codingrules.cobol.CobolRule;
import com.ez.codingrules.cobol.NonBlockingOperationConnInit;
import com.ez.codingrules.internal.Messages;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.mainframe.data.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalQueryRule
extends CobolRule {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExternalQueryRule.class);
    Set<String> tempTableNames;
    EZSourceConnection bridge;

    public ExternalQueryRule(String name) {
        super(name);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected List<NonBlockingOperationConnInit> beginSql(IProgressMonitor monitor, Map<String, Object> executionInputs) {
        monitor.subTask(Messages.getString(ExternalQueryRule.class, (String)"getting.data.for", (Object[])new String[]{this.getName()}));
        results = new ArrayList<NonBlockingOperationConnInit>();
        bridge = (EZSourceConnection)executionInputs.get("bridge");
        try {
            if (bridge == null) ** GOTO lbl45
            query = this.getQuery();
            ExternalQueryRule.L.trace("{}", (Object)query);
            if (query != null && !query.isEmpty()) {
                if (this.inputs == null || this.inputs.values().size() == 0) {
                    ExternalQueryRule.L.debug("rule {} has no inputs", (Object)this.getName());
                    results.add(new NonBlockingOperationConnInit(){

                        @Override
                        public NonBlockingOperationHandle init() {
                            NonBlockingOperationHandle result = bridge.beginExecuteSQL(query, 200);
                            return result;
                        }
                    });
                } else {
                    for (RuleInput r : this.inputs.values()) {
                        if (r.getWrap() == null) continue;
                        ExternalQueryRule.L.trace("{}", (Object)r.getWrap());
                    }
                    v0 = manyInputs = this.inputs.values().size() > 1;
                    if (manyInputs) {
                        this.tempTableNames = new HashSet<String>();
                        this.bridge = bridge;
                        q1 = query;
                        for (RuleInput inpt : this.inputs.values()) {
                            Utils.createTempTable((EZSourceConnection)bridge, (String)inpt.getWrap().tblName);
                            Utils.insertValues((EZSourceConnection)bridge, (String)inpt.getWrap().tblName, (EZSourceDataType)(inpt.getWrap().isNumeric != false ? EZSourceDataType.Integer : EZSourceDataType.String), (Collection)inpt.getWrap().values);
                            this.tempTableNames.add(inpt.getWrap().tblName);
                            q1 = this.completeQuery(q1, inpt.getWrap().tblName, bridge);
                        }
                        q2 = q1;
                        results.add(new NonBlockingOperationConnInit(){

                            @Override
                            public NonBlockingOperationHandle init() {
                                return bridge.beginExecuteSQL(q2, 200);
                            }
                        });
                    } else {
                        inpt = (RuleInput)this.inputs.values().iterator().next();
                        wrap = inpt.getWrap();
                        values = new ArrayList<E>(wrap.values);
                        types = Arrays.asList(new EZSourceDataType[values.size()]);
                        Collections.fill(types, wrap.isNumeric != false ? EZSourceDataType.Integer : EZSourceDataType.String);
                        q2 = this.completeQuery(query, inpt.getWrap().tblName, bridge);
                        results.add(new NonBlockingOperationConnInit(){

                            @Override
                            public NonBlockingOperationHandle init() {
                                NonBlockingOperationHandle result = bridge.beginExecuteSQL(q2, types, values, 200);
                                return result;
                            }
                        });
                    }
                }
            } else {
                ExternalQueryRule.L.warn("query rule is null or empty! cannot execute the rule");
                throw new RuntimeException("query rule is null or empty", null);
lbl45:
                // 1 sources

                ExternalQueryRule.L.warn("bridge is not set! cannot execute rule");
            }
        }
        catch (Exception e) {
            ExternalQueryRule.L.warn("execution exception; rule will be ignored.");
            throw new RuntimeException("execution exception", e);
        }
        return results;
    }

    private String completeQuery(String query, String tempTblName, EZSourceConnection conn) {
        String selectStr = "select * from " + Utils.getTempTableName((EZSourceConnection)conn, (String)tempTblName);
        String q = query.replaceAll(tempTblName, selectStr);
        L.trace("query of inputs: {}", (Object)q);
        return q;
    }

    @Override
    protected String getProcedure() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getProcedureSelective() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    protected void closeDataHandler(NonBlockingOperationHandle crtNBOH) {
        if (this.tempTableNames != null) {
            for (String tblName : this.tempTableNames) {
                Utils.cleanTable((EZSourceConnection)this.bridge, (String)tblName);
                Utils.dropTempTable((EZSourceConnection)this.bridge, (String)tblName);
            }
        }
        super.closeDataHandler(crtNBOH);
    }
}

