/*
 * Decompiled with CFR 0.152.
 */
package com.ez.codingrules.cobol;

import com.ez.codingrules.cobol.CobolRule;
import com.ez.codingrules.cobol.CobolRuleResult;
import com.ez.codingrules.cobol.RuleResultWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMainframeRuleWorker
implements RuleResultWorker {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DefaultMainframeRuleWorker.class);
    protected Map<String, CobolRuleResult.Result> programs = new HashMap<String, CobolRuleResult.Result>();
    protected Map<String, CobolRuleResult.Result> includes = new HashMap<String, CobolRuleResult.Result>();
    protected Map<String, String> prgPaths = new HashMap<String, String>();
    protected Set<String> inclPaths = new HashSet<String>();
    protected StringBuilder toExportCsv = new StringBuilder();
    protected CobolRule rule;

    public DefaultMainframeRuleWorker(CobolRule cobolRule) {
        this.rule = cobolRule;
    }

    @Override
    public void prepareData(List<String[]> dataList) {
        int i = 0;
        while (i < dataList.size()) {
            String[] data = dataList.get(i);
            if (this.rule.isSourceBased()) {
                this.prepareSourceBased(data);
            } else {
                this.prepareValueBased(data);
            }
            ++i;
        }
    }

    protected void prepareValueBased(String[] data) {
        int ii = 0;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String d = stringArray[n2];
            if (ii != 0) {
                this.toExportCsv.append(",");
            }
            this.toExportCsv.append(d);
            ++ii;
            ++n2;
        }
        this.toExportCsv.append("\n");
    }

    protected void prepareSourceBased(String[] data) {
        if (data.length == 5) {
            String prgName = data[1];
            String path = data[2].toUpperCase();
            Integer row = Integer.valueOf(data[3]);
            boolean isProgram = CobolRule.isProgram(data);
            if (isProgram) {
                this.prgPaths.put(CobolRule.getCompoundKey(prgName, path), path);
            } else {
                this.inclPaths.add(path);
            }
            this.buildResults(prgName, path, row, isProgram);
        } else {
            L.warn("Incorrect parametter number");
        }
    }

    protected void buildResults(String prgName, String path, Integer row, boolean isProgram) {
        String tempKey;
        CobolRuleResult.Result prgDet = this.programs.get(prgName);
        if (prgDet == null && (prgDet = this.programs.get(tempKey = CobolRule.getCompoundKey(prgName, path))) == null) {
            prgDet = new CobolRuleResult.Result();
            prgDet.name = prgName;
            this.programs.put(prgName, prgDet);
        }
        boolean added = false;
        if (isProgram) {
            if (prgDet.path == null) {
                prgDet.path = path;
            } else if (!prgDet.path.equalsIgnoreCase(path)) {
                L.warn("there are two programs with the same name (" + prgName + ") and different paths");
                prgDet.name = CobolRule.getCompoundKey(prgName, prgDet.path);
                this.programs.remove(prgName);
                this.programs.put(prgDet.name, prgDet);
                prgName = CobolRule.getCompoundKey(prgName, path);
                prgDet = new CobolRuleResult.Result();
                prgDet.name = prgName;
                prgDet.path = path;
                this.programs.put(prgName, prgDet);
            }
            List<Integer> lines = prgDet.lines;
            if (lines == null) {
                prgDet.lines = lines = new ArrayList<Integer>();
            }
            if (!lines.contains(row)) {
                added = lines.add(row);
            }
        } else {
            CobolRuleResult.Result inclDet = this.includes.get(path);
            if (inclDet == null) {
                inclDet = new CobolRuleResult.Result();
                inclDet.path = path;
                inclDet.lines = new ArrayList<Integer>();
                inclDet.programs = new HashSet<String>();
                inclDet.isInclude = true;
                this.includes.put(path, inclDet);
            }
            List<Integer> lines = inclDet.lines;
            Set<String> programs = inclDet.programs;
            if (!lines.contains(row)) {
                added = lines.add(row);
            }
            programs.add(prgName);
            added = true;
        }
        if (prgDet.occurrences == null) {
            prgDet.occurrences = new Integer(0);
        }
        if (added) {
            prgDet.occurrences = new Integer(prgDet.occurrences) + 1;
        }
    }

    @Override
    public Map<String, CobolRuleResult.Result> getPrograms() {
        return this.programs;
    }

    @Override
    public Map<String, CobolRuleResult.Result> getIncludes() {
        return this.includes;
    }

    @Override
    public Map<String, String> getPrgPaths() {
        return this.prgPaths;
    }

    @Override
    public Set<String> getInclPaths() {
        return this.inclPaths;
    }

    @Override
    public StringBuilder getResult() {
        return this.toExportCsv;
    }

    public void setRule(CobolRule r) {
        this.rule = r;
    }
}

