/*
 * Decompiled with CFR 0.152.
 */
package com.ez.codingrules.cobol;

import com.ez.codingrules.cobol.CobolRule;
import com.ez.codingrules.cobol.CobolRuleResult;
import com.ez.codingrules.cobol.RuleResultWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverityResultWorker
implements RuleResultWorker {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CoverityResultWorker.class);
    private boolean isPrograms = true;
    private List<CobolRuleResult.Result> results;
    protected Map<String, CobolRuleResult.Result> includes;

    public CoverityResultWorker(boolean isPrograms, List<CobolRuleResult.Result> results) {
        this.isPrograms = isPrograms;
        this.results = results;
        this.includes = new HashMap<String, CobolRuleResult.Result>();
    }

    @Override
    public void prepareData(List<String[]> dataList) {
        int i = 0;
        while (i < dataList.size()) {
            String[] data = dataList.get(i);
            if (data.length >= 5 && data.length <= 6) {
                try {
                    int id = Integer.valueOf(data[0]);
                    String prgName = data[1];
                    String path = data[2];
                    Integer row = Integer.valueOf(data[3]);
                    boolean isProgram = CobolRule.isProgram(data);
                    String function = null;
                    if (data.length >= 6) {
                        function = data[5];
                    }
                    if (this.isPrograms && isProgram || !this.isPrograms && !isProgram) {
                        this.results.add(this.getResult(id, prgName, path, row, isProgram, function));
                    }
                }
                catch (NumberFormatException e) {
                    L.error("", (Throwable)e);
                }
            } else {
                L.warn("Incorrect parametter number");
            }
            ++i;
        }
    }

    @Override
    public Map<String, CobolRuleResult.Result> getPrograms() {
        return null;
    }

    @Override
    public Map<String, CobolRuleResult.Result> getIncludes() {
        return null;
    }

    @Override
    public Map<String, String> getPrgPaths() {
        return null;
    }

    @Override
    public Set<String> getInclPaths() {
        return null;
    }

    protected CobolRuleResult.Result getResult(int id, String prgName, String path, Integer row, boolean isProgram, String function) {
        CobolRuleResult.Result retVal;
        CobolRuleResult.Result prgDet = new CobolRuleResult.Result();
        prgDet.name = prgName;
        if (isProgram) {
            prgDet.id = id;
            if (prgDet.path == null) {
                prgDet.path = path;
                prgDet.function = function;
            } else if (!prgDet.path.equalsIgnoreCase(path)) {
                L.warn("there are two programs with the same name (" + prgName + ") and different paths");
                prgDet.name = CobolRule.getCompoundKey(prgName, prgDet.path);
                prgName = String.valueOf(prgName) + "(" + path + ")";
                prgDet = new CobolRuleResult.Result();
                prgDet.name = prgName;
                prgDet.path = path;
            }
            List<Integer> lines = prgDet.lines;
            if (lines == null) {
                prgDet.lines = lines = new ArrayList<Integer>();
            }
            lines.add(row);
            retVal = prgDet;
        } else {
            CobolRuleResult.Result inclDet = this.includes.get(path);
            if (inclDet == null) {
                inclDet = new CobolRuleResult.Result();
                inclDet.id = id;
                inclDet.path = path;
                inclDet.lines = new ArrayList<Integer>();
                inclDet.programs = new HashSet<String>();
                inclDet.isInclude = true;
                this.includes.put(path, inclDet);
            }
            List<Integer> lines = inclDet.lines;
            Set<String> cfr_ignored_0 = inclDet.programs;
            if (!lines.contains(row)) {
                lines.add(row);
            }
            retVal = inclDet;
        }
        if (prgDet.occurrences == null) {
            prgDet.occurrences = new Integer(0);
        }
        prgDet.occurrences = new Integer(prgDet.occurrences) + 1;
        return retVal;
    }

    @Override
    public StringBuilder getResult() {
        return null;
    }
}

