/*
 * Decompiled with CFR 0.152.
 */
package com.ez.codingrules.cobol;

import com.ez.codingrules.RuleResult;
import com.ez.common.model.LogMessage;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class CobolRuleResult
extends RuleResult {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    Map<String, Result> programs;
    Map<String, Result> includes;
    StringBuilder exportCSV = null;
    public boolean hadError = false;
    Queue<LogMessage> messages;

    public CobolRuleResult() {
        this.messages = new LinkedList<LogMessage>();
    }

    public CobolRuleResult(Map<String, Result> programs, Map<String, Result> includes) {
        this.programs = programs;
        this.includes = includes;
    }

    public void setIncludes(Map<String, Result> includeResult) {
        this.includes = includeResult;
    }

    public void setPrograms(Map<String, Result> progsResult) {
        this.programs = progsResult;
    }

    public Map<String, Result> getPrograms() {
        return this.programs;
    }

    public Map<String, Result> getIncludes() {
        return this.includes;
    }

    public StringBuilder getExportCSV() {
        return this.exportCSV;
    }

    public void setToExportCSV(StringBuilder exportCSV) {
        this.exportCSV = exportCSV;
    }

    public boolean isEmpty() {
        boolean ret = false;
        ret = !(this.programs != null && !this.programs.isEmpty() || this.includes != null && !this.includes.isEmpty());
        return ret;
    }

    public void addMessage(LogMessage message) {
        this.messages.add(message);
    }

    public Queue<LogMessage> getMessages() {
        return this.messages;
    }

    public static class Result
    implements Serializable {
        public Integer id;
        public String name;
        public String path;
        public String pType = "COBOL";
        public String function;
        public List<Integer> lines;
        public Set<String> programs;
        public Integer occurrences;
        public boolean isInclude = false;

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            String s1 = this.path == null ? "" : this.path;
            s1 = String.valueOf(s1) + (this.name != null ? this.name : "");
            String s2 = other.path == null ? "" : other.path;
            s2 = String.valueOf(s2) + (other.name != null ? other.name : "");
            return s1.equals(s2);
        }

        public String toString() {
            return "Result [name=" + this.name + ", path=" + this.path + "]";
        }
    }
}

