/*
 * Decompiled with CFR 0.152.
 */
package com.ez.codingrules.cobol;

import com.ez.codingrules.Rule;
import com.ez.codingrules.cobol.CobolRuleResult;
import com.ez.codingrules.cobol.CobolRuleResultWithIterators;
import com.ez.codingrules.cobol.CoverityResultWorker;
import com.ez.codingrules.cobol.DefaultMainframeRuleWorker;
import com.ez.codingrules.cobol.IteratorGenerator;
import com.ez.codingrules.cobol.NonBlockingOperationConnInit;
import com.ez.codingrules.cobol.RuleResultWorker;
import com.ez.codingrules.internal.Messages;
import com.ez.common.model.BaseListable;
import com.ez.common.model.LogMessage;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.mainframe.data.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CobolRule
extends Rule
implements BaseListable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CobolRule.class);
    protected static final String PROCEDURE_PREFIX = "EZReports_CodingRule_";
    public static final String PROGRAMS_KEY = "programs";
    public static final String BRIDGE_KEY = "bridge";
    protected static final String PARAMETER_NAME_NUMBER_OF_LINES = "Number of blank Lines";
    protected boolean isSelective = true;
    protected RuleResultWorker ruleResultsWorker;

    private static final String getProgramTypeQuery(EZSourceConnection conn) {
        return "SELECT pr.ProgramName, p.PathStr, pt.ProgramType from Programs pr \n inner join ProgramTypes pt on pt.ProgramTypeID = pr.ProgramTypeID\n inner join Occurrences o on o.OccurId = pr.OccurId\n inner join Paths p on p.PathID = o.PathID where UPPER(p.PathStr) in\n (select * from " + Utils.getTempTableName((EZSourceConnection)conn, (String)"string_param_temp") + ") and pr.ProgramTypeId in (2, 3, 8, 15, 16)";
    }

    private static final String getIncludeTypeQuery(EZSourceConnection conn) {
        return " SELECT p.PathStr, \n CASE r.ResourceType WHEN 67 THEN 'PL1' \n\t  WHEN 99 THEN 'ASSEMBLER'\n   ELSE 'NATURAL' \n   END AS ProgramType \n    \t\tfrom Resources  r \n  inner join Occurrences o on o.OccurId = r.OccurId \n   inner join Paths p on p.PathID = o.PathID where UPPER(p.PathStr) in \n   (select * from " + Utils.getTempTableName((EZSourceConnection)conn, (String)"string_param_temp") + ") and r.ResourceType in (57, 60, 67, 99)";
    }

    protected CobolRule() {
        super(null);
    }

    public CobolRule(String name) {
        super(name);
    }

    public CobolRuleResult execute(IProgressMonitor monitor, Map<String, Object> executionInputs) {
        CobolRuleResult result = new CobolRuleResult();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)120);
        try {
            if (this.getQuery() != null) {
                executionInputs.remove(PROGRAMS_KEY);
            }
            if (executionInputs != null) {
                this.isSelective = executionInputs.get(PROGRAMS_KEY) != null;
            }
            L.debug("before executeSql()");
            List<NonBlockingOperationConnInit> results = this.beginSql((IProgressMonitor)subMonitor.newChild(50), executionInputs);
            L.debug("after executeSql()");
            this.prepareResults((IProgressMonitor)subMonitor.newChild(50), results);
            this.computePrgTypes(executionInputs, subMonitor.newChild(20));
            subMonitor.setWorkRemaining(0);
            if (this.getPrograms() != null) {
                result.setPrograms(this.getPrograms());
            } else {
                result.setPrograms(null);
                L.info("no program failed rule: " + this.getName());
            }
            if (this.getIncludes() != null) {
                result.setIncludes(this.getIncludes());
            } else {
                result.setIncludes(null);
                L.info("no include failed rule: " + this.getName());
            }
            result.setToExportCSV(this.getToExportCSV());
        }
        catch (RuntimeException ex) {
            L.error("error at executing rule " + this.getName(), (Throwable)ex);
            result.addMessage(new LogMessage(Messages.getString(CobolRule.class, (String)"errorAtExecuting", (Object[])new String[]{this.getName()}), 4, "com.ez.codingrules", (Throwable)ex));
            result.hadError = true;
        }
        return result;
    }

    private void computePrgTypes(Map<String, Object> executionInputs, SubMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        EZSourceConnection bridge = (EZSourceConnection)executionInputs.get(BRIDGE_KEY);
        if (bridge == null) {
            return;
        }
        Map<String, String> prgPaths = this.getPrgPaths();
        Map<String, CobolRuleResult.Result> prgResultMap = this.getPrograms();
        if (prgPaths != null && !prgPaths.isEmpty() && prgResultMap != null) {
            subMonitor.setTaskName(Messages.getString(CobolRule.class, (String)"prg.types"));
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[prgPaths.size()]);
            Collections.fill(types, EZSourceDataType.String);
            String[][] res = bridge.executeSQL(CobolRule.getProgramTypeQuery(bridge), types, new ArrayList<String>(prgPaths.values()));
            if (res != null && res.length > 0) {
                String[][] stringArray = res;
                int n = res.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] r = stringArray[n2];
                    String path = r[1];
                    String prgName = r[0];
                    CobolRuleResult.Result result = prgResultMap.get(prgName);
                    if (result == null) {
                        result = prgResultMap.get(CobolRule.getCompoundKey(prgName, path));
                    }
                    if (result != null) {
                        String pType;
                        result.pType = pType = r[2];
                    } else {
                        L.warn("type not found for prg {}; usecobol default editor", (Object)path);
                    }
                    ++n2;
                }
            }
        }
        monitor.worked(50);
        Set<String> inclPaths = this.getInclPaths();
        Map<String, CobolRuleResult.Result> inclResultMap = this.getIncludes();
        if (inclPaths != null && !inclPaths.isEmpty() && inclResultMap != null) {
            subMonitor.setTaskName(Messages.getString(CobolRule.class, (String)"incl.types"));
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[inclPaths.size()]);
            Collections.fill(types, EZSourceDataType.String);
            String[][] res = bridge.executeSQL(CobolRule.getIncludeTypeQuery(bridge), types, new ArrayList<String>(inclPaths));
            if (res != null && res.length > 0) {
                String[][] stringArray = res;
                int n = res.length;
                int n3 = 0;
                while (n3 < n) {
                    String[] r = stringArray[n3];
                    String incPath = r[0];
                    CobolRuleResult.Result result = inclResultMap.get(incPath);
                    if (result != null) {
                        String pType;
                        result.pType = pType = r[1];
                    } else {
                        L.warn("type not found for include {}; usecobol default editor", inclPaths);
                    }
                    ++n3;
                }
            }
        }
    }

    public CobolRuleResultWithIterators begin(IProgressMonitor monitor, final Map<String, Object> executionInputs) {
        SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (executionInputs != null) {
            this.isSelective = executionInputs.get(PROGRAMS_KEY) != null;
        }
        IteratorGenerator<CobolRuleResult.Result> programsIteratorGenerator = new IteratorGenerator<CobolRuleResult.Result>(){

            @Override
            public boolean isIteratorEmpty() {
                return false;
            }

            @Override
            public Iterator<CobolRuleResult.Result> generateIterator(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                L.debug("before beginSql()");
                List<NonBlockingOperationConnInit> results = CobolRule.this.beginSql((IProgressMonitor)subMonitor.newChild(50), executionInputs);
                L.debug("after beginSql()");
                Iterator<CobolRuleResult.Result> iterator = CobolRule.this.createIterator((IProgressMonitor)subMonitor.newChild(50), results, true);
                subMonitor.setWorkRemaining(0);
                return iterator;
            }
        };
        IteratorGenerator<CobolRuleResult.Result> includesIteratorGenerator = new IteratorGenerator<CobolRuleResult.Result>(){

            @Override
            public boolean isIteratorEmpty() {
                return false;
            }

            @Override
            public Iterator<CobolRuleResult.Result> generateIterator(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                L.debug("before beginSql()");
                List<NonBlockingOperationConnInit> results = CobolRule.this.beginSql((IProgressMonitor)subMonitor.newChild(50), executionInputs);
                L.debug("after beginSql()");
                Iterator<CobolRuleResult.Result> iterator = CobolRule.this.createIterator((IProgressMonitor)subMonitor.newChild(50), results, false);
                subMonitor.setWorkRemaining(0);
                return iterator;
            }
        };
        CobolRuleResultWithIterators cobolRuleResult = new CobolRuleResultWithIterators(programsIteratorGenerator, includesIteratorGenerator);
        return cobolRuleResult;
    }

    protected Iterator<CobolRuleResult.Result> createIterator(IProgressMonitor monitor, final List<NonBlockingOperationConnInit> operationHandleConnInit, boolean programs) {
        return new Iterator<CobolRuleResult.Result>(programs){
            List<CobolRuleResult.Result> results = new LinkedList<CobolRuleResult.Result>();
            NonBlockingOperationHandle crtNBOH;
            CoverityResultWorker coverityWorker;
            {
                this.coverityWorker = new CoverityResultWorker(bl, this.results);
            }

            private void prepareData() {
                while (this.results.size() <= 2 && (operationHandleConnInit.size() > 0 || this.crtNBOH != null)) {
                    if (this.crtNBOH == null && operationHandleConnInit.size() > 0) {
                        this.crtNBOH = ((NonBlockingOperationConnInit)operationHandleConnInit.remove(0)).init();
                    }
                    if (!this.crtNBOH.dataAvailable()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            L.debug("while sleeping", (Throwable)e);
                            break;
                        }
                    }
                    List dataList = this.crtNBOH.getAvailableData();
                    this.coverityWorker.prepareData(dataList);
                    if (!this.crtNBOH.finished()) continue;
                    this.crtNBOH.close();
                    this.crtNBOH = null;
                }
            }

            @Override
            public boolean hasNext() {
                this.prepareData();
                return this.results.size() != 0;
            }

            @Override
            public CobolRuleResult.Result next() {
                this.prepareData();
                if (this.hasNext()) {
                    return this.results.remove(0);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void prepareResults(IProgressMonitor monitor, List<NonBlockingOperationConnInit> connectionInitList) {
        if (connectionInitList != null) {
            if (this.ruleResultsWorker == null) {
                this.ruleResultsWorker = new DefaultMainframeRuleWorker(this);
            }
            block5: for (NonBlockingOperationConnInit connInit : connectionInitList) {
                NonBlockingOperationHandle crtNBOH = connInit.init();
                try {
                    while (!crtNBOH.finished()) {
                        if (!crtNBOH.dataAvailable()) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                L.debug("while sleeping", (Throwable)e);
                                continue block5;
                            }
                        }
                        List dataList = crtNBOH.getAvailableData();
                        this.ruleResultsWorker.prepareData(dataList);
                    }
                }
                finally {
                    this.closeDataHandler(crtNBOH);
                }
            }
        }
    }

    protected void closeDataHandler(NonBlockingOperationHandle crtNBOH) {
        if (crtNBOH != null) {
            crtNBOH.close();
        }
    }

    static String getCompoundKey(String prgName, String path) {
        return String.valueOf(prgName) + " (" + path + ")";
    }

    static boolean isProgram(String[] result) {
        boolean ret = false;
        if (result != null && result.length > 4) {
            ret = result[4].equals("0");
        }
        return ret;
    }

    protected List<NonBlockingOperationConnInit> beginSql(IProgressMonitor monitor, Map<String, Object> executionInputs) {
        monitor.subTask(Messages.getString(CobolRule.class, (String)"getting.data.for", (Object[])new String[]{this.getName()}));
        List<NonBlockingOperationConnInit> result = null;
        EZSourceConnection bridge = (EZSourceConnection)executionInputs.get(BRIDGE_KEY);
        if (bridge != null) {
            result = this.beginProcedure(monitor, bridge, executionInputs);
        } else {
            L.warn("bridge is not set! cannot execute rule");
        }
        return result;
    }

    protected List<NonBlockingOperationConnInit> beginProcedure(IProgressMonitor monitor, final EZSourceConnection bridge, Map<String, Object> executionInputs) {
        ArrayList<NonBlockingOperationConnInit> results = new ArrayList<NonBlockingOperationConnInit>();
        final String[] params = this.getParameterValuesArray();
        L.debug("before run procedure; selective=" + this.isSelective);
        if (this.isSelective) {
            Collection prgIds = (Collection)executionInputs.get(PROGRAMS_KEY);
            final ArrayList values = new ArrayList(prgIds);
            final List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[prgIds.size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            final String procedureSelective = this.getProcedureSelective();
            results.add(new NonBlockingOperationConnInit(){

                @Override
                public NonBlockingOperationHandle init() {
                    return bridge.beginNonTransactionalStoredProc(procedureSelective, params, types, values, 200);
                }
            });
        } else {
            final String procedure = this.getProcedure();
            results.add(new NonBlockingOperationConnInit(){

                @Override
                public NonBlockingOperationHandle init() {
                    return bridge.beginNonTransactionalStoredProc(procedure, params, 200);
                }
            });
        }
        return results;
    }

    protected abstract String getProcedure();

    protected abstract String getProcedureSelective();

    protected String[] getParameterValuesArray() {
        return null;
    }

    private Map<String, CobolRuleResult.Result> getPrograms() {
        return this.ruleResultsWorker != null ? this.ruleResultsWorker.getPrograms() : null;
    }

    private Map<String, CobolRuleResult.Result> getIncludes() {
        return this.ruleResultsWorker != null ? this.ruleResultsWorker.getIncludes() : null;
    }

    private Map<String, String> getPrgPaths() {
        return this.ruleResultsWorker != null ? this.ruleResultsWorker.getPrgPaths() : null;
    }

    private Set<String> getInclPaths() {
        return this.ruleResultsWorker != null ? this.ruleResultsWorker.getInclPaths() : null;
    }

    private StringBuilder getToExportCSV() {
        return this.ruleResultsWorker != null ? this.ruleResultsWorker.getResult() : new StringBuilder();
    }

    public Integer getTypeCode() {
        return 1;
    }

    public String getListableName() {
        return this.getName() == null ? Messages.getString(CobolRule.class, (String)"has.no.name") : this.getName();
    }

    public String getTypeText() {
        return this.getGroupName();
    }

    public boolean hasType() {
        return this.getImagePath() != null && !this.getImagePath().trim().isEmpty();
    }

    public boolean isCustom() {
        return false;
    }

    public boolean isGroup() {
        return false;
    }

    public void setWorker(RuleResultWorker worker) {
        this.ruleResultsWorker = worker;
    }
}

