/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.internal;

import com.ibm.ad.internal.BCrypt;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class PasswordUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final byte[] KDBAES = new byte[]{118, -110, -58, 114, -75, 119, 87, -126, 72, 87, -125, -126, -63, -123, 101, -93};
    private static final String AES = "AES";
    public static final String ARG_ENCRYPT = "--encrypt=";
    public static final String ARG_ENCRYPT_V2 = "--v2";
    public static final String ARG_BCRYPT = "--bcrypt";
    public static final String ENCRYPTED_PBKDF2_SHA256 = "{PBKDF2WithHmacSHA256}";
    public static boolean usePasswordV2 = true;

    public static String encrypt(String str) {
        return PasswordUtils.encrypt(new SecretKeySpec(KDBAES, AES), str);
    }

    public static String encrypt(SecretKeySpec secretKeySpec, String str) {
        return new InternalCipher(secretKeySpec).encrypt(str);
    }

    public static String decrypt(String str) {
        return PasswordUtils.decrypt(new SecretKeySpec(KDBAES, AES), str);
    }

    public static String decrypt(SecretKeySpec secretKeySpec, String str) {
        return new InternalCipher(secretKeySpec).decrypt(str);
    }

    public static void decryptSystemProperty(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            System.setProperty(propertyName, PasswordUtils.decrypt(propertyValue));
        }
    }

    public static void decryptSystemProperties() {
        Properties systemProperties = System.getProperties();
        systemProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String propertyKey = key.toString();
            if (propertyKey.endsWith("javax.net.ssl.keyStorePassword") || propertyKey.endsWith("javax.net.ssl.trustStorePassword") || propertyKey.endsWith("client.ssl.keyStorePass") || propertyKey.endsWith("client.ssl.trustStorePass") || propertyKey.endsWith("ssl.keyStore.password") || propertyKey.endsWith("ssl.trustStore.password")) {
                PasswordUtils.decryptSystemProperty(propertyKey);
            }
        }));
    }

    public static void main(String[] args) {
        String passwordToEncrypt = "hello there!";
        boolean useBCrypt = false;
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if (arg != null && arg.startsWith(ARG_ENCRYPT)) {
                    String[] passwordParts = arg.split("=");
                    if (passwordParts.length != 2) continue;
                    passwordToEncrypt = passwordParts[1];
                    continue;
                }
                if (arg != null && arg.equals(ARG_ENCRYPT_V2)) {
                    usePasswordV2 = true;
                    continue;
                }
                if (arg == null || !arg.equals(ARG_BCRYPT)) continue;
                useBCrypt = true;
            }
            String encrypted = useBCrypt ? BCrypt.hashpw(passwordToEncrypt) : PasswordUtils.encrypt(passwordToEncrypt);
            System.out.println(encrypted);
        }
    }

    private static class InternalCipher {
        private static final String AES_CBC_PKCS_5_PADDING = "AES/CBC/PKCS5Padding";
        private static byte[] IV = new byte[]{87, 88, 116, 80, -110, -107, 68, -80, 86, 84, -57, 67, -88, 68, 81, 80};
        private static final String PBKDF2_SHA256 = "PBKDF2WithHmacSHA256";
        private static final String ENCRYPTED_SECTION_SEPARATOR = ":";
        private SecretKey key;

        private InternalCipher(SecretKey key) {
            this.key = key;
        }

        private String encrypt(String input) {
            if (usePasswordV2) {
                try {
                    return this.encryptV2(input);
                }
                catch (UnsupportedEncodingException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                    return null;
                }
            }
            return this.encryptV1(input);
        }

        private String encryptV1(String input) {
            try {
                byte[] utf8 = input.getBytes(StandardCharsets.UTF_8);
                Cipher cipher = Cipher.getInstance(AES_CBC_PKCS_5_PADDING);
                cipher.init(1, (Key)this.key, new IvParameterSpec(IV));
                byte[] enc = cipher.doFinal(utf8);
                byte[] encodeBase64 = Base64.getEncoder().encode(enc);
                return new String(encodeBase64);
            }
            catch (Throwable e) {
                return null;
            }
        }

        private String encryptV2(String input) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeySpecException {
            String salt = this.generateSalt();
            String pepper = this.getPepper();
            int iterations = this.generateIterations();
            String saltedPassword = input + salt + pepper;
            String aesKey = this.hash_PBKDF2_SHA256(salt + pepper, salt, iterations);
            this.key = new SecretKeySpec(aesKey.getBytes(StandardCharsets.UTF_8), PasswordUtils.AES);
            String encryptedPassword = this.encryptV1(saltedPassword);
            return PasswordUtils.ENCRYPTED_PBKDF2_SHA256 + encryptedPassword + ENCRYPTED_SECTION_SEPARATOR + salt + ENCRYPTED_SECTION_SEPARATOR + iterations;
        }

        private int generateIterations() {
            SecureRandom random = new SecureRandom();
            return 1024 + random.nextInt(1024);
        }

        private String generateSalt() {
            int SALT_SIZE = 24;
            SecureRandom random = new SecureRandom();
            byte[] saltBytes = new byte[24];
            random.nextBytes(saltBytes);
            return this.byteArrayToHexStr(saltBytes);
        }

        private String getPepper() {
            return this.byteArrayToHexStr(IV);
        }

        private String hash_PBKDF2_SHA256(String input, String salt, int iterations) throws NoSuchAlgorithmException, InvalidKeySpecException {
            int HASH_SIZE = 12;
            SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2_SHA256);
            PBEKeySpec spec = new PBEKeySpec(input.toCharArray(), salt.getBytes(StandardCharsets.UTF_8), iterations, 96);
            SecretKey key = skf.generateSecret(spec);
            byte[] hashedBytes = key.getEncoded();
            return this.byteArrayToHexStr(hashedBytes);
        }

        private String byteArrayToHexStr(byte[] data) {
            if (data == null) {
                return null;
            }
            char[] chars = new char[data.length * 2];
            for (int i = 0; i < data.length; ++i) {
                byte current = data[i];
                int hi = (current & 0xF0) >> 4;
                int lo = current & 0xF;
                chars[2 * i] = (char)(hi < 10 ? 48 + hi : 65 + hi - 10);
                chars[2 * i + 1] = (char)(lo < 10 ? 48 + lo : 65 + lo - 10);
            }
            return new String(chars);
        }

        private String decrypt(String input) {
            if (input.contains(PBKDF2_SHA256)) {
                try {
                    return this.decryptV2(input);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return this.decryptV1(input);
        }

        private String decryptV1(String input) {
            try {
                byte[] dec = Base64.getDecoder().decode(input.getBytes(StandardCharsets.UTF_8));
                Cipher cipher = Cipher.getInstance(AES_CBC_PKCS_5_PADDING);
                cipher.init(2, (Key)this.key, new IvParameterSpec(IV));
                byte[] utf8 = cipher.doFinal(dec);
                return new String(utf8, StandardCharsets.UTF_8);
            }
            catch (Throwable e) {
                return input;
            }
        }

        private String decryptV2(String input) throws NoSuchAlgorithmException, InvalidKeySpecException {
            String[] inputSections;
            if (input.length() >= 2 && input.charAt(0) == '\"' && input.charAt(input.length() - 1) == '\"') {
                input = input.substring(1, input.length() - 1);
            }
            if ((inputSections = input.split(ENCRYPTED_SECTION_SEPARATOR)).length == 3) {
                String encryptedPassword = inputSections[0].replace(PasswordUtils.ENCRYPTED_PBKDF2_SHA256, "");
                String salt = inputSections[1];
                int iterations = Integer.parseInt(inputSections[2]);
                String pepper = this.getPepper();
                String aesKey = this.hash_PBKDF2_SHA256(salt + pepper, salt, iterations);
                this.key = new SecretKeySpec(aesKey.getBytes(StandardCharsets.UTF_8), PasswordUtils.AES);
                String saltedPassword = this.decryptV1(encryptedPassword);
                if (saltedPassword != null) {
                    return saltedPassword.substring(0, saltedPassword.indexOf(salt));
                }
            }
            return input;
        }
    }
}

