/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.preferences.ui;

import com.ez.eclient.preferences.ServerScope;
import java.io.IOException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferenceStoreFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static IPersistentPreferenceStore createWorkspacePreferences(String qualifier) {
        ServerScope sc = new ServerScope();
        EZScopedPreferenceStore sp = new EZScopedPreferenceStore(InstanceScope.INSTANCE, qualifier);
        sp.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE, sc});
        return sp;
    }

    public static IPreferenceStore createServerPreferences(String qualifier) {
        ReadOnlyPreferenceStore sp = new ReadOnlyPreferenceStore(ServerScope.INSTANCE, qualifier);
        return sp;
    }

    private static class EZScopedPreferenceStore
    extends ScopedPreferenceStore {
        IScopeContext context;
        String qualifier;
        boolean dirty = false;

        public EZScopedPreferenceStore(IScopeContext context, String qualifier) {
            super(context, qualifier);
            this.context = context;
            this.qualifier = qualifier;
        }

        public void setValue(String name, boolean value) {
            boolean oldValue = this.getBoolean(name);
            if (oldValue == value) {
                return;
            }
            try {
                this.silentRunning = true;
                this.getStorePreferences().putBoolean(name, value);
                this.dirty = true;
                this.firePropertyChangeEvent(name, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
            }
            finally {
                this.silentRunning = false;
            }
        }

        IEclipsePreferences getStorePreferences() {
            return this.context.getNode(this.qualifier);
        }

        public void save() throws IOException {
            super.save();
            this.dirty = false;
        }

        public void putValue(String name, String value) {
            try {
                super.putValue(name, value);
            }
            finally {
                this.dirty = true;
            }
        }

        public boolean needsSaving() {
            return super.needsSaving() || this.dirty;
        }
    }

    private static class ReadOnlyPreferenceStore
    extends ScopedPreferenceStore {
        public ReadOnlyPreferenceStore(IScopeContext context, String qualifier) {
            super(context, qualifier);
        }

        public void putValue(String name, String value) {
            throw new IllegalStateException("Preference store is read-only.");
        }

        public void setToDefault(String name) {
            throw new IllegalStateException("Preference store is read-only.");
        }

        public void setValue(String name, double value) {
            throw new IllegalStateException("Preference store is read-only.");
        }

        public void setValue(String name, float value) {
            throw new IllegalStateException("Preference store is read-only.");
        }

        public void setValue(String name, int value) {
            throw new IllegalStateException("Preference store is read-only.");
        }

        public void setValue(String name, long value) {
            throw new IllegalStateException("Preference store is read-only.");
        }

        public void setValue(String name, String value) {
            throw new IllegalStateException("Preference store is read-only.");
        }

        public void setValue(String name, boolean value) {
            throw new IllegalStateException("Preference store is read-only.");
        }
    }
}

