/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.preferences.ui;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.MutableConfiguration;
import com.ez.eclient.configuration.service.ConfigurationService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentPreferencesStoreAdapter
implements IPersistentPreferenceStore {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(PersistentPreferencesStoreAdapter.class);
    protected final String configurationUniqueId;
    protected final String scope;
    protected final boolean readOnly;
    protected Configuration config;
    protected MutableConfiguration mutableConfig;
    protected boolean dirty;
    protected static final boolean booleanDefault = false;
    protected static final double doubleDefault = 0.0;
    protected static final float floatDefault = 0.0f;
    protected static final int intDefault = 0;
    protected static final long longDefault = 0L;
    protected static final String stringDefault = "";
    private Map<String, Object> defaultProperties;

    public PersistentPreferencesStoreAdapter(String configurationUniqueId, String scope) {
        this(configurationUniqueId, scope, false);
    }

    public PersistentPreferencesStoreAdapter(String configurationUniqueId, String scope, boolean readOnly) {
        if (configurationUniqueId == null) {
            throw new IllegalArgumentException("configurationUniqueId");
        }
        if (scope == null) {
            throw new IllegalArgumentException("scope");
        }
        this.configurationUniqueId = configurationUniqueId;
        this.scope = scope;
        this.readOnly = readOnly;
        this.defaultProperties = new HashMap<String, Object>();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean getBoolean(String name) {
        Object v = this.get(name);
        if (v == null) {
            v = this.getDefault(name);
        }
        return v == null ? false : Boolean.valueOf(v.toString());
    }

    private Object getDefault(String name) {
        return this.defaultProperties.get(name);
    }

    public boolean getDefaultBoolean(String name) {
        Object v = this.getDefault(name);
        return v == null ? false : (Boolean)v;
    }

    public double getDefaultDouble(String name) {
        Object v = this.getDefault(name);
        return v == null ? 0.0 : (Double)v;
    }

    public float getDefaultFloat(String name) {
        Object v = this.getDefault(name);
        return v == null ? 0.0f : ((Float)v).floatValue();
    }

    public int getDefaultInt(String name) {
        Object v = this.getDefault(name);
        return v == null ? 0 : (Integer)v;
    }

    public long getDefaultLong(String name) {
        Object v = this.getDefault(name);
        return v == null ? 0L : (Long)v;
    }

    public String getDefaultString(String name) {
        Object v = this.getDefault(name);
        return v == null ? stringDefault : (String)v;
    }

    public double getDouble(String name) {
        Object v = this.get(name);
        return v == null ? 0.0 : (Double)v;
    }

    public float getFloat(String name) {
        Object v = this.get(name);
        if (v == null) {
            v = this.getDefault(name);
        }
        return v == null ? 0.0f : ((Float)v).floatValue();
    }

    public int getInt(String name) {
        Object v = this.get(name);
        if (v == null) {
            v = this.getDefault(name);
        }
        return v == null ? 0 : (Integer)v;
    }

    public long getLong(String name) {
        Object v = this.get(name);
        if (v == null) {
            v = this.getDefault(name);
        }
        return v == null ? 0L : (Long)v;
    }

    public String getString(String name) {
        Object v = this.get(name);
        if (v == null) {
            v = this.getDefault(name);
        }
        return v == null ? stringDefault : (String)v;
    }

    public boolean isDefault(String name) {
        Object v = this.get(name);
        if (v == null) {
            return false;
        }
        return v.equals(this.getDefault(v.getClass()));
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public void putValue(String name, String value) {
        this.set(name, value);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        throw new RuntimeException("Not implemented.");
    }

    public void setDefault(String name, double value) {
        this.setDefaultValue(name, value);
    }

    public void setDefault(String name, float value) {
        this.setDefaultValue(name, Float.valueOf(value));
    }

    private void setDefaultValue(String name, Object defvalue) {
        this.defaultProperties.put(name, defvalue);
    }

    public void setDefault(String name, int value) {
        this.setDefaultValue(name, value);
    }

    public void setDefault(String name, long value) {
        this.setDefaultValue(name, value);
    }

    public void setDefault(String name, String value) {
        this.setDefaultValue(name, value);
    }

    public void setDefault(String name, boolean value) {
        this.setDefaultValue(name, value);
    }

    public void setToDefault(String name) {
        Object value = this.getDefault(name);
        if (value != null) {
            this.set(name, value);
        } else {
            value = this.get(name);
            if (value == null) {
                this.set(name, stringDefault);
            } else {
                this.set(name, this.getDefault(value.getClass()));
            }
        }
    }

    public void setValue(String name, double value) {
        this.set(name, value);
    }

    public void setValue(String name, float value) {
        this.set(name, Float.valueOf(value));
    }

    public void setValue(String name, int value) {
        this.set(name, value);
    }

    public void setValue(String name, long value) {
        this.set(name, value);
    }

    public void setValue(String name, String value) {
        this.set(name, value);
    }

    public void setValue(String name, boolean value) {
        this.set(name, value);
    }

    public void save() throws IOException {
        if (this.dirty) {
            try {
                try {
                    this.mutableConfig.close();
                }
                catch (Exception ex) {
                    L.error("Can't save.", (Throwable)ex);
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    throw new IOException(ex);
                }
            }
            finally {
                this.config = null;
                this.mutableConfig = null;
                this.dirty = false;
            }
        }
    }

    protected void set(String name, Object value) {
        this.ensureConfig(true);
        this.mutableConfig.setProperty(name, value);
        this.dirty = true;
    }

    protected Object get(String name) {
        this.ensureConfig(false);
        return this.config.getObject(name);
    }

    private Object getDefault(Class clazz) {
        if (clazz.equals(Boolean.class)) {
            return false;
        }
        if (clazz.equals(Double.class)) {
            return 0.0;
        }
        if (clazz.equals(Float.class)) {
            return Float.valueOf(0.0f);
        }
        if (clazz.equals(Long.class)) {
            return 0L;
        }
        return stringDefault;
    }

    protected void ensureConfig(boolean mutable) {
        if (this.config == null) {
            if (mutable) {
                this.mutableConfig = ConfigurationService.getDefault().getMutableConfiguration(this.configurationUniqueId, this.scope);
                this.config = this.mutableConfig;
                if (this.mutableConfig == null) {
                    throw new RuntimeException("No such config: " + this.configurationUniqueId);
                }
            } else {
                this.config = ConfigurationService.getDefault().getConfiguration(this.configurationUniqueId, this.scope);
                if (this.config == null) {
                    throw new RuntimeException("No such config: " + this.configurationUniqueId);
                }
            }
        } else if (mutable) {
            if (this.readOnly) {
                throw new IllegalStateException("Read only store.");
            }
            if (this.mutableConfig == null) {
                this.mutableConfig = ConfigurationService.getDefault().getMutableConfiguration(this.configurationUniqueId, this.scope);
                this.config = this.mutableConfig;
                if (this.mutableConfig == null) {
                    throw new RuntimeException("No such config: " + this.configurationUniqueId);
                }
            }
        }
    }
}

