/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.synchro;

import com.ez.eclient.configuration.synchro.PropertiesEclipseService;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchListener
implements IStartup {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(WorkbenchListener.class);

    public void earlyStartup() {
        L.info("Workbench is up... triggering lazy OSGI services");
        boolean result = this.triggerOsgiService();
        L.info("Lazy OSGI service triggered, success: {}", (Object)result);
    }

    private boolean triggerOsgiService() {
        boolean result = false;
        try {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            BundleContext context = bundle.getBundleContext();
            ServiceReference ref = context.getServiceReference(PropertiesEclipseService.class.getName());
            if (ref == null) {
                L.error("Can't take service ({}) reference.", (Object)PropertiesEclipseService.class.getName());
            } else {
                PropertiesEclipseService service = (PropertiesEclipseService)context.getService(ref);
                if (service == null) {
                    L.error("Can't obtain service {}.", (Object)PropertiesEclipseService.class.getName());
                } else {
                    result = true;
                }
            }
        }
        catch (Exception ex) {
            L.error("Unexpected error.", (Throwable)ex);
        }
        return result;
    }
}

