/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.preferences.pages;

import com.ez.common.ui.EzDirectoryFieldEditor;
import com.ez.internal.utils.Utils;
import com.ez.log4j.util.LoggerUtil;
import com.ez.workspace.Activator;
import com.ez.workspace.ui.internal.Messages;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SettingsPage.class);
    Label lblSeparator;
    ScopedPreferenceStore log4jStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.ez.eclient.logging.preferences");
    EzDirectoryFieldEditor logFed;
    BooleanFieldEditor verboseLog;

    public SettingsPage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString(SettingsPage.class, "page.description"));
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Label lblSpace = new Label(parent, 256);
        lblSpace.setText("");
        GridData lblDataSpace = new GridData(4, 0x1000000, true, false);
        lblDataSpace.horizontalSpan = 3;
        lblSpace.setLayoutData((Object)lblDataSpace);
        EzDirectoryFieldEditor fed = new EzDirectoryFieldEditor("logPathPreference", Messages.getString(SettingsPage.class, "logDir.label"), parent);
        fed.setEmptyStringAllowed(false);
        this.addField((FieldEditor)fed);
        this.logFed = fed;
        EzDirectoryFieldEditor tfed = new EzDirectoryFieldEditor("tempFolderPathPreference", Messages.getString(SettingsPage.class, "tempDir.label"), parent);
        tfed.setChangeButtonText(Messages.getString(SettingsPage.class, "tempDir.browse.label"));
        tfed.setEmptyStringAllowed(false);
        this.addField((FieldEditor)tfed);
        BooleanFieldEditor bfed = new BooleanFieldEditor("enableEasyLogPreference", Messages.getString(SettingsPage.class, "enableEasyLog4j.label"), parent);
        this.addField((FieldEditor)bfed);
        this.verboseLog = bfed;
        this.createButtonReloadLogConfiguration(parent);
    }

    private void createButtonReloadLogConfiguration(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(Messages.getString(SettingsPage.class, "log.button.reload.config"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    boolean enableEasy = SettingsPage.this.verboseLog.getBooleanValue();
                    File logDirectoryFile = new File(SettingsPage.this.logFed.getStringValue(), "ez.log");
                    if (enableEasy) {
                        File log4jConfigFile = new File(Utils.getApplicationDefaultPath(), "LogConfigurator.properties");
                        LoggerUtil.easyReconfigureLog((String)log4jConfigFile.getAbsolutePath(), (String)logDirectoryFile.getAbsolutePath());
                    } else {
                        File log4jConfigFile = new File(Utils.getApplicationDefaultPath(), "log4j2.xml");
                        LoggerUtil.standardReconfigureLog((String)log4jConfigFile.getAbsolutePath(), (String)logDirectoryFile.getAbsolutePath());
                    }
                }
                catch (Exception ex) {
                    L.error("", (Throwable)ex);
                }
            }
        });
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 3;
        gd.verticalIndent = 3;
        button.setLayoutData((Object)gd);
    }

    protected void initialize() {
        super.initialize();
        this.logFed.setPreferenceStore((IPreferenceStore)this.log4jStore);
        this.logFed.load();
    }

    public boolean performOk() {
        super.performOk();
        try {
            this.log4jStore.save();
        }
        catch (IOException e) {
            L.error("Error:", (Throwable)e);
        }
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

