/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.preferences.pages;

import com.ez.workspace.Activator;
import com.ez.workspace.ui.internal.Messages;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicensePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(LicensePreferencePage.class);
    private Text txtLicense;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        page.setLayout((Layout)layout);
        Label aboutLabel = new Label(page, 0x1000000);
        GridData gData = new GridData();
        gData.horizontalAlignment = 16384;
        aboutLabel.setLayoutData((Object)gData);
        aboutLabel.setText(Messages.getString(LicensePreferencePage.class, "licenseLabel"));
        this.txtLicense = new Text(page, 2826);
        this.txtLicense.setText(this.getLicenseText());
        gData = new GridData();
        gData.horizontalAlignment = 4;
        gData.widthHint = 400;
        gData.heightHint = 400;
        gData.grabExcessHorizontalSpace = true;
        gData.verticalAlignment = 4;
        gData.grabExcessVerticalSpace = true;
        this.txtLicense.setLayoutData((Object)gData);
        return page;
    }

    private String getLicenseText() {
        StringBuffer srcBuff;
        block18: {
            srcBuff = new StringBuffer();
            BufferedReader in = null;
            try {
                URL url = Activator.getDefault().getBundle().getEntry("resources/license.txt");
                in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                String buf = in.readLine();
                while (buf != null) {
                    srcBuff.append(buf);
                    srcBuff.append(System.lineSeparator());
                    buf = in.readLine();
                }
            }
            catch (FileNotFoundException fe) {
                L.error("getLicenseText()", (Throwable)fe);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        L.error("closing license.txt file", (Throwable)e);
                    }
                }
                break block18;
            }
            catch (IOException e) {
                try {
                    L.error("getLicenseText()", (Throwable)e);
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            L.error("closing license.txt file", (Throwable)e2);
                        }
                    }
                }
            }
            if (in == null) break block18;
            try {
                in.close();
            }
            catch (IOException e) {
                L.error("closing license.txt file", (Throwable)e);
            }
        }
        return srcBuff.toString();
    }

    public void init(IWorkbench workbench) {
    }
}

