/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.preferences.pages;

import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.ez.workspace.ui.internal.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ExpansionLimitsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int CALLGRAPH_LEVELS_LIMIT = 1000;
    int maxLimit = 20000;
    private BooleanFieldEditor cgLimit;
    private IntegerFieldEditor callgraphLevelsLimit;
    private BooleanFieldEditor highlightAtLimit;
    private Composite cgParent;
    private Font font;

    public ExpansionLimitsPage() {
        super(1);
        this.setPreferenceStore(WorkspacePrefUtils.getPreferenceStore());
        this.setDescription(Messages.getString(ExpansionLimitsPage.class, "page.description"));
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        boolean isLimited = this.getPreferenceStore().getBoolean("callgraphLevelsLimitedPreference");
        if (!isLimited) {
            this.callgraphLevelsLimit.setEnabled(false, this.cgParent);
            this.highlightAtLimit.setEnabled(false, this.cgParent);
        }
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.cgLimit = new BooleanFieldEditor("callgraphLevelsLimitedPreference", Messages.getString(ExpansionLimitsPage.class, "analysisIsLimited.label"), parent);
        this.addField((FieldEditor)this.cgLimit);
        GridData lblDataSpace = new GridData(16384, 0x1000000, false, false);
        lblDataSpace.verticalIndent = 5;
        this.cgParent = new Composite(parent, 0);
        GridLayout lay = new GridLayout(2, false);
        lay.marginLeft = 15;
        GridData parentGD = new GridData();
        parentGD.grabExcessHorizontalSpace = true;
        parentGD.grabExcessVerticalSpace = false;
        parentGD.verticalAlignment = 1;
        parentGD.horizontalAlignment = 4;
        this.cgParent.setLayoutData((Object)parentGD);
        this.callgraphLevelsLimit = new IntegerFieldEditor("callgraphLimitExceed", Messages.getString(ExpansionLimitsPage.class, "analysisThreshold.label"), this.cgParent);
        this.callgraphLevelsLimit.setValidRange(1, this.maxLimit);
        this.callgraphLevelsLimit.setErrorMessage(Messages.getString(ExpansionLimitsPage.class, "graphExceed.error", new Object[]{1000}));
        this.addField((FieldEditor)this.callgraphLevelsLimit);
        lblDataSpace = new GridData(16384, 0x1000000, false, false);
        this.callgraphLevelsLimit.getLabelControl(this.cgParent).setLayoutData((Object)lblDataSpace);
        this.highlightAtLimit = new BooleanFieldEditor("graphHighlightedOnlyExpandableAtLimit", Messages.getString(ExpansionLimitsPage.class, "highlightAtLimit.label"), this.cgParent);
        this.addField((FieldEditor)this.highlightAtLimit);
        lblDataSpace = new GridData(16384, 0x1000000, false, false);
        lblDataSpace.verticalIndent = 5;
        lblDataSpace.horizontalSpan = 2;
        this.highlightAtLimit.getDescriptionControl(this.cgParent).setLayoutData((Object)lblDataSpace);
        this.cgParent.setLayout((Layout)lay);
        Group graphSettings = new Group(parent, 0);
        graphSettings.setText(Messages.getString(ExpansionLimitsPage.class, "graphs.settings.label"));
        lay = new GridLayout(2, false);
        lay.marginLeft = 15;
        parentGD = new GridData();
        parentGD.grabExcessHorizontalSpace = true;
        parentGD.grabExcessVerticalSpace = false;
        parentGD.verticalAlignment = 1;
        parentGD.horizontalAlignment = 4;
        parentGD.horizontalSpan = 2;
        graphSettings.setLayoutData((Object)parentGD);
        IntegerFieldEditor zoomLevel = new IntegerFieldEditor("levelsZoomPreference", Messages.getString(ExpansionLimitsPage.class, "levelsToZoom.label"), (Composite)graphSettings);
        zoomLevel.setValidRange(1, 15);
        zoomLevel.setErrorMessage(Messages.getString(ExpansionLimitsPage.class, "levelsToZoom.error"));
        this.addField((FieldEditor)zoomLevel);
        BooleanFieldEditor displayIndirectLinks = new BooleanFieldEditor("indirectLinksPreference", Messages.getString(ExpansionLimitsPage.class, "indirectLinks.label"), (Composite)graphSettings);
        this.addField((FieldEditor)displayIndirectLinks);
        lblDataSpace = (GridData)displayIndirectLinks.getDescriptionControl((Composite)graphSettings).getLayoutData();
        lblDataSpace.verticalIndent = 2;
        lblDataSpace.horizontalSpan = 2;
        displayIndirectLinks.getDescriptionControl((Composite)graphSettings).setLayoutData((Object)lblDataSpace);
        IntegerFieldEditor graphExceedLimit = new IntegerFieldEditor("graphNodesExceed", Messages.getString(ExpansionLimitsPage.class, "graphExceed.label"), (Composite)graphSettings);
        graphExceedLimit.setValidRange(1, this.maxLimit);
        Object[] param = new Object[]{this.maxLimit};
        graphExceedLimit.setErrorMessage(Messages.getString(ExpansionLimitsPage.class, "graphExceed.error", param));
        this.addField((FieldEditor)graphExceedLimit);
        lblDataSpace = new GridData(16384, 0x1000000, false, false);
        lblDataSpace.verticalIndent = 2;
        graphExceedLimit.getLabelControl((Composite)graphSettings).setLayoutData((Object)lblDataSpace);
        graphSettings.setLayout((Layout)lay);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object newVal = event.getNewValue();
        Object oldVal = event.getOldValue();
        Object objSource = event.getSource();
        if (objSource.equals(this.cgLimit) && !newVal.equals(oldVal)) {
            if (newVal.equals(Boolean.TRUE)) {
                this.callgraphLevelsLimit.setEnabled(true, this.cgParent);
                this.highlightAtLimit.setEnabled(true, this.cgParent);
            } else {
                this.callgraphLevelsLimit.setEnabled(false, this.cgParent);
                this.highlightAtLimit.setEnabled(false, this.cgParent);
                this.setErrorMessage(null);
                this.setValid(true);
            }
            if (!this.callgraphLevelsLimit.isValid()) {
                this.callgraphLevelsLimit.loadDefault();
            }
        }
        super.propertyChange(event);
    }

    protected void performDefaults() {
        super.performDefaults();
        boolean isLimited = this.getPreferenceStore().getDefaultBoolean("callgraphLevelsLimitedPreference");
        if (!isLimited) {
            this.callgraphLevelsLimit.setEnabled(false, this.cgParent);
            this.highlightAtLimit.setEnabled(false, this.cgParent);
        } else {
            this.callgraphLevelsLimit.setEnabled(true, this.cgParent);
            this.highlightAtLimit.setEnabled(true, this.cgParent);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.font != null) {
            this.font.dispose();
        }
    }
}

