/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.preferences.pages;

import com.ez.common.ui.guielements.preferences.CustomComboFieldEditor;
import com.ez.internal.Activator;
import com.ez.internal.utils.PreferenceConstants;
import com.ez.internal.utils.PreferencesUtils;
import com.ez.workspace.mu.client.ClientAdapter;
import com.ez.workspace.ui.internal.Messages;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSettings
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ClientSettings.class);
    private IntegerFieldEditor clientPort;
    private CustomComboFieldEditor clientIP;
    private static String LOCALHOST = "localhost";
    private static final String RESTART_MESSAGE = Messages.getString(ClientSettings.class, "needRestart.message");

    public ClientSettings() {
        super(1);
        this.setPreferenceStore(PreferenceConstants.getInternalPrefStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Text lblDescription = new Text(parent, 8);
        lblDescription.setText(Messages.getString(ClientSettings.class, "page.description"));
        GridData lblDataDescription = new GridData(4, 0x1000000, true, false);
        lblDataDescription.horizontalSpan = 3;
        lblDescription.setLayoutData((Object)lblDataDescription);
        Label lblSpace = new Label(parent, 256);
        lblSpace.setText("");
        GridData lblDataSpace = new GridData(4, 0x1000000, true, false);
        lblDataSpace.horizontalSpan = 3;
        lblSpace.setLayoutData((Object)lblDataSpace);
        List itfs = PreferencesUtils.getHostIpAddresses();
        String[][] values = new String[itfs.size()][2];
        int i = 0;
        while (i < itfs.size()) {
            values[i][0] = (String)itfs.get(i);
            values[i][1] = (String)itfs.get(i);
            ++i;
        }
        this.clientIP = new CustomComboFieldEditor("clientCallbackExportIP", "clientCallbackExportIPCheckboxUseCheckbox", Messages.getString(ClientSettings.class, "ip.label"), values, parent){
            private boolean isValid;
            {
                this.isValid = true;
            }

            public boolean checkState() {
                if (ClientSettings.this.clientIP.getTextValue() == null) {
                    return true;
                }
                Pattern p = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
                Matcher m = p.matcher(ClientSettings.this.clientIP.getTextValue());
                return m.matches() || ClientSettings.this.clientIP.getTextValue().equalsIgnoreCase(LOCALHOST);
            }

            public boolean isValid() {
                return this.isValid;
            }

            public void refreshValidState() {
                boolean oldValidState = this.isValid();
                this.isValid = this.checkState();
                this.fireStateChanged("field_editor_is_valid", oldValidState, this.isValid());
            }
        };
        this.clientIP.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString(ClientSettings.class, "ip.checkbox.description");
            }
        });
        this.addField((FieldEditor)this.clientIP);
        this.clientPort = new IntegerFieldEditor("client.callback.export.port", Messages.getString(ClientSettings.class, "integerField.label"), parent);
        this.addField((FieldEditor)this.clientPort);
        this.verifyRestart();
    }

    private void verifyRestart() {
        String clientIP = ClientAdapter.getClient().getIP();
        int clientPort = ClientAdapter.getClient().getPort();
        IPreferenceStore ret = Activator.getDefault().getPreferenceStore();
        String ip = ret.getString("clientCallbackExportIP");
        int port = ret.getInt("client.callback.export.port");
        if (!clientIP.equalsIgnoreCase(ip) || clientPort != port) {
            this.setMessage(RESTART_MESSAGE, 2);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = ((FieldEditor)event.getSource()).getPreferenceName();
        if (event.getOldValue().equals(event.getNewValue())) {
            return;
        }
        if (property.equals("client.callback.export.port")) {
            try {
                this.clientPort.getIntValue();
                this.setErrorMessage(null);
                this.setMessage(RESTART_MESSAGE, 2);
            }
            catch (Exception ex) {
                L.error("Not an integer value", (Throwable)ex);
                this.setErrorMessage(Messages.getString(ClientSettings.class, "wrongFormatForPort.error"));
            }
        } else if (property.equals("clientCallbackExportIP")) {
            this.setMessage(RESTART_MESSAGE, 2);
        }
        super.propertyChange(event);
    }

    public void init(IWorkbench workbench) {
    }
}

