/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.gui.swt.utils;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;

public class TreeObject<T> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private TreeObject<?> parent;
    private Set<TreeObject<?>> set = new HashSet();
    private T content;
    private String name;
    private boolean group;
    private ImageDescriptor imageDescriptor;

    public TreeObject(T content, boolean group) {
        this.content = content;
        this.group = group;
    }

    public boolean testFilter(String filter, boolean groupFilter) {
        boolean retVal = false;
        if (filter != null) {
            filter = filter.trim();
        }
        if (filter == null || filter == "") {
            retVal = true;
        } else if (this.isGroup()) {
            if (groupFilter && this.toString().toLowerCase().contains(filter.toLowerCase())) {
                retVal = true;
            } else {
                for (TreeObject<?> treeObject : this.getChildren()) {
                    if (!treeObject.testFilter(filter, groupFilter)) continue;
                    retVal = true;
                    break;
                }
            }
        } else if (this.toString().toLowerCase().contains(filter.toLowerCase())) {
            retVal = true;
        } else {
            TreeObject<?> treeObject = this;
            if (groupFilter) {
                while ((treeObject = treeObject.getParent()) != null) {
                    if (!treeObject.toString().toLowerCase().contains(filter.toLowerCase())) continue;
                    retVal = true;
                    break;
                }
            } else {
                retVal = false;
            }
        }
        return retVal;
    }

    public TreeObject(T content, ImageDescriptor imageDescriptor, boolean group) {
        this(content, group);
        this.imageDescriptor = imageDescriptor;
    }

    public T getContent() {
        return this.content;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public Set<TreeObject<?>> getChildren() {
        return this.set;
    }

    public void addChildren(TreeObject<?> treeObject) {
        if (!this.group) {
            throw new IllegalArgumentException("Children can be added only to groups");
        }
        if (!this.set.contains(treeObject)) {
            this.set.add(treeObject);
            treeObject.setParent(this);
        }
    }

    public void removeChild(TreeObject<?> treeObject) {
        if (this.set.contains(treeObject)) {
            this.set.remove(treeObject);
            super.removeParent(this);
        }
    }

    public TreeObject<?> getParent() {
        return this.parent;
    }

    public void setParent(TreeObject<?> treeObject) {
        if (!treeObject.group) {
            throw new IllegalArgumentException("Children can be added only to groups");
        }
        if (this.parent != null && this.parent != treeObject) {
            this.parent.removeChild(this);
        }
        this.parent = treeObject;
        this.parent.addChildren(this);
    }

    private void removeParent(TreeObject<?> treeObject) {
        if (treeObject.equals(this.parent) && this.parent != treeObject) {
            this.parent = null;
            treeObject.removeChild(this);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGroup() {
        return this.group;
    }

    public String toString() {
        if (this.name != null && !this.name.trim().equals("")) {
            return this.name;
        }
        return this.content.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TreeObject) {
            return obj.toString().equals(this.toString()) && this.group == ((TreeObject)obj).group;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public void doubleClickActionHandler() {
    }

    public void run() {
    }
}

