/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.gui.swt.utils;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Table;

public abstract class TableViewerComparator<T>
extends ViewerComparator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private int propertyIndex = -1;
    private int direction = 128;
    private Table table;

    public TableViewerComparator(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("Table must not be null");
        }
        this.table = table;
        this.setColumn(0);
    }

    public Table getTable() {
        return this.table;
    }

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public void setColumn(int columnIndex) {
        if (columnIndex == this.propertyIndex) {
            switch (this.direction) {
                case 128: {
                    this.direction = 1024;
                    break;
                }
                default: {
                    this.direction = 128;
                    break;
                }
            }
        } else {
            this.propertyIndex = columnIndex;
            this.direction = 128;
        }
        this.table.setSortColumn(this.table.getColumn(columnIndex));
        this.table.setSortDirection(this.direction);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        Object resourceData1 = e1;
        Object resourceData2 = e2;
        int retVal = this.compare(this.propertyIndex, this.direction, resourceData1, resourceData2);
        int i = 0;
        while (i < this.table.getColumnCount() && retVal == 0) {
            if (i != this.propertyIndex) {
                retVal = this.compare(i, this.direction, resourceData1, resourceData2);
            }
            ++i;
        }
        return retVal;
    }

    public abstract int compare(int var1, int var2, T var3, T var4);
}

