/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.gui;

import com.ez.common.ui.swt.DpiScaler;
import com.ez.internal.analysis.config.context.NavigatorContext;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.model.EZProject;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.ui.internal.Messages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProjectChooserDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectChooserDialog.class);
    private static final String SELECT_LABEL = Messages.getString(ProjectChooserDialog.class, "generateReport.button");
    private static final int DIALOG_MIN_HEIGHT = 200;
    private static final int DIALOG_MIN_WIDTH = 300;
    protected org.eclipse.swt.widgets.List avList;
    protected Button select;
    protected List selPrjList;
    protected List<String> projectNatures = new ArrayList<String>();
    protected Class analysisClass = null;
    protected ProjectSelectionListener selectionListener;
    protected Label prjLbl;

    public ProjectChooserDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(300, 200);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.heightHint = DpiScaler.getScaledSize((int)300);
        area.setLayoutData((Object)data);
        GridLayout gl = (GridLayout)area.getLayout();
        area.setLayout((Layout)gl);
        this.prjLbl = new Label(area, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.prjLbl.setLayoutData((Object)data);
        this.prjLbl.setText(Messages.getString(ProjectChooserDialog.class, "chooseProjects.dialog.label"));
        this.avList = new org.eclipse.swt.widgets.List(area, 2816);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.avList.setLayoutData((Object)data);
        this.selectionListener = new ProjectSelectionListener();
        this.avList.addSelectionListener((SelectionListener)this.selectionListener);
        this.filterProjects();
        return area;
    }

    protected void filterProjects() {
        EZProject[] prjs = EZWorkspace.getInstance().getProjects();
        if (prjs != null && prjs.length > 0) {
            ArrayList<String> names = new ArrayList<String>();
            String prjName = null;
            int i = 0;
            while (i < prjs.length) {
                if (this.projectHasNature(prjs[i].getProject())) {
                    prjName = prjs[i].toString();
                    names.add(prjName);
                    this.avList.setData(prjName, (Object)prjs[i]);
                }
                ++i;
            }
            String[] namePrjs = names.toArray(new String[0]);
            this.avList.setItems(namePrjs);
        }
    }

    private boolean projectHasNature(IProject project) {
        boolean has = false;
        if (this.projectNatures.isEmpty()) {
            L.warn("you must specify at least a nature for your analysis");
        }
        Iterator<String> iterator = this.projectNatures.iterator();
        while (iterator.hasNext() && !has) {
            String nature = iterator.next();
            try {
                has = project.hasNature(nature);
            }
            catch (CoreException e) {
                L.warn("projectHasNature()", (Throwable)e);
            }
        }
        return has;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.select = this.createButton(parent, 0, SELECT_LABEL, true);
        String[] selPrjNameList = this.avList.getSelection();
        if (selPrjNameList != null && selPrjNameList.length > 0) {
            this.selPrjList = new ArrayList();
            int i = 0;
            while (i < selPrjNameList.length) {
                this.selPrjList.add((EZProject)this.avList.getData(selPrjNameList[i]));
                ++i;
            }
            this.select.setEnabled(true);
        } else {
            this.select.setEnabled(false);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        if (this.selPrjList != null && this.analysisClass != null) {
            for (EZProject currentPrj : this.selPrjList) {
                IProject iProj = currentPrj.getProject();
                EZWorkspace wk = EZWorkspace.getInstance();
                EZEntityID projID = wk.getProjID((IResource)iProj);
                EZProjectInputType inputType = currentPrj.getProjectInputTypeInstance();
                inputType.setEntID(projID);
                inputType.setName(iProj.getName());
                inputType.setContext(NavigatorContext.class);
                EZAnalysisType analysisType = wk.getSpecificAnalysisType((EZObjectType)inputType, this.analysisClass);
                if (analysisType == null) continue;
                EZAnalysis analysis = analysisType.getImplementorInstance();
                ArrayList<EZProjectInputType> inputs = new ArrayList<EZProjectInputType>();
                inputs.add(inputType);
                analysis.setInputs(inputs);
                HashSet<EZEntityID> set = new HashSet<EZEntityID>();
                set.add(projID);
                analysis.setScope(1, set);
                analysis.execute();
            }
        }
        super.okPressed();
    }

    class ProjectSelectionListener
    extends SelectionAdapter {
        ProjectSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String[] selPrjNameList = ((org.eclipse.swt.widgets.List)e.getSource()).getSelection();
            if (selPrjNameList != null && selPrjNameList.length > 0) {
                ProjectChooserDialog.this.selPrjList = new ArrayList();
                int i = 0;
                while (i < selPrjNameList.length) {
                    ProjectChooserDialog.this.selPrjList.add((EZProject)ProjectChooserDialog.this.avList.getData(selPrjNameList[i]));
                    ++i;
                }
                ProjectChooserDialog.this.select.setEnabled(true);
            }
        }
    }
}

