/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.mouseHook;

import com.ez.internal.analysis.config.inputs.EZCallAndDefStmt;
import com.ez.internal.analysis.config.inputs.EZChooseScreenCallGraph;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.protection.Registry;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import com.ez.workspace.analysis.category.ICategory;
import com.ez.workspace.analysis.category.ICategoryEntry;
import com.ez.workspace.analysis.graph.job.GraphEditor;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.mouseHook.AnalysisContributorComparator;
import com.ez.workspace.analysis.graph.mouseHook.EdgeActionsMouseHookAdapter;
import com.ez.workspace.analysis.graph.mouseHook.ResourcesChooserDialog;
import com.ez.workspace.analysis.job.SelectionJob;
import com.ez.workspace.model.CategoryManager;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.Utils;
import com.ez.workspace.model.segments.EZProjectIDSg;
import com.ez.workspace.model.segments.EZSourceResourceIDSg;
import com.ez.workspace.ui.Activator;
import com.ez.workspace.ui.internal.Messages;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WUMouseActionsHookAdapter
extends EdgeActionsMouseHookAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(WUMouseActionsHookAdapter.class);
    private MenuManager subMenu = null;
    protected AbstractAnalysisGraphModel graphModel = null;
    protected AbstractSharedAnalysis analysis = null;
    protected SelectionJob selectJob;
    protected GraphInfo graphInfo;
    protected TSSwingCanvas canvas;
    protected TSEGraphManager graphManager;
    protected static final String SHOW_SOURCE = Messages.getString(WUMouseActionsHookAdapter.class, "goToSource.button");
    protected static final String SHOW_SOURCE_WITH_DOTS = Messages.getString(WUMouseActionsHookAdapter.class, "goToSource.dots.button");
    protected static final String SHOW_PROPERTIES = Messages.getString(WUMouseActionsHookAdapter.class, "showProperties.button");
    public static final String HIDE_ALL_EDGES = Messages.getString(WUMouseActionsHookAdapter.class, "hide.all.edges.button");
    public static final String SHOW_ALL_EDGES = Messages.getString(WUMouseActionsHookAdapter.class, "show.all.edges.button");
    public static final String HIDE_SELECTED = Messages.getString(WUMouseActionsHookAdapter.class, "hide.selected.button");
    public static final String HIDE_UNCONNECTED = Messages.getString(WUMouseActionsHookAdapter.class, "hide.unconnected.button");
    private NodeAction linkEditor = null;
    private NodeAction showProperties = null;
    private NodeAction showPropertiesOnClick = null;
    private BackgroundAction hideAllEdges = null;
    private BackgroundAction showAllEdges = null;
    private BackgroundAction hideSelected = null;
    private BackgroundAction hideUnconnected = null;
    private NodeAction link = null;

    public AbstractAnalysisGraphModel getGraphModel() {
        return this.graphModel;
    }

    public void setSelectJob(SelectionJob selectJob) {
        this.selectJob = selectJob;
    }

    public void setAnalysis(AbstractSharedAnalysis analysis) {
        this.analysis = analysis;
    }

    public void setGraphModel(AbstractAnalysisGraphModel graphModel) {
        this.graphModel = graphModel;
        this.graphManager = graphModel.getGraphManager();
    }

    public void setGraphInfo(GraphInfo info) {
        this.graphInfo = info;
        this.canvas = (TSSwingCanvas)info.getCanvasComponent();
    }

    @Override
    public List getRightClickContributions(TSENode tsNode) {
        ArrayList<Object> contextItems = new ArrayList<Object>();
        contextItems.add(new Separator());
        if (tsNode != null) {
            Boolean withGoToSrc = this.overrideTSMemberAttribute((TSGraphMember)tsNode, "GOTOSOURCE") != null;
            if (withGoToSrc != null && withGoToSrc.booleanValue()) {
                if (this.linkEditor == null) {
                    this.linkEditor = new NodeAction(this){

                        @Override
                        public void execute(IProgressMonitor monitor) {
                            monitor.beginTask(Messages.getString(WUMouseActionsHookAdapter.class, "goToSource.task.text"), -1);
                            this.makeSelection(this.node);
                            monitor.done();
                        }
                    };
                }
                this.linkEditor.setText(SHOW_SOURCE);
                this.linkEditor.setNode(tsNode);
                contextItems.add(new ActionContributionItem((IAction)this.linkEditor));
            }
            contextItems.add(new Separator("additions"));
            this.addAnalysisActions(tsNode, contextItems);
            contextItems.add(new Separator());
            Boolean hasProperties = this.overrideTSMemberAttribute((TSGraphMember)tsNode, "HAS_PROPERTIES_IN_PROPVIEW") != null;
            if (hasProperties == null || hasProperties.booleanValue()) {
                if (this.showProperties == null) {
                    this.showProperties = new NodeAction(this){

                        @Override
                        public void execute(IProgressMonitor monitor) {
                            monitor.beginTask(Messages.getString(WUMouseActionsHookAdapter.class, "showProperty.task.text"), -1);
                            this.makeSelection4Properties(this.node);
                            monitor.done();
                        }
                    };
                }
                this.showProperties.setText(SHOW_PROPERTIES);
                this.showProperties.setNode(tsNode);
                this.showProperties.setImageDescriptor(Activator.getImageDescriptor("icons/properties.gif"));
                contextItems.add(new ActionContributionItem((IAction)this.showProperties));
            }
        }
        HashMap<IContributionItem, Integer> info = new HashMap<IContributionItem, Integer>();
        int groupNo = 0;
        for (Object e : contextItems) {
            IContributionItem ci = (IContributionItem)e;
            if (ci.isSeparator()) {
                info.put(ci, ++groupNo);
                ++groupNo;
                continue;
            }
            info.put(ci, groupNo);
        }
        Collections.sort(contextItems, new AnalysisContributorComparator(info));
        return contextItems;
    }

    @Override
    public List getRightClickContributions(TSEEdge tsEdge, Object contextData) {
        return null;
    }

    @Override
    public List getRightClickContributions() {
        ArrayList<Object> contextItems = new ArrayList<Object>();
        contextItems.add(new Separator("additions"));
        if (this.hideAllEdges == null) {
            this.hideAllEdges = new BackgroundAction(this){

                @Override
                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString(WUMouseActionsHookAdapter.class, "hideEdges.task.text"), -1);
                    GraphEditor.hideAllEdges(graphManager, canvas, graphInfo, graphModel);
                }
            };
        }
        this.hideAllEdges.setEnabled(true);
        this.hideAllEdges.setText(HIDE_ALL_EDGES);
        this.hideAllEdges.setImageDescriptor(Activator.getImageDescriptor("icons/hideAll.gif"));
        this.hideAllEdges.setEnabled(true);
        contextItems.add((Object)new BackgroundActionContributionItem(this.hideAllEdges));
        if (this.showAllEdges == null) {
            this.showAllEdges = new BackgroundAction(this){

                @Override
                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString(WUMouseActionsHookAdapter.class, "unhideEdges.task.text"), -1);
                    GraphEditor.showAllEdges(graphManager, canvas, graphInfo, graphModel);
                }
            };
        }
        this.showAllEdges.setEnabled(true);
        this.showAllEdges.setText(SHOW_ALL_EDGES);
        this.showAllEdges.setImageDescriptor(Activator.getImageDescriptor("icons/showAll5.gif"));
        this.showAllEdges.setEnabled(true);
        contextItems.add((Object)new BackgroundActionContributionItem(this.showAllEdges));
        contextItems.add(new Separator("additions"));
        if (this.hideSelected == null) {
            this.hideSelected = new BackgroundAction(this){

                @Override
                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString(WUMouseActionsHookAdapter.class, "hideNode.task.text"), -1);
                    GraphEditor.hideSelected(graphManager, canvas, graphInfo);
                    monitor.done();
                }
            };
        }
        this.hideSelected.setText(HIDE_SELECTED);
        this.hideSelected.setImageDescriptor(Activator.getImageDescriptor("icons/hideSelected.png"));
        this.hideSelected.setEnabled(true);
        contextItems.add((Object)new BackgroundActionContributionItem(this.hideSelected));
        if (this.hideUnconnected == null) {
            this.hideUnconnected = new BackgroundAction(this){

                @Override
                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString(WUMouseActionsHookAdapter.class, "hideNode.task.text"), -1);
                    GraphEditor.hideUnconnectedNodes(graphManager, canvas, graphInfo, graphModel);
                    monitor.done();
                }
            };
        }
        this.hideUnconnected.setText(HIDE_UNCONNECTED);
        this.hideUnconnected.setImageDescriptor(Activator.getImageDescriptor("icons/hideUnconnected.png"));
        this.hideUnconnected.setEnabled(true);
        contextItems.add((Object)new BackgroundActionContributionItem(this.hideUnconnected));
        return contextItems;
    }

    @Override
    public Action getDoubleClickAction(TSENode node) {
        if (node == null) {
            return null;
        }
        if (this.link == null) {
            this.link = new NodeAction(this){

                @Override
                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString(WUMouseActionsHookAdapter.class, "goToStructureView.task.text"), -1);
                    this.makeSelection(this.node);
                    monitor.done();
                }
            };
        }
        this.link.setText(SHOW_SOURCE);
        this.link.setNode(node);
        this.link.setEnabled(true);
        return this.link;
    }

    @Override
    public Action getClickSelection(TSENode node) {
        if (node == null) {
            return null;
        }
        if (this.showPropertiesOnClick == null) {
            this.showPropertiesOnClick = new NodeAction(this){

                @Override
                public void execute(IProgressMonitor pmonitor) {
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
                    monitor.beginTask(Messages.getString(WUMouseActionsHookAdapter.class, "showProperty.task.text"), -1);
                    this.makeSelection4Properties(this.node);
                    this.makePathSelection((TSGraphMember)this.node, (IProgressMonitor)monitor.newChild(70));
                    monitor.done();
                }
            };
        }
        this.showPropertiesOnClick.setText(SHOW_PROPERTIES);
        this.showPropertiesOnClick.setNode(node);
        this.showPropertiesOnClick.setEnabled(true);
        Boolean hasProperties = this.overrideTSMemberAttribute((TSGraphMember)node, "HAS_PROPERTIES_IN_PROPVIEW") != null;
        if (hasProperties != null && !hasProperties.booleanValue()) {
            return null;
        }
        return this.showPropertiesOnClick;
    }

    public void makePathSelection(TSGraphMember member, IProgressMonitor pmonitor) {
    }

    public Object overrideTSMemberAttribute(TSGraphMember tsMember, String attr) {
        return tsMember.getAttributeValue(attr);
    }

    @Override
    public boolean containsInput(EZObjectType objType) {
        EZEntityID id;
        boolean sameInput = false;
        List inputs = ((AbstractAnalysis)this.analysis).getInputs();
        if (inputs.contains(id = objType.getEntID())) {
            sameInput = true;
        }
        return sameInput;
    }

    protected void addAnalysisActions(List<TSNode> tsNodeList, List contextItems) {
        EZObjectType applicableInputType = this.graphModel.getApplicableInputType(tsNodeList);
        this.createAnalysisAction(applicableInputType, null, contextItems);
    }

    protected void addAnalysisActions(TSENode tsNode, List contextItems) {
        EZObjectType applicableInputType = this.graphModel.getApplicableInputType((TSNode)tsNode);
        this.createAnalysisAction(applicableInputType, tsNode, contextItems);
    }

    protected void createAnalysisAction(EZObjectType applicableInputType, TSENode tsNode, List contextItems) {
        NodeAction analysisAction = null;
        boolean sameInput = false;
        Set screenNumbers_temp = null;
        if (applicableInputType != null) {
            sameInput = this.containsInput(applicableInputType);
            EZWorkspace wk = EZWorkspace.getInstance();
            List listAnalysisTypes = wk.getSpecificAnalysisType(applicableInputType);
            HashMap<String, MenuManager> menus = new HashMap<String, MenuManager>();
            if (listAnalysisTypes != null) {
                Iterator aIt = listAnalysisTypes.iterator();
                while (aIt.hasNext()) {
                    Set resources_temp = this.graphModel.getResources((TSNode)tsNode);
                    EZAnalysisType analysisType = (EZAnalysisType)aIt.next();
                    if (applicableInputType instanceof EZChooseScreenCallGraph) {
                        screenNumbers_temp = analysisType.getId().equals("callgraph") ? resources_temp : null;
                        resources_temp = null;
                    }
                    Set resources = resources_temp;
                    final Set screens = screenNumbers_temp;
                    if (!this.checkAnalysis(analysisType)) continue;
                    EZInputFilter inputFilter = analysisType.getInputFilterInstance();
                    ArrayList<EZObjectType> applicableInputsType = new ArrayList<EZObjectType>();
                    applicableInputsType.add(applicableInputType);
                    if (inputFilter != null && !inputFilter.checkAnalysisAvailability(applicableInputsType) || this.analysis.getType().equals((Object)analysisType) && sameInput) continue;
                    if (resources != null && resources.size() > 0) {
                        this.subMenu = new MenuManager(analysisType.getName());
                        for (final IResource resource : resources) {
                            analysisAction = new NodeAction(this){

                                @Override
                                public void execute(IProgressMonitor monitor) {
                                    monitor.beginTask(this.analysisType.getName(), -1);
                                    this.executeAnalysisForResource(this.analysisType, this.objType, resource, this.node);
                                    monitor.done();
                                }
                            };
                            analysisAction.analysisType = analysisType;
                            analysisAction.node = tsNode;
                            analysisAction.objType = applicableInputType;
                            String resName = resource.getName();
                            resName = Utils.removeExtension((String)resName);
                            Object[] param = new String[]{resName};
                            String str = Messages.getString(WUMouseActionsHookAdapter.class, "analyze.action.text", param);
                            analysisAction.setText(str);
                            analysisAction.setImageDescriptor(analysisType.getIconDescriptor());
                            this.subMenu.add((IContributionItem)new ActionContributionItem((IAction)analysisAction));
                        }
                        contextItems.add(this.subMenu);
                        continue;
                    }
                    if (screens != null) {
                        analysisAction = new NodeAction(this){

                            @Override
                            public void execute(IProgressMonitor monitor) {
                                monitor.beginTask(this.analysisType.getName(), -1);
                                this.executeChoosenCallgraphAnalysis(this.analysisType, this.objType, screens, this.node);
                                monitor.done();
                            }
                        };
                        analysisAction.analysisType = analysisType;
                        analysisAction.node = tsNode;
                        analysisAction.objType = applicableInputType;
                        String str_ = Messages.getString(WUMouseActionsHookAdapter.class, "choose.screen.action.text");
                        analysisAction.setText(str_);
                        analysisAction.setImageDescriptor(analysisType.getIconDescriptor());
                        if (screens.size() == 0) {
                            analysisAction.setEnabled(false);
                        }
                        contextItems.add(new ActionContributionItem((IAction)analysisAction));
                        continue;
                    }
                    MenuManager mm = null;
                    MenuManager supMm = null;
                    CategoryManager cm = wk.getCategoryManager();
                    ICategoryEntry catEntry = cm.getCategoryEntry(analysisType.getId());
                    if (catEntry != null) {
                        String category = catEntry.getCategory();
                        String supraCategory = cm.getCategory(category).getCategory();
                        ICategory supraCatObj = null;
                        supMm = (MenuManager)menus.get(supraCategory);
                        if (supraCategory != null) {
                            supraCatObj = cm.getCategory(supraCategory);
                            if (supMm == null) {
                                supMm = new MenuManager(supraCatObj.getName(), supraCatObj.getImageDescriptor(), supraCatObj.getId());
                                menus.put(supraCategory, supMm);
                                contextItems.add(supMm);
                            }
                        }
                        if ((mm = (MenuManager)menus.get(category)) == null) {
                            ICategory categoryObj = cm.getCategory(category);
                            mm = new MenuManager(categoryObj.getName(), categoryObj.getImageDescriptor(), categoryObj.getId());
                            menus.put(category, mm);
                            if (supraCategory != null) {
                                supMm.add((IContributionItem)mm);
                            } else {
                                contextItems.add(mm);
                            }
                        }
                    }
                    if (applicableInputType.getProperty("resource segments to start an individual analysis") != null) {
                        this.subMenu = this.createSubMenu(analysisType, tsNode, applicableInputType);
                        if (mm != null) {
                            mm.add((IContributionItem)this.subMenu);
                            continue;
                        }
                        contextItems.add(this.subMenu);
                        continue;
                    }
                    EZCallAndDefStmt clone = null;
                    analysisAction = new NodeAction(this){

                        @Override
                        public void execute(IProgressMonitor monitor) {
                            monitor.beginTask(this.analysisType.getName(), -1);
                            this.executeAnalysis(this.analysisType, this.objType, this.node);
                            monitor.done();
                        }
                    };
                    if (analysisType.getId().equals("showflownotflow") && applicableInputType instanceof EZCallAndDefStmt) {
                        clone = (EZCallAndDefStmt)applicableInputType.copy();
                        clone.setEntID(clone.getCallEntity());
                        clone.setStmtID(clone.getCallStmtID());
                    }
                    analysisAction.analysisType = analysisType;
                    analysisAction.node = tsNode;
                    analysisAction.objType = clone != null ? clone : applicableInputType;
                    analysisAction.setText(analysisType.getName());
                    analysisAction.setImageDescriptor(analysisType.getIconDescriptor());
                    ActionContributionItem aci = new ActionContributionItem((IAction)analysisAction);
                    if (mm != null) {
                        ArrayList<Object> namesList = new ArrayList<Object>();
                        IContributionItem[] iContributionItemArray = mm.getItems();
                        int n = iContributionItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContributionItem item = iContributionItemArray[n2];
                            namesList.add(item);
                            ++n2;
                        }
                        namesList.add(aci);
                        HashMap<IContributionItem, Integer> info = new HashMap<IContributionItem, Integer>();
                        int groupNo = 0;
                        for (Object e : namesList) {
                            IContributionItem ci = (IContributionItem)e;
                            if (ci.isSeparator()) {
                                info.put(ci, ++groupNo);
                                ++groupNo;
                                continue;
                            }
                            info.put(ci, groupNo);
                        }
                        Collections.sort(namesList, new AnalysisContributorComparator(info));
                        mm.insert(namesList.indexOf(aci), (IContributionItem)aci);
                        if (supMm == null) continue;
                        IContributionItem[] iContributionItemArray2 = supMm.getItems();
                        supMm.removeAll();
                        Arrays.sort(iContributionItemArray2, new Comparator<IContributionItem>(){

                            @Override
                            public int compare(IContributionItem contr1, IContributionItem contr2) {
                                return contr1.toString().compareTo(contr2.toString());
                            }
                        });
                        IContributionItem[] iContributionItemArray22 = iContributionItemArray2;
                        int n3 = iContributionItemArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IContributionItem supraCatContributionItem = iContributionItemArray22[n4];
                            supMm.add(supraCatContributionItem);
                            ++n4;
                        }
                        continue;
                    }
                    contextItems.add(aci);
                }
            }
        }
    }

    private MenuManager createSubMenu(EZAnalysisType analysisType, TSENode tsNode, EZObjectType applicableInputType) {
        MenuManager subMenu = new MenuManager(analysisType.getName());
        Collection sgs = (Collection)applicableInputType.getProperty("resource segments to start an individual analysis");
        ArrayList<String> localAnalysisName = new ArrayList<String>();
        for (final EZSourceResourceIDSg resSg : sgs) {
            NodeAction analysisAction = new NodeAction(this){

                @Override
                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(this.analysisType.getName(), -1);
                    this.executeAnalysisForResourceSg(this.analysisType, this.objType, (EZSegment)resSg, this.node);
                    monitor.done();
                }
            };
            analysisAction.analysisType = analysisType;
            analysisAction.node = tsNode;
            analysisAction.objType = applicableInputType;
            String resName = resSg.getResourceName();
            Object[] param = new String[]{resName};
            String str = Messages.getString(WUMouseActionsHookAdapter.class, "analyze.action.text", param);
            analysisAction.setText(str);
            analysisAction.setImageDescriptor(analysisType.getIconDescriptor());
            localAnalysisName.add(str);
            Collections.sort(localAnalysisName);
            subMenu.insert(localAnalysisName.indexOf(str), (IContributionItem)new ActionContributionItem((IAction)analysisAction));
        }
        return subMenu;
    }

    private void executeAnalysisForResourceSg(EZAnalysisType analysisType, EZObjectType objType, EZSegment seg, TSENode tsNode) {
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        EZAnalysis analysis = analysisType.getImplementorInstance();
        EZObjectType type = objType.copy();
        EZEntityID entID = new EZEntityID();
        type.setEntID(entID);
        type.setName(objType.getName());
        type.setContext(objType.getContext());
        entID.addEntitySegments(objType.getEntID());
        entID.addSegment(seg);
        inputs.add(type);
        analysis.setInputs(inputs);
        if (this.graphManager.hasAttribute("projects")) {
            analysis.addContextValue("projects", this.graphManager.getAttributeValue("projects"));
        }
        analysis.execute();
    }

    protected void executeAnalysis(EZAnalysisType analysisType, EZObjectType objType, TSENode tsNode) {
        EZAnalysis analysis = analysisType.getImplementorInstance();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        inputs.add(objType);
        analysis.setInputs(inputs);
        if (tsNode != null && !tsNode.hasAttribute("VIRTUAL_DATASET")) {
            this.makeAnalysisScope(analysis, objType, tsNode);
        }
        if (this.graphManager.hasAttribute("projects")) {
            analysis.addContextValue("projects", this.graphManager.getAttributeValue("projects"));
        }
        analysis.execute();
    }

    private void executeChoosenCallgraphAnalysis(final EZAnalysisType analysisType, final EZObjectType objType, Set allResources, final TSENode tsNode) {
        final ResourcesChooserDialog dialog = new ResourcesChooserDialog(null, allResources);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (dialog.open() == 0) {
                    List<IResource> inputList = dialog.getSelResourceList();
                    WUMouseActionsHookAdapter.this.executeAnalysisForMoreResource(analysisType, objType, inputList, tsNode);
                }
            }
        });
    }

    private void executeAnalysisForResource(EZAnalysisType analysisType, EZObjectType objType, IResource resource, TSENode tsNode) {
        ArrayList<IResource> resList = new ArrayList<IResource>();
        resList.add(resource);
        this.executeAnalysisForMoreResource(analysisType, objType, resList, tsNode);
    }

    private void executeAnalysisForMoreResource(EZAnalysisType analysisType, EZObjectType objType, List<IResource> resources, TSENode tsNode) {
        EZWorkspace wk = EZWorkspace.getInstance();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        EZAnalysis analysis = analysisType.getImplementorInstance();
        for (IResource resource : resources) {
            EZEntityID entID = wk.getModelEntityID(resource);
            if (entID == null) continue;
            if (tsNode.hasAttribute("DB_STMTS_4TSNODE")) {
                Set stmtSet = (Set)tsNode.getAttributeValue("DB_STMTS_4TSNODE");
                this.processStmtsSet(resource, stmtSet, objType);
            }
            EZObjectType type = objType.copy();
            type.setEntID(entID);
            type.setName(objType.getName());
            type.setContext(objType.getContext());
            inputs.add(type);
        }
        this.makeAnalysisScope(analysis, objType, tsNode);
        analysis.setInputs(inputs);
        analysis.execute();
    }

    private void makeAnalysisScope(EZAnalysis analysis, EZObjectType objType, TSENode tsNode) {
        EZProjectIDSg projSG;
        EZEntityID id = this.graphModel.getFileEntity((TSNode)tsNode);
        if (id == null) {
            id = objType.getEntID();
        }
        if (id != null && (projSG = (EZProjectIDSg)id.getSegment(EZProjectIDSg.class)) != null) {
            EZEntityID projectID = new EZEntityID();
            projectID.addSegment((EZSegment)projSG);
            id = projectID;
            HashSet<EZEntityID> set = new HashSet<EZEntityID>();
            set.add(id);
            analysis.setScope(1, set);
        }
    }

    protected void processStmtsSet(IResource resource, Set stmtSet, EZObjectType objType) {
    }

    @Override
    public void dispose() {
        this.analysis = null;
        this.canvas = null;
        this.graphInfo = null;
        this.graphManager = null;
        this.graphModel = null;
        this.selectJob = null;
        if (this.subMenu != null) {
            this.subMenu.dispose();
        }
        if (this.hideAllEdges != null) {
            this.hideAllEdges.dispose();
            this.hideAllEdges = null;
        }
        if (this.hideSelected != null) {
            this.hideSelected.dispose();
            this.hideSelected = null;
        }
        if (this.hideUnconnected != null) {
            this.hideUnconnected.dispose();
            this.hideUnconnected = null;
        }
        if (this.link != null) {
            this.link.dispose();
            this.link = null;
        }
        if (this.linkEditor != null) {
            this.linkEditor.dispose();
            this.linkEditor = null;
        }
        if (this.showAllEdges != null) {
            this.showAllEdges.dispose();
            this.showAllEdges = null;
        }
        if (this.showProperties != null) {
            this.showProperties.dispose();
            this.showProperties = null;
        }
        if (this.showPropertiesOnClick != null) {
            this.showPropertiesOnClick.dispose();
            this.showPropertiesOnClick = null;
        }
    }

    protected boolean checkAnalysis(EZAnalysisType type) {
        boolean enabled = false;
        Registry reg = Registry.getInstance();
        Class clazz = type.getClazz();
        if (clazz == null) {
            L.error("null class for analysis type: {}", (Object)type);
        } else {
            String className = clazz.getName();
            enabled = reg.check(className);
            PlatformUI.getPreferenceStore().firePropertyChangeEvent("action", (Object)new Boolean(false), (Object)new Boolean(enabled));
        }
        return enabled;
    }

    protected static int getIndexFromListForViewSource(List<?> list) {
        int index = -1;
        int i = 0;
        while (i < list.size()) {
            String actionName;
            Object o = list.get(i);
            if (o instanceof ActionContributionItem && (SHOW_SOURCE.equals(actionName = ((ActionContributionItem)o).getAction().getText()) || SHOW_SOURCE_WITH_DOTS.equals(actionName))) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public abstract class BackgroundAction
    extends Action {
        protected IResource resource;
        protected EZAnalysisType analysisType;
        protected EZObjectType objType = null;
        private Job job = new ActionJob();

        public BackgroundAction() {
            this.job.setUser(true);
        }

        public void dispose() {
            this.resource = null;
            this.analysisType = null;
            this.objType = null;
            this.job = null;
        }

        public abstract void execute(IProgressMonitor var1);

        public void run() {
            this.job.setName(this.getText());
            this.job.schedule();
        }

        public boolean equals(Object obj) {
            boolean isEqual = false;
            if (!(obj instanceof BackgroundAction)) {
                return isEqual;
            }
            String text = this.getText();
            isEqual = text == null ? false : text.equals(((BackgroundAction)((Object)obj)).getText());
            return isEqual;
        }

        private class ActionJob
        extends Job {
            public ActionJob() {
                super("action job");
            }

            protected IStatus run(IProgressMonitor monitor) {
                BackgroundAction.this.execute(monitor);
                return Status.OK_STATUS;
            }
        }
    }

    public class BackgroundActionContributionItem
    extends ActionContributionItem {
        public BackgroundActionContributionItem(BackgroundAction action) {
            super((IAction)action);
        }
    }

    public abstract class EdgeAction
    extends Action {
        protected TSEEdge edge;
        protected IResource resource;
        protected EZAnalysisType analysisType;
        protected EZObjectType objType = null;
        private Job job = new ActionJob();
        Object contextData;

        public EdgeAction() {
            this.job.setUser(true);
        }

        public void setNode(TSEEdge edge) {
            this.edge = edge;
        }

        public void setContextData(Object data) {
            this.contextData = data;
        }

        public Object getContextData() {
            return this.contextData;
        }

        public abstract void execute(IProgressMonitor var1);

        public void run() {
            this.job.setName(this.getText());
            this.job.schedule();
        }

        public void dispose() {
            this.edge = null;
            this.resource = null;
            this.analysisType = null;
            this.objType = null;
            this.job = null;
            this.contextData = null;
        }

        private class ActionJob
        extends Job {
            public ActionJob() {
                super("action job");
            }

            protected IStatus run(IProgressMonitor monitor) {
                EdgeAction.this.execute(monitor);
                return Status.OK_STATUS;
            }
        }
    }

    public abstract class NodeAction
    extends Action {
        protected TSENode node;
        protected EZAnalysisType analysisType;
        protected EZObjectType objType = null;
        private Job job = new ActionJob();

        public NodeAction() {
            this.job.setUser(true);
        }

        public void dispose() {
            this.node = null;
            this.analysisType = null;
            this.job = null;
            this.objType = null;
        }

        public void setNode(TSENode node) {
            this.node = node;
        }

        public abstract void execute(IProgressMonitor var1);

        public void run() {
            this.job.setName(this.getText());
            this.job.schedule();
        }

        public void setObjType(EZObjectType inputType) {
            this.objType = inputType;
        }

        public void setAnalysisType(EZAnalysisType analysisType) {
            this.analysisType = analysisType;
        }

        private class ActionJob
        extends Job {
            public ActionJob() {
                super("action job");
            }

            protected IStatus run(IProgressMonitor monitor) {
                NodeAction.this.execute(monitor);
                return Status.OK_STATUS;
            }
        }
    }
}

