/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.mouseHook;

import com.ez.workspace.model.Utils;
import com.ez.workspace.ui.internal.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesChooserDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResourcesChooserDialog.class);
    private static final String SELECT_LABEL = Messages.getString(ResourcesChooserDialog.class, "ok.button");
    private static final String TITLE = Messages.getString(ResourcesChooserDialog.class, "screens.number.title");
    private static final int DIALOG_MIN_HEIGHT = 200;
    private static final int DIALOG_MIN_WIDTH = 300;
    protected org.eclipse.swt.widgets.List avList;
    protected Button select;
    private Set<IResource> allResources;
    protected List<IResource> selResourceList;

    protected ResourcesChooserDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public ResourcesChooserDialog(Shell shell, Set<IResource> allResources) {
        super(shell);
        this.allResources = allResources;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(300, 200);
        newShell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.heightHint = 300;
        area.setLayoutData((Object)data);
        GridLayout gl = (GridLayout)area.getLayout();
        area.setLayout((Layout)gl);
        Label prjLbl = new Label(area, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        prjLbl.setLayoutData((Object)data);
        prjLbl.setText(Messages.getString(ResourcesChooserDialog.class, "chooseScreens.dialog.label"));
        this.avList = new org.eclipse.swt.widgets.List(area, 2818);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.avList.setLayoutData((Object)data);
        this.avList.addSelectionListener((SelectionListener)new ProjectSelectionListener());
        this.fillUIList();
        return area;
    }

    private void fillUIList() {
        ArrayList<String> names = new ArrayList<String>();
        for (IResource res : this.allResources) {
            String resName = res.getName();
            resName = Utils.removeExtension((String)resName);
            resName = resName.substring(resName.indexOf("-") + 1, resName.length());
            names.add(resName);
            this.avList.setData(resName, (Object)res);
        }
        Object[] nameRes = names.toArray(new String[0]);
        Arrays.sort(nameRes);
        this.avList.setItems((String[])nameRes);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.select = this.createButton(parent, 0, SELECT_LABEL, true);
        String[] selPrjNameList = this.avList.getSelection();
        if (selPrjNameList != null && selPrjNameList.length > 0) {
            this.selResourceList = new ArrayList<IResource>();
            int i = 0;
            while (i < selPrjNameList.length) {
                this.selResourceList.add((IResource)this.avList.getData(selPrjNameList[i]));
                ++i;
            }
            this.select.setEnabled(true);
        } else {
            this.select.setEnabled(false);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public List<IResource> getSelResourceList() {
        return this.selResourceList;
    }

    class ProjectSelectionListener
    extends SelectionAdapter {
        ProjectSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String[] selPrjNameList = ((org.eclipse.swt.widgets.List)e.getSource()).getSelection();
            if (selPrjNameList != null && selPrjNameList.length > 0) {
                ResourcesChooserDialog.this.selResourceList = new ArrayList<IResource>();
                int i = 0;
                while (i < selPrjNameList.length) {
                    ResourcesChooserDialog.this.selResourceList.add((IResource)ResourcesChooserDialog.this.avList.getData(selPrjNameList[i]));
                    ++i;
                }
                ResourcesChooserDialog.this.select.setEnabled(true);
            }
        }
    }
}

