/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.mouseHook;

import com.ez.workspace.analysis.graph.job.GraphEditor;
import com.ez.workspace.analysis.graph.mouseHook.WUMouseActionsHookAdapter;
import com.ez.workspace.ui.Activator;
import com.ez.workspace.ui.internal.Messages;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphMouseActionsHookAdapter
extends WUMouseActionsHookAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GraphMouseActionsHookAdapter.class);
    public final String HIDE_INCOMING = Messages.getString(GraphMouseActionsHookAdapter.class, "hide.incoming.button");
    public final String UNHIDE_INCOMING = Messages.getString(GraphMouseActionsHookAdapter.class, "unhide.incoming.button");
    public final String HIDE_OUTGOING = Messages.getString(GraphMouseActionsHookAdapter.class, "hide.outgoing.button");
    public final String UNHIDE_OUTGOING = Messages.getString(GraphMouseActionsHookAdapter.class, "unhide.outgoing.button");
    public final String HIDE_FORWARD_PATH = Messages.getString(GraphMouseActionsHookAdapter.class, "hideForward.outgoing.button");
    public final String SHOW_FORWARD_PATH = Messages.getString(GraphMouseActionsHookAdapter.class, "showForward.outgoing.button");
    public final String HIDE_BACKWARD_PATH = Messages.getString(GraphMouseActionsHookAdapter.class, "hideBAckward.outgoing.button");
    public final String SHOW_BACKWARD_PATH = Messages.getString(GraphMouseActionsHookAdapter.class, "showBackward.outgoing.button");
    public final String SHOW_FORWARD_PATH_HIDE_UNCONNECTED = Messages.getString(GraphMouseActionsHookAdapter.class, "showForward.hideUnconnected.button");
    public final String SHOW_BACKWARD_PATH_HIDE_UNCONNECTED = Messages.getString(GraphMouseActionsHookAdapter.class, "showBackward.hideUnconnected.button");
    public final String FILTER_LBL = Messages.getString(GraphMouseActionsHookAdapter.class, "filter.lbl");
    private WUMouseActionsHookAdapter.NodeAction hideIncoming = null;
    private WUMouseActionsHookAdapter.NodeAction unhideIncoming = null;
    private WUMouseActionsHookAdapter.NodeAction hideOutgoing = null;
    private WUMouseActionsHookAdapter.NodeAction unhideOutgoing = null;
    private WUMouseActionsHookAdapter.NodeAction hideForwardPath = null;
    private WUMouseActionsHookAdapter.NodeAction showForwardPath = null;
    private WUMouseActionsHookAdapter.NodeAction showForwardPathHideUnconnected = null;
    private WUMouseActionsHookAdapter.NodeAction hideBackwardPath = null;
    private WUMouseActionsHookAdapter.NodeAction showBackwardPath = null;
    private WUMouseActionsHookAdapter.NodeAction showBackwardPathHideUnconnected = null;

    @Override
    public List getRightClickContributions(TSENode tsNode) {
        List contextItems = super.getRightClickContributions(tsNode);
        contextItems.add(new Separator());
        if (tsNode != null && !tsNode.hasAttribute("attributte key for a tsnode without filtering actions")) {
            MenuManager subMenu = new MenuManager(this.FILTER_LBL);
            contextItems.add(subMenu);
            if (this.hideIncoming == null) {
                this.hideIncoming = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "hideEdges.task.text"), -1);
                        GraphEditor.hideIncomingEdges(this.node, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo);
                        GraphMouseActionsHookAdapter.this.hideIncoming.setEnabled(GraphEditor.getINActionState(this.node, 0, GraphMouseActionsHookAdapter.this.graphManager));
                        monitor.done();
                    }
                };
            }
            this.hideIncoming.setText(this.HIDE_INCOMING);
            this.hideIncoming.setNode(tsNode);
            this.hideIncoming.setImageDescriptor(Activator.getImageDescriptor("icons/hideIncoming.gif"));
            this.hideIncoming.setEnabled(GraphEditor.getINActionState(tsNode, 0, this.graphManager));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.hideIncoming));
            if (this.unhideIncoming == null) {
                this.unhideIncoming = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "unhideEdges.task.text"), -1);
                        GraphEditor.unhideIncomingEdges(this.node, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo);
                        GraphMouseActionsHookAdapter.this.unhideIncoming.setEnabled(GraphEditor.getINActionState(this.node, 1, GraphMouseActionsHookAdapter.this.graphManager));
                        monitor.done();
                    }
                };
            }
            this.unhideIncoming.setText(this.UNHIDE_INCOMING);
            this.unhideIncoming.setNode(tsNode);
            this.unhideIncoming.setImageDescriptor(Activator.getImageDescriptor("icons/showIncoming.gif"));
            this.unhideIncoming.setEnabled(GraphEditor.getINActionState(tsNode, 1, this.graphManager));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.unhideIncoming));
            subMenu.add((IContributionItem)new Separator());
            if (this.hideOutgoing == null) {
                this.hideOutgoing = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "hideEdges.task.text"), -1);
                        GraphEditor.hideOutgoingEdges(this.node, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo);
                        GraphMouseActionsHookAdapter.this.hideOutgoing.setEnabled(GraphEditor.getOUTActionState(this.node, 0, GraphMouseActionsHookAdapter.this.graphManager));
                        monitor.done();
                    }
                };
            }
            this.hideOutgoing.setText(this.HIDE_OUTGOING);
            this.hideOutgoing.setNode(tsNode);
            this.hideOutgoing.setImageDescriptor(Activator.getImageDescriptor("icons/hideOutgoing.gif"));
            this.hideOutgoing.setEnabled(GraphEditor.getOUTActionState(tsNode, 0, this.graphManager));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.hideOutgoing));
            if (this.unhideOutgoing == null) {
                this.unhideOutgoing = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "unhideEdges.task.text"), -1);
                        GraphEditor.unhideOutgoingEdges(this.node, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo);
                        GraphMouseActionsHookAdapter.this.unhideOutgoing.setEnabled(GraphEditor.getOUTActionState(this.node, 1, GraphMouseActionsHookAdapter.this.graphManager));
                        monitor.done();
                    }
                };
            }
            this.unhideOutgoing.setText(this.UNHIDE_OUTGOING);
            this.unhideOutgoing.setNode(tsNode);
            this.unhideOutgoing.setImageDescriptor(Activator.getImageDescriptor("icons/showOutgoing.gif"));
            this.unhideOutgoing.setEnabled(GraphEditor.getOUTActionState(tsNode, 1, this.graphManager));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.unhideOutgoing));
            subMenu.add((IContributionItem)new Separator());
            if (this.hideForwardPath == null) {
                this.hideForwardPath = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "hideEdges.task.text"), -1);
                        GraphEditor.hideForwardPath(this.node, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo);
                        monitor.done();
                    }
                };
            }
            this.hideForwardPath.setText(this.HIDE_FORWARD_PATH);
            this.hideForwardPath.setNode(tsNode);
            this.hideForwardPath.setEnabled(GraphEditor.getFORWARDActionState(tsNode, this.graphManager));
            this.hideForwardPath.setImageDescriptor(Activator.getImageDescriptor("icons/hideForward.gif"));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.hideForwardPath));
            if (this.showForwardPath == null) {
                this.showForwardPath = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "unhideEdges.task.text"), -1);
                        GraphEditor.showForwardPath(this.node, false, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo, GraphMouseActionsHookAdapter.this.graphModel);
                        monitor.done();
                    }
                };
            }
            this.showForwardPath.setText(this.SHOW_FORWARD_PATH);
            this.showForwardPath.setNode(tsNode);
            this.showForwardPath.setEnabled(GraphEditor.getFORWARDActionState(tsNode, this.graphManager));
            this.showForwardPath.setImageDescriptor(Activator.getImageDescriptor("icons/showForward.gif"));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.showForwardPath));
            if (this.showForwardPathHideUnconnected == null) {
                this.showForwardPathHideUnconnected = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "unhideEdges.task.text"), -1);
                        GraphEditor.showForwardPathAndHideOtherNodes(this.node, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo, GraphMouseActionsHookAdapter.this.graphModel);
                        monitor.done();
                    }
                };
            }
            this.showForwardPathHideUnconnected.setText(this.SHOW_FORWARD_PATH_HIDE_UNCONNECTED);
            this.showForwardPathHideUnconnected.setNode(tsNode);
            this.showForwardPathHideUnconnected.setEnabled(GraphEditor.getFORWARDActionState(tsNode, this.graphManager));
            this.showForwardPathHideUnconnected.setImageDescriptor(Activator.getImageDescriptor("icons/showForwardHideUncon.gif"));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.showForwardPathHideUnconnected));
            subMenu.add((IContributionItem)new Separator());
            if (this.hideBackwardPath == null) {
                this.hideBackwardPath = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "hideEdges.task.text"), -1);
                        GraphEditor.hideBackwardPath(this.node, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo);
                        monitor.done();
                    }
                };
            }
            this.hideBackwardPath.setText(this.HIDE_BACKWARD_PATH);
            this.hideBackwardPath.setNode(tsNode);
            this.hideBackwardPath.setEnabled(GraphEditor.getBACKWARDActionState(tsNode, this.graphManager));
            this.hideBackwardPath.setImageDescriptor(Activator.getImageDescriptor("icons/hideBackwards.gif"));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.hideBackwardPath));
            if (this.showBackwardPath == null) {
                this.showBackwardPath = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "unhideEdges.task.text"), -1);
                        GraphEditor.showBackwardPath(this.node, false, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo, GraphMouseActionsHookAdapter.this.graphModel);
                        monitor.done();
                    }
                };
            }
            this.showBackwardPath.setText(this.SHOW_BACKWARD_PATH);
            this.showBackwardPath.setNode(tsNode);
            this.showBackwardPath.setEnabled(GraphEditor.getBACKWARDActionState(tsNode, this.graphManager));
            this.showBackwardPath.setImageDescriptor(Activator.getImageDescriptor("icons/showBackward.gif"));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.showBackwardPath));
            if (this.showBackwardPathHideUnconnected == null) {
                this.showBackwardPathHideUnconnected = new WUMouseActionsHookAdapter.NodeAction(this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(GraphMouseActionsHookAdapter.class, "unhideEdges.task.text"), -1);
                        GraphEditor.showBackwardPathAndHideOtherNodes(this.node, GraphMouseActionsHookAdapter.this.graphManager, GraphMouseActionsHookAdapter.this.canvas, GraphMouseActionsHookAdapter.this.graphInfo, GraphMouseActionsHookAdapter.this.graphModel);
                        monitor.done();
                    }
                };
            }
            this.showBackwardPathHideUnconnected.setText(this.SHOW_BACKWARD_PATH_HIDE_UNCONNECTED);
            this.showBackwardPathHideUnconnected.setNode(tsNode);
            this.showBackwardPathHideUnconnected.setEnabled(GraphEditor.getBACKWARDActionState(tsNode, this.graphManager));
            this.showBackwardPathHideUnconnected.setImageDescriptor(Activator.getImageDescriptor("icons/showBackwardHideUncon.gif"));
            subMenu.add((IContributionItem)new ActionContributionItem((IAction)this.showBackwardPathHideUnconnected));
        }
        return contextItems;
    }

    public boolean contribute(TSENode node) {
        return false;
    }

    @Override
    public void dispose() {
        if (this.hideBackwardPath != null) {
            this.hideBackwardPath.dispose();
            this.hideBackwardPath = null;
        }
        if (this.hideForwardPath != null) {
            this.hideForwardPath.dispose();
            this.hideForwardPath = null;
        }
        if (this.hideIncoming != null) {
            this.hideIncoming.dispose();
            this.hideIncoming = null;
        }
        if (this.hideOutgoing != null) {
            this.hideOutgoing.dispose();
            this.hideOutgoing = null;
        }
        if (this.showBackwardPath != null) {
            this.showBackwardPath.dispose();
            this.showBackwardPath = null;
        }
        if (this.showBackwardPathHideUnconnected != null) {
            this.showBackwardPathHideUnconnected.dispose();
            this.showBackwardPathHideUnconnected = null;
        }
        if (this.showForwardPath != null) {
            this.showForwardPath.dispose();
            this.showForwardPath = null;
        }
        if (this.showForwardPathHideUnconnected != null) {
            this.showForwardPathHideUnconnected.dispose();
            this.showForwardPathHideUnconnected = null;
        }
        if (this.unhideIncoming != null) {
            this.unhideIncoming.dispose();
            this.unhideIncoming = null;
        }
        if (this.unhideOutgoing != null) {
            this.unhideOutgoing.dispose();
            this.unhideOutgoing = null;
        }
        super.dispose();
    }
}

