/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.mouseHook;

import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.tomsawyer.drawing.geometry.shared.TSConstPoint;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.TSEHitTesting;
import com.tomsawyer.interactive.events.shared.TSMouseEvent;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.interactive.swing.tool.TSEWindowInputTool;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZMouseTool
extends TSEWindowInputTool {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EZMouseTool.class);
    private MenuManager contextManager = null;
    private List contextItems = null;
    private MouseActionsHook hook = null;

    public EZMouseTool(MouseActionsHook hook) {
        this.hook = hook;
        this.createContextMenu();
    }

    private void showView(final String viewId) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                try {
                    window.getActivePage().showView(viewId);
                }
                catch (PartInitException e) {
                    L.error("while activating view: {}", (Object)viewId, (Object)e);
                }
            }
        });
    }

    public void onMouseClicked(TSMouseEvent mouseevent) {
        this.showView("com.ez.analysis.display.view.GraphsView");
        L.debug("mouse clicked {}", (Object)this);
        TSSwingCanvas canvas = this.getSwingCanvas();
        TSEHitTesting hitTesting = canvas.getHitTesting();
        TSConstPoint point = this.getNonalignedWorldPoint(mouseevent);
        TSENode node = hitTesting.getNodeAt(point, this.getGraph(), true);
        if (node != null) {
            this.makeActionOnNode(mouseevent, node);
        } else {
            TSEEdge edge = hitTesting.getEdgeAt(point, this.getGraph(), true);
            if (edge != null) {
                L.trace("edge clicked: {}", (Object)edge);
                if (!mouseevent.isRightMouseButton()) {
                    Action action;
                    if (mouseevent.getClickCount() >= 2) {
                        Action action2 = this.hook.getDoubleClickAction(edge);
                        if (action2 != null) {
                            action2.run();
                        }
                    } else if (mouseevent.getClickCount() == 1 && (action = this.hook.getClickSelection(edge, null)) != null) {
                        action.run();
                    }
                }
                if (mouseevent.isRightMouseButton()) {
                    this.contextItems = this.hook.getRightClickContributions(edge, null);
                    if (this.contextItems != null && this.contextItems.size() > 0) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Display display = Display.getDefault();
                                Shell shell = display.getActiveShell();
                                if (shell == null) {
                                    L.error("MouseTool : active shell is null");
                                    return;
                                }
                                Menu menu = EZMouseTool.this.contextManager.createContextMenu((Control)shell);
                                shell.setMenu(menu);
                                menu.setVisible(true);
                            }
                        });
                    }
                }
            } else {
                node = hitTesting.getExpandedNodeAt(point, this.getGraph(), true);
                if (node != null) {
                    L.debug("mouse clicked in an expanded node {}", (Object)this);
                    this.makeActionOnNode(mouseevent, node);
                } else {
                    L.trace("none of an edge or a node clicked");
                    if (!mouseevent.isRightMouseButton()) {
                        Action action;
                        if (mouseevent.getClickCount() >= 2) {
                            Action action3 = this.hook.getDoubleClickAction();
                            if (action3 != null) {
                                action3.run();
                            }
                        } else if (mouseevent.getClickCount() == 1 && (action = this.hook.getClickSelection()) != null) {
                            action.run();
                        }
                    }
                    if (mouseevent.isRightMouseButton()) {
                        this.makeRightClickMenu();
                    }
                }
            }
        }
    }

    public void makeRightClickMenu() {
        this.contextItems = this.hook.getRightClickContributions();
        if (this.contextItems != null && this.contextItems.size() > 0) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Display display = Display.getDefault();
                    Shell shell = display.getActiveShell();
                    if (shell == null) {
                        L.error("MouseTool : active shell is null");
                        return;
                    }
                    Menu menu = EZMouseTool.this.contextManager.createContextMenu((Control)shell);
                    shell.setMenu(menu);
                    menu.setVisible(true);
                }
            });
        }
    }

    private void makeActionOnNode(TSMouseEvent mouseevent, TSENode node) {
        L.trace("mouse clicked: {}", (Object)node);
        if (!mouseevent.isRightMouseButton()) {
            Action action;
            if (mouseevent.getClickCount() >= 2) {
                Action action2 = this.hook.getDoubleClickAction(node);
                if (action2 != null) {
                    action2.run();
                }
            } else if (mouseevent.getClickCount() == 1 && (action = this.hook.getClickSelection(node)) != null) {
                action.run();
            }
        }
        if (mouseevent.isRightMouseButton()) {
            this.contextItems = this.hook.getRightClickContributions(node);
            if (this.contextItems != null && this.contextItems.size() > 0) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = Display.getDefault();
                        Shell shell = display.getActiveShell();
                        if (shell == null) {
                            L.error("MouseTool : active shell is null");
                            return;
                        }
                        Menu menu = EZMouseTool.this.contextManager.createContextMenu((Control)shell);
                        shell.setMenu(menu);
                        menu.setVisible(true);
                    }
                });
            }
        }
    }

    public void createContextMenu() {
        this.contextManager = new MenuManager();
        this.contextManager.setRemoveAllWhenShown(true);
        this.contextManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                L.debug("menuAboutToShow!!!!!!!!");
                EZMouseTool.this.fillVariableContextMenu(mgr);
            }
        });
    }

    private void fillVariableContextMenu(IMenuManager mgr) {
        if (this.contextItems != null) {
            for (Object objItem : this.contextItems) {
                ContributionItem item;
                if (objItem instanceof ContributionItem) {
                    item = (ContributionItem)objItem;
                    mgr.add((IContributionItem)item);
                    continue;
                }
                if (!(objItem instanceof IContributionItem)) continue;
                item = (IContributionItem)objItem;
                mgr.add((IContributionItem)item);
            }
        }
    }

    public void clean() {
        if (this.contextManager != null) {
            this.contextManager.dispose();
            this.contextManager = null;
        }
        this.contextItems = null;
        this.hook = null;
    }
}

