/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.mouseHook;

import com.ez.workspace.model.CategoryManager;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;

public class AnalysisContributorComparator
implements Comparator<IContributionItem> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Map<IContributionItem, Integer> toOrder = null;

    public AnalysisContributorComparator(Map<IContributionItem, Integer> toOrder) {
        this.toOrder = toOrder;
        Assert.isNotNull(toOrder, (String)"analysis list must not be null!");
    }

    @Override
    public int compare(IContributionItem o1, IContributionItem o2) {
        int idx1 = this.toOrder.get(o1);
        int idx2 = this.toOrder.get(o2);
        int ret = 0;
        if (idx1 < idx2) {
            ret = -1;
        } else if (idx1 > idx2) {
            ret = 1;
        } else {
            String name1 = null;
            String name2 = null;
            if (o1 instanceof ActionContributionItem && o2 instanceof ActionContributionItem) {
                name1 = ((ActionContributionItem)o1).getAction().getText();
                name2 = ((ActionContributionItem)o2).getAction().getText();
            } else if (o1 instanceof MenuManager && o2 instanceof MenuManager) {
                name1 = ((MenuManager)o1).getMenuText();
                name2 = ((MenuManager)o2).getMenuText();
            }
            if (name1 != null && name2 != null) {
                if (CategoryManager.FAVOURITE_NAME.equals(name1)) {
                    return -1;
                }
                if (CategoryManager.FAVOURITE_NAME.equals(name2)) {
                    return 1;
                }
                ret = name1.compareTo(name2);
            }
        }
        return ret;
    }
}

