/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.model;

import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import java.util.ArrayList;
import java.util.List;

public class InventoryPathUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String SELECTED_EDGES_PATH = "SELECTED_TS_EDGES_PATH";
    public static final String PATHID = "PATH_ID";
    public static final String NODES_PATH = "PATH_TS_NODES";
    public static final String PATH_PREFIX = "path_prefix";

    public static void markPath(TSGraphMember member) {
        TSEGraph graph = (TSEGraph)member.getOwnerGraph();
        TSEGraphManager graphManager = (TSEGraphManager)graph.getOwnerGraphManager();
        InventoryPathUtils.unmarkOldPath(graphManager);
        List tsnodes = (List)member.getAttributeValue(NODES_PATH);
        Integer pathid = (Integer)member.getAttributeValue(PATHID);
        InventoryPathUtils.markNewPath(graphManager, tsnodes, pathid);
        member.removeAttribute(PATHID);
    }

    public static void markNewPath(TSEGraphManager graphManager, List<TSENode> tsnodes, Integer pathid) {
        ArrayList<TSEdge> edgesList = new ArrayList<TSEdge>();
        int i = 0;
        while (i < tsnodes.size() - 1) {
            TSEdge edge = graphManager.getMainDisplayGraph().getEdge((TSNode)tsnodes.get(i), (TSNode)tsnodes.get(i + 1));
            if (edge != null) {
                edgesList.add(edge);
                edge.setAttribute("Color", (Object)TSEColor.red);
            }
            ++i;
        }
        TSSwingCanvas canvas = (TSSwingCanvas)graphManager.getCurrentCanvas();
        canvas.addInvalidRegion(edgesList);
        canvas.updateInvalidRegion(true);
        graphManager.setAttribute(SELECTED_EDGES_PATH, edgesList);
        graphManager.setAttribute(PATHID, (Object)pathid);
    }

    public static void unmarkOldPath(TSEGraphManager graphManager) {
        List oldEdgesList = (List)graphManager.getAttributeValue(SELECTED_EDGES_PATH);
        TSSwingCanvas canvas = (TSSwingCanvas)graphManager.getCurrentCanvas();
        if (oldEdgesList != null) {
            for (TSEdge e : oldEdgesList) {
                e.setAttribute("Color", (Object)TSEColor.black);
            }
            canvas.addInvalidRegion(oldEdgesList);
            canvas.updateInvalidRegion(true);
        }
    }
}

