/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.model;

import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.model.StructureContentProviderAdapter;
import com.ez.workspace.change.DirtyStatus;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphInfoAdapter
implements GraphInfo {
    private static final Logger L = LoggerFactory.getLogger(GraphInfoAdapter.class);
    protected EZEntityID id;
    protected MenuManager contextManager;
    protected List menuItems;
    protected List toolBarItems;
    protected ContentViewer viewer;
    protected CloseHook closeHook;
    protected TSEOverviewComponent overviewComponent;
    protected Image image;
    protected String text;
    protected DirtyStatus isDirty;
    protected Component canvas;
    protected Set<StructureContentProvider> contentProviders;
    protected Map globalActions = null;

    public GraphInfoAdapter(EZEntityID id) {
        this.id = id;
    }

    public CloseHook getCloseHook() {
        return this.closeHook;
    }

    public MenuManager getContextManager() {
        return this.contextManager;
    }

    public Composite getControl() {
        return null;
    }

    public EZEntityID getID() {
        return this.id;
    }

    public abstract Image getImage();

    public List getMenuItems() {
        return this.menuItems;
    }

    public Object getOverviewComponent() {
        return this.overviewComponent;
    }

    public String getText() {
        return this.text;
    }

    public String getText(boolean truncate) {
        return this.getText();
    }

    public String getTooltip() {
        return null;
    }

    public List getToolBarItems() {
        return this.toolBarItems;
    }

    public ContentViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(ContentViewer viewer) {
        this.viewer = viewer;
    }

    public void setCloseHook(CloseHook closeHook) {
        this.closeHook = closeHook;
    }

    public void setToolBarItems(List toolBarItems) {
        this.toolBarItems = toolBarItems;
    }

    public void setMenuItems(List menuItems) {
        this.menuItems = menuItems;
    }

    public void setOverviewComponent(TSEOverviewComponent overviewComponent) {
        this.overviewComponent = overviewComponent;
    }

    public DirtyStatus getDirty() {
        return this.isDirty;
    }

    @Override
    public Set<StructureContentProvider> getContentProviders() {
        return this.contentProviders;
    }

    public void setDirty(DirtyStatus isDirty) {
        this.isDirty = isDirty;
    }

    public boolean hasLinkWithEditor() {
        return false;
    }

    public Component getCanvasComponent() {
        return this.canvas;
    }

    public void setCanvasComponent(Component canvas) {
        this.canvas = canvas;
    }

    public void setContentProviders(Set<StructureContentProvider> contentProviders) {
        this.contentProviders = contentProviders;
    }

    public void setContentProvider(StructureContentProvider contentProvider) {
        if (this.contentProviders == null) {
            this.contentProviders = new HashSet<StructureContentProvider>();
        } else {
            L.info("previous content providers were clean");
            this.contentProviders.clear();
        }
        this.contentProviders.add(contentProvider);
    }

    public Map getGlobalActionsContributions() {
        return this.globalActions;
    }

    public void setGlobalActionsContributions(Map globalActions) {
        this.globalActions = globalActions;
    }

    public ComponentBuilderInterface getLegendControl() {
        return null;
    }

    public boolean hasLegend() {
        return false;
    }

    public void dispose() {
        this.canvas = null;
        this.closeHook = null;
        if (this.contextManager != null) {
            this.contextManager.dispose();
            this.contextManager = null;
        }
        if (this.globalActions != null) {
            this.globalActions.clear();
            this.globalActions = null;
        }
        if (this.contentProviders != null) {
            for (StructureContentProviderAdapter structureContentProviderAdapter : this.contentProviders) {
                structureContentProviderAdapter.clean();
                structureContentProviderAdapter.dispose();
            }
            this.contentProviders = null;
        }
        if (this.menuItems != null) {
            this.menuItems.clear();
            this.menuItems = null;
        }
        if (this.toolBarItems != null) {
            this.toolBarItems.clear();
            this.toolBarItems = null;
        }
        this.overviewComponent = null;
        this.disposeImage();
        this.image = null;
        this.id = null;
        this.viewer = null;
        this.text = null;
    }

    public void disposeImage() {
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public void setContentProviderInputTree(Map map) {
        if (this.contentProviders != null) {
            for (StructureContentProvider provider : this.contentProviders) {
                provider.setInputTree(map);
            }
        }
    }

    @Override
    public GraphFilterInfo getGraphFilterInfo() {
        return null;
    }

    public void setGraphFilterInfo(GraphFilterInfo gfi) {
    }

    public boolean checkResourcesInAnalsysis(List<IResource> resources, DirtyStatus status) {
        return false;
    }

    public void close() {
    }

    public boolean wasClosed() {
        return false;
    }

    @Override
    public void updateInfoAdapter(GraphInfo cpy) {
    }

    public boolean isLegendAvailable() {
        boolean vb = true;
        if (this.getGraphFilterInfo() != null) {
            vb = this.getGraphFilterInfo().isInitialized();
        }
        return vb;
    }

    public boolean isReport() {
        return false;
    }
}

