/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.model;

import com.ez.internal.utils.Pair;
import com.ez.workspace.analysis.graph.EZNodeHidingManager;
import com.ez.workspace.analysis.graph.model.FilterChangedListener;
import com.ez.workspace.analysis.graph.model.GraphFilter;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.ez.workspace.ui.internal.Messages;
import com.ez.workspace.utils.WorkspaceLogUtil;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.complexity.TSEHidingManager;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphFilterInfo {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GraphFilterInfo.class);
    private boolean useMetaEdges = false;
    private Map<Class, GraphFilter> filterRegistry = null;
    private Map<Class, Boolean> filterSelection = null;
    private Map<Integer, List<Class>> levels = null;
    private FilterChangedListener filterChangedListener;
    List<TSEEdge> filterMetaEdges = new ArrayList<TSEEdge>();
    protected boolean isInitialized = false;

    public List<GraphFilter> getFilters() {
        return this.filterRegistry == null ? null : new ArrayList<GraphFilter>(this.filterRegistry.values());
    }

    public Map<Integer, List<Class>> getLevels() {
        return this.levels;
    }

    public void registerFilterType(Class type) {
        if (this.filterRegistry == null) {
            this.filterRegistry = new HashMap<Class, GraphFilter>();
            this.filterSelection = new HashMap<Class, Boolean>();
            this.levels = new HashMap<Integer, List<Class>>();
            this.isInitialized = true;
        }
        if (!this.filterRegistry.containsKey(type)) {
            GraphFilter gf = new GraphFilter();
            gf.type = type;
            this.filterRegistry.put(type, gf);
            this.filterSelection.put(type, true);
            this.addToLevel(0, type);
        }
    }

    public void registerFilterType(Class type, Image image, String text) {
        if (this.filterRegistry == null) {
            this.filterRegistry = new HashMap<Class, GraphFilter>();
            this.filterSelection = new HashMap<Class, Boolean>();
            this.levels = new HashMap<Integer, List<Class>>();
            this.isInitialized = true;
        }
        if (!this.filterRegistry.containsKey(type)) {
            GraphFilter gf = new GraphFilter();
            gf.type = type;
            gf.image = image;
            gf.text = text;
            this.filterRegistry.put(type, gf);
            this.filterSelection.put(type, true);
            this.addToLevel(0, type);
        }
    }

    public void registerFilterType(Class type, boolean selection) {
        if (this.filterSelection != null) {
            this.filterSelection.put(type, selection);
        }
    }

    public void clearFilters(TSEGraph graph) {
        if (this.filterSelection != null) {
            this.removeMeta(graph);
            for (Class type : this.filterSelection.keySet()) {
                boolean isSelected;
                boolean bl = isSelected = this.filterSelection.get(type) == false;
                if (!isSelected) continue;
                this.filterSelection.put(type, true);
            }
        }
    }

    public void setUseMetaEdges(boolean useMetaEdges) {
        this.useMetaEdges = useMetaEdges;
        if (this.filterChangedListener != null) {
            this.filterChangedListener.filterChanged(this.filterSelection);
        }
    }

    public boolean isUsingMetaEdges() {
        boolean useMetaEdges;
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        this.useMetaEdges = useMetaEdges = store.getBoolean("indirectLinksPreference");
        return useMetaEdges;
    }

    public void addToLevel(int i, Class type) {
        this.removeFromLevel(0, type);
        List<Class> levelTypes = this.levels.get(i);
        if (levelTypes != null) {
            levelTypes.add(type);
        }
    }

    public void removeFromLevel(int i, Class type) {
        List<Class> levelTypes = this.levels.get(i);
        if (levelTypes != null) {
            levelTypes.remove(type);
        }
    }

    public void selectionChanged(GraphFilter gf, boolean selection) {
        this.filterSelection.put(gf.type, selection);
        if (this.filterChangedListener != null) {
            HashMap<Class, Boolean> selected = new HashMap<Class, Boolean>();
            selected.put(gf.type, selection);
            this.filterChangedListener.filterChanged(selected);
        }
    }

    public boolean getSelection(GraphFilter gf) {
        if (!this.filterSelection.containsKey(gf.type)) {
            WorkspaceLogUtil.err((String)Messages.getString(GraphFilterInfo.class, "err.msg", new String[]{gf.type.getName()}), null);
            return false;
        }
        return this.filterSelection.get(gf.type);
    }

    public void setFilterChangedListener(FilterChangedListener filterChangedListener) {
        this.filterChangedListener = filterChangedListener;
    }

    public void initFilters(final TSEGraphManager graphManager, final TSEGraph graph, final TSSwingCanvas canvas, final TSEOverviewComponent overviewComp, final Collection<TSGraphMember> grMembers) {
        this.setFilterChangedListener(new FilterChangedListener(){

            @Override
            public void filterChanged(final Map<Class, Boolean> status) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.getString(GraphFilterInfo.class, "filters.task.text"), -1);
                        if (!grMembers.isEmpty()) {
                            GraphFilterInfo.this.filterGraphMembers(monitor, graphManager, graph, canvas, status, grMembers);
                        }
                        if (overviewComp != null) {
                            overviewComp.updateOverview();
                        }
                        monitor.done();
                    }
                };
                ProgressDialogWithoutCancelBtn pmd = new ProgressDialogWithoutCancelBtn(Display.getCurrent().getActiveShell());
                try {
                    pmd.run(true, true, op);
                }
                catch (InvocationTargetException e) {
                    L.error("run with progress filterNodes()", (Throwable)e);
                }
                catch (InterruptedException e) {
                    L.error("run with progress filterNodes()", (Throwable)e);
                }
            }
        });
    }

    private void filterGraphMembers(IProgressMonitor monitor, TSEGraphManager graphManager, TSEGraph graph, TSSwingCanvas canvas, Map<Class, Boolean> status, Collection<TSGraphMember> membersToFilter) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        ArrayList<TSENode> nodesToHide = new ArrayList<TSENode>();
        ArrayList<TSENode> nodesToShow = new ArrayList<TSENode>();
        ArrayList<TSEEdge> edgesToHide = new ArrayList<TSEEdge>();
        ArrayList<TSEEdge> edgesToShow = new ArrayList<TSEEdge>();
        for (TSGraphMember tsMember : membersToFilter) {
            Class clazz = (Class)tsMember.getAttributeValue("class_name");
            L.debug("{}", (Object)clazz);
            Boolean show = status.get(clazz);
            if (tsMember == null || show == null) continue;
            if (show.booleanValue()) {
                if (tsMember instanceof TSENode) {
                    nodesToShow.add((TSENode)tsMember);
                    List edgesListToShow = ((TSENode)tsMember).disconnectedEdges();
                    edgesToShow.addAll(edgesListToShow);
                    continue;
                }
                edgesToShow.add((TSEEdge)tsMember);
                continue;
            }
            if (tsMember instanceof TSENode) {
                nodesToHide.add((TSENode)tsMember);
                List edgesListToHide = ((TSENode)tsMember).buildInAndOutEdges();
                edgesToHide.addAll(edgesListToHide);
                continue;
            }
            edgesToHide.add((TSEEdge)tsMember);
        }
        hidingManager.startEventGroup();
        hidingManager.unhide(nodesToShow, edgesToShow, true);
        this.removeMeta(graph);
        if (this.isUsingMetaEdges()) {
            this.showFilterMetaedges(graph, nodesToHide, this.filterMetaEdges);
        }
        Iterator iterator = edgesToHide.iterator();
        while (iterator.hasNext()) {
            if (!((TSEEdge)iterator.next()).isDiscarded()) continue;
            iterator.remove();
        }
        if (!nodesToHide.isEmpty() || !edgesToHide.isEmpty()) {
            hidingManager.hide(nodesToHide, edgesToHide);
        }
        hidingManager.endEventGroup();
        ArrayList<Object> all = new ArrayList<Object>();
        all.addAll(nodesToShow);
        all.addAll(nodesToHide);
        all.addAll(edgesToShow);
        all.addAll(edgesToHide);
        canvas.addInvalidRegion(all);
        canvas.updateInvalidRegion(true);
    }

    private void removeMeta(TSEGraph graph) {
        if (graph != null) {
            try {
                for (TSEEdge e : this.filterMetaEdges) {
                    if (e == null) {
                        L.debug("null");
                        continue;
                    }
                    if (!e.isOwned()) {
                        L.debug("isOwned");
                        continue;
                    }
                    if (e.getOwner() != graph) {
                        L.debug("owner (probably hidden)");
                        continue;
                    }
                    if (e.getSourceNode() == null) {
                        L.debug("source null");
                        continue;
                    }
                    if (e.getTargetNode() == null) {
                        L.debug("source null");
                        continue;
                    }
                    graph.discard((TSEdge)e);
                }
            }
            catch (Throwable t) {
                L.error("error at removing metaEdges", t);
            }
        }
        this.filterMetaEdges.clear();
    }

    private void showFilterMetaedges(TSEGraph graph, List<TSENode> hiddenNodes, List<TSEEdge> filterMetaEdges) {
        LinkedList<TSENode> workNodes = new LinkedList<TSENode>();
        LinkedList<TSENode> processed = new LinkedList<TSENode>();
        workNodes.addAll(hiddenNodes);
        HashSet<Pair> metaPairs = new HashSet<Pair>();
        LinkedList<Pair> tempPairs = new LinkedList<Pair>();
        while (workNodes.size() > 0) {
            TSENode node = (TSENode)workNodes.remove(0);
            processed.add(node);
            List inEdges = node.inEdges();
            List outEdges = node.outEdges();
            LinkedList<TSENode> extSources = new LinkedList<TSENode>();
            LinkedList<TSENode> extTargets = new LinkedList<TSENode>();
            for (TSEEdge inEdge : inEdges) {
                TSENode sIn = (TSENode)inEdge.getSourceNode();
                if (processed.contains(sIn)) continue;
                extSources.add(sIn);
            }
            for (TSEEdge outEdge : outEdges) {
                TSENode tOut = (TSENode)outEdge.getTargetNode();
                if (processed.contains(tOut)) continue;
                extTargets.add(tOut);
            }
            tempPairs.addAll(metaPairs);
            for (Pair pair : tempPairs) {
                if (((TSENode)pair.getFirst()).equals(node)) {
                    extTargets.add((TSENode)pair.getSecond());
                    metaPairs.remove(pair);
                }
                if (!((TSENode)pair.getSecond()).equals(node)) continue;
                extSources.add((TSENode)pair.getFirst());
                metaPairs.remove(pair);
            }
            for (TSENode source : extSources) {
                for (TSENode target : extTargets) {
                    if (source.equals(target)) continue;
                    Pair pair = new Pair((Object)source, (Object)target);
                    metaPairs.add(pair);
                }
            }
        }
        L.debug("processing {} meta pairs", (Object)metaPairs.size());
        for (Pair pair : metaPairs) {
            TSENode source = (TSENode)pair.getFirst();
            TSENode target = (TSENode)pair.getSecond();
            if (hiddenNodes.contains(source) || hiddenNodes.contains(target)) continue;
            TSEEdge meta = (TSEEdge)graph.addEdge((TSNode)pair.getFirst(), (TSNode)pair.getSecond());
            meta.setAttribute("Color", (Object)TSEColor.red);
            filterMetaEdges.add(meta);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    class ProgressDialogWithoutCancelBtn
    extends ProgressMonitorDialog {
        public ProgressDialogWithoutCancelBtn(Shell parent) {
            super(parent);
        }

        protected void createButtonsForButtonBar(Composite parent) {
        }
    }
}

