/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.model;

import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.GraphModel;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphRestrictionsLegendInfo;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.ez.workspace.ui.internal.Messages;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.service.layout.TSHierarchicalLayoutInputTailor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class AbstractAnalysisGraphModel
implements GraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final int UI_TEXTBOX = 0;
    public static final int UI_SVG = 2;
    protected TSEGraphManager graphManager;
    protected TSEGraph graph;
    protected Map outForGISV = new HashMap();
    protected int uiStyle = 2;
    public static final String NODE_TYPES_SET_FOR_LEGEND_KEY = "node types set for legend";
    protected Set<IGraphNodeLegendInfo> nodeTypesSetForLegend = new HashSet<IGraphNodeLegendInfo>();
    public static final String EDGE_TYPES_SET_FOR_LEGEND_KEY = "edge types set for legend";
    protected Set<IGraphEdgeLegendInfo> edgeTypesSetForLegend = new HashSet<IGraphEdgeLegendInfo>();
    public static final String RESTRICTION_TYPES_SET_FOR_LEGEND_KEY = "restriction types set for legend";
    public static final String NO_RESULTS_NODE_LABEL = Messages.getString(AbstractAnalysisGraphModel.class, "noResults.node.label");
    protected Set<IGraphRestrictionsLegendInfo> restrictionTypesSetForLegend = new HashSet<IGraphRestrictionsLegendInfo>();

    @Override
    public TSEGraph getGraph() {
        return this.graph;
    }

    @Override
    public TSEGraphManager getGraphManager() {
        return this.graphManager;
    }

    @Override
    public TSEGraph loadGraph() {
        return null;
    }

    public void loadGraph(IProgressMonitor monitor) {
        this.initGraph();
    }

    @Override
    public void setGraph(TSEGraph graph) {
        this.graph = graph;
    }

    private void initGraph() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
    }

    public List<TSEGraph> getGraphs() {
        TSEGraph mainGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
        ArrayList<TSEGraph> graphsList = new ArrayList<TSEGraph>();
        graphsList.add(mainGraph);
        return graphsList;
    }

    public EZEntityID getFileEntity(TSNode gNode) {
        return null;
    }

    public EZObjectType getApplicableInputType(List<TSNode> nodelist) {
        return null;
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        return null;
    }

    public Set getResources(TSNode gNode) {
        return null;
    }

    @Override
    public Map getOutForStructView() {
        return this.outForGISV;
    }

    public void setUIStyle(int style) {
        this.uiStyle = style;
    }

    public int getUIStyle() {
        return this.uiStyle;
    }

    public void updateDrawing() {
    }

    public void setNodeUI(TSENode node) {
    }

    public static String resolveTooltip(String nodeTooltip) {
        if (nodeTooltip != null && nodeTooltip.startsWith("/")) {
            nodeTooltip = "." + nodeTooltip;
        }
        return nodeTooltip;
    }

    public void dispose() {
        this.graph = null;
        this.graphManager = null;
        this.outForGISV.clear();
        this.outForGISV = null;
        this.nodeTypesSetForLegend.clear();
        this.edgeTypesSetForLegend.clear();
        this.restrictionTypesSetForLegend.clear();
    }

    public void setOptions(TSHierarchicalLayoutInputTailor hit) {
    }

    public String getMsgForLayoutDecision() {
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        Integer limit = store.getInt("graphNodesExceed");
        if (this.getNumberOfResultNodes() < limit) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Object[] params = new Object[]{limit};
        sb.append(Messages.getString(AbstractAnalysisGraphModel.class, "exceeds.size.message", params));
        return sb.toString();
    }

    public int getNumberOfResultNodes() {
        TSEGraph mainGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
        int count = 0;
        if (this.graph != null) {
            count = mainGraph.numberOfNodes();
        }
        return count;
    }

    public Set getEdgeTypesForLegend() {
        return this.edgeTypesSetForLegend;
    }

    public Set getNodeTypesForLegend() {
        return this.nodeTypesSetForLegend;
    }

    public Set getRestrictionTypesForLegend() {
        return this.restrictionTypesSetForLegend;
    }
}

