/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.job;

import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mu.itf.RequestConstants;
import com.ez.protection.Registry;
import com.ez.workspace.analysis.graph.ExecExportStatus;
import com.ez.workspace.analysis.graph.gui.EZExportGraphDialog;
import com.ez.workspace.analysis.graph.gui.EZPrintPreviewWindow;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.analysis.job.GraphTranslateJob;
import com.ez.workspace.mu.client.commands.Command;
import com.ez.workspace.resources.InternalLoadResource;
import com.ez.workspace.ui.Activator;
import com.ez.workspace.ui.internal.Messages;
import com.tomsawyer.canvas.swing.TSBaseSwingCanvas;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.grid.TSGridPreferenceTailor;
import com.tomsawyer.interactive.animation.TSAnimationPreferenceTailor;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.TSCommandInterface;
import com.tomsawyer.interactive.command.TSCommandManager;
import com.tomsawyer.interactive.command.TSGroupCommand;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.interactive.swing.TSSwingCanvasPreferenceTailor;
import com.tomsawyer.interactive.swing.editing.tool.TSEMoveSelectedTool;
import com.tomsawyer.interactive.swing.editing.tool.TSEditingToolHelper;
import com.tomsawyer.interactive.swing.viewing.tool.TSEInteractiveZoomTool;
import com.tomsawyer.interactive.swing.viewing.tool.TSELinkNavigationTool;
import com.tomsawyer.interactive.swing.viewing.tool.TSEPanTool;
import com.tomsawyer.interactive.swing.viewing.tool.TSESelectRegionTool;
import com.tomsawyer.interactive.swing.viewing.tool.TSESelectTool;
import com.tomsawyer.interactive.swing.viewing.tool.TSEZoomTool;
import com.tomsawyer.interactive.swing.viewing.tool.TSViewingToolHelper;
import com.tomsawyer.interactive.tool.TSTool;
import com.tomsawyer.interactive.tool.TSToolManager;
import com.tomsawyer.interactive.viewing.tool.TSViewingToolPreferenceTailor;
import com.tomsawyer.util.preference.TSPreferenceData;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphTSJobAdapter
extends AbstractAnalysisJob
implements CloseHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GraphTSJobAdapter.class);
    private static final double SPACING_NODE = 10.0;
    public static final String PROCESS_CANCELED = Messages.getString(GraphTSJobAdapter.class, "process.canceled.text");
    public static final String PROCESS_GRAPH = Messages.getString(GraphTSJobAdapter.class, "load.graph.text");
    public static final String NOT_AVAILABLE_GRAPH = Messages.getString(GraphTSJobAdapter.class, "no.graph.text");
    public static final String REFRESH_CONTENT = Messages.getString(GraphTSJobAdapter.class, "refresh.text");
    public static final String RELOAD_CONTENT = Messages.getString(GraphTSJobAdapter.class, "reload.text");
    public static final String SELECT_TEXT = Messages.getString(GraphTSJobAdapter.class, "select.text");
    public static final String SELECT_TOOL = Messages.getString(GraphTSJobAdapter.class, "select.tooltip.text");
    public static final String PAN_TEXT = Messages.getString(GraphTSJobAdapter.class, "mousePan.text");
    public static final String PAN_TOOL = Messages.getString(GraphTSJobAdapter.class, "mousePan.tooltip.text");
    public static final String MZOOM_TEXT = Messages.getString(GraphTSJobAdapter.class, "marquee.text");
    public static final String MZOOM_TOOL = Messages.getString(GraphTSJobAdapter.class, "marquee.tooltip.text");
    public static final String IZOOM_TEXT = Messages.getString(GraphTSJobAdapter.class, "interactZoom.text");
    public static final String IZOOM_TOOL = Messages.getString(GraphTSJobAdapter.class, "interactZoom.tooltip.text");
    public static final String NEDGES_TEXT = Messages.getString(GraphTSJobAdapter.class, "navigate.text");
    public static final String NEDGES_TOOL = Messages.getString(GraphTSJobAdapter.class, "navigate.tooltip.text");
    public static final String FIT_TEXT = Messages.getString(GraphTSJobAdapter.class, "fit.text");
    public static final String FIT_TOOL = Messages.getString(GraphTSJobAdapter.class, "fit.tooltip.text");
    public static final String EXPORT_TO = Messages.getString(GraphTSJobAdapter.class, "exportGraph.to");
    protected TSSwingCanvas canvas = null;
    protected TSEGraphManager graphManager = null;
    protected TSEGraph processGraph = null;
    protected TSEGraph processCanceled = null;
    protected TSEGraph graphNotAvailable = null;
    protected GraphInfoAdapter graphInfo = null;
    protected TSTool currentTool = null;
    protected EZEntityID id = null;
    protected int status = 2;
    protected Action reload = null;
    protected Action select = null;
    protected Action pan = null;
    protected Action mzoom = null;
    protected Action izoom = null;
    protected Action nedges = null;
    protected Action fitAction = null;
    protected AnalysisViewPrintHandler analysisViewPrintHandler = new AnalysisViewPrintHandler();
    protected AnalysisExportCanvasHandler analysisExportCanvasHandler = new AnalysisExportCanvasHandler();
    public static final String EXPORT_GRAPH_ACTION_ID = "exportGraph";
    private ExecExportStatus execExportStatus = null;
    public static final String ACTION_PROPERTY = "action";

    public GraphTSJobAdapter(String info) {
        super(info);
    }

    public abstract void buildComponents(Composite var1);

    public GraphInfo getGraphInfo() {
        return this.graphInfo;
    }

    protected void createProcessGraphs() {
        this.processGraph = (TSEGraph)this.graphManager.addGraph();
        this.processCanceled = (TSEGraph)this.graphManager.addGraph();
        this.graphNotAvailable = (TSEGraph)this.graphManager.addGraph();
        TSENode load = (TSENode)this.processGraph.addNode();
        load.setName((Object)PROCESS_GRAPH);
        TSENode cancel = (TSENode)this.processCanceled.addNode();
        cancel.setName((Object)PROCESS_CANCELED);
        cancel.setResizability(3);
        TSENode notAvailable = (TSENode)this.graphNotAvailable.addNode();
        notAvailable.setName((Object)NOT_AVAILABLE_GRAPH);
    }

    public void setCurrentTool(int toolType) {
        TSToolManager toolManager = this.canvas.getToolManager();
        switch (toolType) {
            case 6: {
                toolManager.setActiveTool((TSTool)TSViewingToolHelper.getSelectTool((TSToolManager)toolManager));
                break;
            }
            case 1: {
                toolManager.setActiveTool((TSTool)TSViewingToolHelper.getPanTool((TSToolManager)toolManager));
                break;
            }
            case 2: {
                toolManager.setActiveTool((TSTool)TSViewingToolHelper.getZoomTool((TSToolManager)toolManager));
                break;
            }
            case 3: {
                toolManager.setActiveTool((TSTool)TSViewingToolHelper.getInteractiveZoomTool((TSToolManager)toolManager));
                break;
            }
            case 4: {
                TSELinkNavigationTool tool = TSViewingToolHelper.getLinkNavigationTool((TSToolManager)toolManager);
                tool.setTripDuration(0);
                toolManager.setActiveTool((TSTool)tool);
            }
        }
        this.currentTool = toolManager.getActiveTool();
        this.canvas.requestFocus();
    }

    public void registerTools() {
        TSEZoomTool zoomTool = new TSEZoomTool();
        TSViewingToolHelper.registerZoomTool((TSToolManager)this.canvas.getToolManager(), (TSEZoomTool)zoomTool);
        TSViewingToolHelper.registerInteractiveZoomTool((TSToolManager)this.canvas.getToolManager(), (TSEInteractiveZoomTool)new TSEInteractiveZoomTool());
        TSViewingToolHelper.registerPanTool((TSToolManager)this.canvas.getToolManager(), (TSEPanTool)new TSEPanTool());
        TSViewingToolHelper.registerLinkNavigationTool((TSToolManager)this.canvas.getToolManager(), (TSELinkNavigationTool)new TSELinkNavigationTool());
        TSViewingToolHelper.registerSelectTool((TSToolManager)this.canvas.getToolManager(), (TSESelectTool)new TSESelectTool());
        TSEditingToolHelper.registerMoveSelectedTool((TSToolManager)this.canvas.getToolManager(), (TSEMoveSelectedTool)new TSEMoveSelectedTool());
        TSViewingToolHelper.registerSelectRegionTool((TSToolManager)this.canvas.getToolManager(), (TSESelectRegionTool)new TSESelectRegionTool());
        this.canvas.getToolManager().switchTool((TSTool)TSViewingToolHelper.getPanTool((TSToolManager)this.canvas.getToolManager()));
    }

    public void makeGraphActions() {
        this.reload = new Action(){

            public void run() {
                GraphTSJobAdapter.this.status = 2;
                GraphTSJobAdapter.this.init();
            }
        };
        this.reload.setText(RELOAD_CONTENT);
        this.reload.setToolTipText(RELOAD_CONTENT);
        ImageDescriptor id = Activator.getImageDescriptor("icons//reload.png");
        this.reload.setImageDescriptor(id);
        this.select = new Action(SELECT_TEXT, 8){

            public void run() {
                GraphTSJobAdapter.this.setCurrentTool(6);
            }
        };
        this.select.setChecked(false);
        this.select.setToolTipText(SELECT_TOOL);
        id = ImageDescriptor.createFromFile(InternalLoadResource.class, (String)"select.gif");
        this.select.setImageDescriptor(id);
        this.pan = new Action(PAN_TEXT, 8){

            public void run() {
                GraphTSJobAdapter.this.setCurrentTool(1);
            }
        };
        this.pan.setChecked(false);
        this.pan.setToolTipText(PAN_TOOL);
        id = ImageDescriptor.createFromFile(InternalLoadResource.class, (String)"pan.gif");
        this.pan.setImageDescriptor(id);
        this.mzoom = new Action(MZOOM_TEXT, 8){

            public void run() {
                GraphTSJobAdapter.this.setCurrentTool(2);
            }
        };
        this.mzoom.setChecked(false);
        this.mzoom.setToolTipText(MZOOM_TOOL);
        id = ImageDescriptor.createFromFile(InternalLoadResource.class, (String)"marqueezoom.gif");
        this.mzoom.setImageDescriptor(id);
        this.izoom = new Action(IZOOM_TEXT, 8){

            public void run() {
                GraphTSJobAdapter.this.setCurrentTool(3);
            }
        };
        this.izoom.setChecked(false);
        this.izoom.setToolTipText(IZOOM_TOOL);
        id = ImageDescriptor.createFromFile(InternalLoadResource.class, (String)"interactiveZoom.gif");
        this.izoom.setImageDescriptor(id);
        this.nedges = new Action(NEDGES_TEXT, 8){

            public void run() {
                GraphTSJobAdapter.this.setCurrentTool(4);
            }
        };
        this.nedges.setChecked(false);
        this.nedges.setToolTipText(NEDGES_TOOL);
        id = ImageDescriptor.createFromFile(InternalLoadResource.class, (String)"linkNavigation.gif");
        this.nedges.setImageDescriptor(id);
        this.fitAction = new Action(){

            public void run() {
                TSCommand fit = GraphTSJobAdapter.this.getFitCommand();
                GraphTSJobAdapter.this.transmitCommand(fit);
            }
        };
        this.fitAction.setText(FIT_TEXT);
        this.fitAction.setToolTipText(FIT_TOOL);
        id = ImageDescriptor.createFromFile(InternalLoadResource.class, (String)"fitInCanvas.gif");
        this.fitAction.setImageDescriptor(id);
    }

    public abstract TSCommand getFitCommand();

    public void transmitCommands(List commands) {
        this.transmitCommands(commands, false);
    }

    public void transmitCommands(List commands, boolean wait) {
        if (commands != null && commands.size() > 0) {
            try {
                if (commands.size() == 1) {
                    this.transmitCommand((TSCommand)commands.get(0), wait);
                } else {
                    TSGroupCommand gCmd = new TSGroupCommand();
                    Iterator cIt = commands.iterator();
                    while (cIt.hasNext()) {
                        gCmd.add((TSCommandInterface)((TSCommand)cIt.next()));
                    }
                    this.transmitCommand((TSCommand)gCmd, wait);
                }
            }
            catch (Throwable t) {
                L.error("error while transmitting command(s):", t);
            }
        }
    }

    public void transmitCommand(TSCommand cmd) {
        this.transmitCommand(cmd, false);
    }

    public void transmitCommand(final TSCommand cmd, boolean wait) {
        if (cmd != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    TSCommandManager mgr = GraphTSJobAdapter.this.canvas.getCommandManager();
                    mgr.transmit((TSCommandInterface)cmd);
                    if (GraphTSJobAdapter.this.getJobStartTime() > 0L) {
                        long fullDuration = System.currentTimeMillis() - GraphTSJobAdapter.this.getJobStartTime();
                        L.info("{} - duration: {} ms", (Object)GraphTSJobAdapter.this.getAnalysisTypeName(), (Object)fullDuration);
                    }
                }
            };
            if (wait) {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (Exception e) {
                    L.error("while transmmiting command", (Throwable)e);
                }
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
    }

    protected long getJobStartTime() {
        return this.jobStartTime;
    }

    public boolean belongsTo(Object family) {
        if ("GRAPH_JOB".equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    public void closing() {
        if (this.analysisExportCanvasHandler != null) {
            if (this.analysisExportCanvasHandler.saveAsWindow != null) {
                this.analysisExportCanvasHandler.saveAsWindow.dispose();
                this.analysisExportCanvasHandler.saveAsWindow = null;
            }
            this.analysisExportCanvasHandler = null;
        }
        if (this.analysisViewPrintHandler != null) {
            if (this.analysisViewPrintHandler.printPreviewWindow != null) {
                this.analysisViewPrintHandler.printPreviewWindow.dispose();
                this.analysisViewPrintHandler.printPreviewWindow = null;
            }
            this.analysisViewPrintHandler = null;
        }
        if (this.canvas != null) {
            EZMouseTool mouseTool;
            if (this.canvas.getToolManager() != null && (mouseTool = (EZMouseTool)this.canvas.getToolManager().getTool("mouse")) != null) {
                this.canvas.getToolManager().unregister("mouse");
                mouseTool.clean();
            }
            TSCommandManager mgr = this.canvas.getCommandManager();
            mgr.clearUndoHistory();
            this.canvas = null;
        }
        this.currentTool = null;
        this.execExportStatus = null;
        this.fitAction = null;
        try {
            this.graphManager.dispose();
        }
        catch (Throwable th) {
            L.warn("error disposing graph manager", th);
        }
        this.graphManager = null;
        this.graphNotAvailable.dispose();
        this.graphNotAvailable = null;
        this.izoom = null;
        this.mzoom = null;
        this.nedges = null;
        this.pan = null;
        this.processCanceled.dispose();
        this.processCanceled = null;
        this.processGraph.dispose();
        this.processGraph = null;
        this.reload = null;
        this.select = null;
        if (this.graphInfo != null) {
            this.graphInfo.dispose();
            this.graphInfo = null;
        }
    }

    protected abstract IStatus run(IProgressMonitor var1);

    protected abstract List<TSCommand> doLayout(int var1);

    public void changeActionsState(boolean state) {
        if (this.fitAction != null) {
            this.fitAction.setEnabled(state);
        }
        if (this.izoom != null) {
            this.izoom.setEnabled(state);
        }
        if (this.mzoom != null) {
            this.mzoom.setEnabled(state);
        }
        if (this.nedges != null) {
            this.nedges.setEnabled(state);
        }
        if (this.pan != null) {
            this.pan.setEnabled(state);
        }
        if (this.select != null) {
            this.select.setEnabled(state);
        }
    }

    protected List getMenuItems() {
        ArrayList<Object> menuItems = new ArrayList<Object>();
        menuItems.add(new ActionContributionItem((IAction)this.fitAction));
        menuItems.add(new Separator());
        menuItems.add(new ActionContributionItem((IAction)this.select));
        menuItems.add(new ActionContributionItem((IAction)this.pan));
        menuItems.add(new ActionContributionItem((IAction)this.mzoom));
        menuItems.add(new ActionContributionItem((IAction)this.izoom));
        menuItems.add(new ActionContributionItem((IAction)this.nedges));
        return menuItems;
    }

    protected List getToolBarItems() {
        ArrayList<Object> toolBarItems = new ArrayList<Object>();
        toolBarItems.add(new ActionContributionItem((IAction)this.fitAction));
        toolBarItems.add(new Separator());
        toolBarItems.add(new ActionContributionItem((IAction)this.select));
        toolBarItems.add(new ActionContributionItem((IAction)this.pan));
        toolBarItems.add(new ActionContributionItem((IAction)this.mzoom));
        toolBarItems.add(new ActionContributionItem((IAction)this.izoom));
        toolBarItems.add(new ActionContributionItem((IAction)this.nedges));
        return toolBarItems;
    }

    protected TSSwingCanvas createCanvas() {
        this.canvas = new TSSwingCanvas();
        TSPreferenceData preferenceData = this.canvas.getPreferenceData();
        TSGridPreferenceTailor gridPreferenceTailor = new TSGridPreferenceTailor(preferenceData);
        gridPreferenceTailor.setLineGrid();
        gridPreferenceTailor.setSpacingX(10.0);
        gridPreferenceTailor.setSpacingY(10.0);
        TSSwingCanvasPreferenceTailor swingCanvasPreferenceTailor = new TSSwingCanvasPreferenceTailor(preferenceData);
        swingCanvasPreferenceTailor.setMinimumZoomLevel(0.005);
        swingCanvasPreferenceTailor.setMaximumZoomLevel(90.0);
        TSAnimationPreferenceTailor animationTaylor = new TSAnimationPreferenceTailor(preferenceData);
        animationTaylor.setLayoutFadeAnimation(false);
        animationTaylor.setLayoutInterpolationAnimation(false);
        animationTaylor.setViewportChangeAnimation(false);
        TSViewingToolPreferenceTailor vttaylor = new TSViewingToolPreferenceTailor(preferenceData);
        vttaylor.setLinkNavigationSpeed(5000);
        swingCanvasPreferenceTailor.setTooltipsEnabled(true);
        this.currentTool = this.canvas.getToolManager().getActiveTool();
        ActionListener menuAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EZMouseTool mouseTool = (EZMouseTool)GraphTSJobAdapter.this.canvas.getToolManager().getTool("mouse");
                mouseTool.makeRightClickMenu();
            }
        };
        this.canvas.registerKeyboardAction(menuAction, "KeyboardContextMenu", KeyStroke.getKeyStroke(525, 0), 2);
        this.canvas.registerKeyboardAction(menuAction, "KeyboardContextMenu", KeyStroke.getKeyStroke(121, 64), 2);
        return this.canvas;
    }

    protected Map getGlobalActions() {
        HashMap<String, Action> actions = new HashMap<String, Action>();
        Registry reg = Registry.getInstance();
        boolean enabled = reg.check("print.tsgraph");
        PlatformUI.getPreferenceStore().firePropertyChangeEvent(ACTION_PROPERTY, (Object)new Boolean(false), (Object)new Boolean(enabled));
        if (enabled) {
            actions.put(ActionFactory.PRINT.getId(), this.analysisViewPrintHandler);
        }
        enabled = reg.check("export.tsgraph");
        PlatformUI.getPreferenceStore().firePropertyChangeEvent(ACTION_PROPERTY, (Object)new Boolean(false), (Object)new Boolean(enabled));
        if (enabled) {
            actions.put(EXPORT_GRAPH_ACTION_ID, this.analysisExportCanvasHandler);
        }
        return actions;
    }

    protected boolean getRefreshState() {
        return true;
    }

    public boolean isDirty() {
        return this.status == 2;
    }

    public void markAsDirty() {
        this.status = 2;
    }

    protected void scheduleJob() {
        if (this.analysis.scopeIsShared()) {
            Command command = this.analysis.getCommandToExec();
            command.execute();
            EnumMap commResult = command.getResult();
            this.analysis.setRequestID((Integer)commResult.get(RequestConstants.AnalysisRequestReturnKeys.ANALYSIS_KEY_REQUEST_ID));
            RequestConstants.RequestStatus status = (RequestConstants.RequestStatus)commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS);
            switch (status) {
                case STATUS_ACTIVE: {
                    this.schedule();
                    break;
                }
                case STATUS_DENIED: {
                    L.debug("operation is not allowed!");
                    this.analysis.analysisDenied(commResult);
                    break;
                }
                case STATUS_PENDING: {
                    this.analysis.requestPending(commResult, this.analysis.getRequestID());
                    break;
                }
                case STATUS_ERROR: {
                    this.analysis.analysisError(commResult);
                    break;
                }
            }
        } else {
            this.schedule();
        }
    }

    protected String getAnalysisTypeName() {
        return this.analysis.getType().toString();
    }

    protected class AnalysisExportCanvasHandler
    extends Action {
        EZExportGraphDialog saveAsWindow;

        protected AnalysisExportCanvasHandler() {
        }

        public void run() {
            Thread nt = new Thread(new Runnable(){
                Object obj = new Object();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    L.trace("in, beg {}", (Object)Thread.currentThread());
                    Object frame = ((AnalysisExportCanvasHandler)AnalysisExportCanvasHandler.this).GraphTSJobAdapter.this.canvas;
                    L.debug("canvas={}", (Object)((AnalysisExportCanvasHandler)AnalysisExportCanvasHandler.this).GraphTSJobAdapter.this.canvas);
                    L.debug("canvas.parent={}", (Object)((AnalysisExportCanvasHandler)AnalysisExportCanvasHandler.this).GraphTSJobAdapter.this.canvas.getParent());
                    while (frame.getParent() != null) {
                        L.debug("frame={}", frame);
                        L.debug("parent={}", (Object)frame.getParent());
                        frame = frame.getParent();
                    }
                    if (frame instanceof Frame) {
                        Component[] components;
                        AnalysisExportCanvasHandler.this.saveAsWindow = new EZExportGraphDialog((Frame)frame, Messages.getString(GraphTSJobAdapter.class, "exportGraph.dialog.title"), ((AnalysisExportCanvasHandler)AnalysisExportCanvasHandler.this).GraphTSJobAdapter.this.canvas, 15, this.obj);
                        Component[] componentArray = components = AnalysisExportCanvasHandler.this.saveAsWindow.getComponents();
                        int n = components.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component component = componentArray[n2];
                            if (component instanceof JRootPane) {
                                Component[] mainPanelComponents;
                                Component[] componentArray2 = mainPanelComponents = ((JRootPane)component).getComponents();
                                int n3 = mainPanelComponents.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Component mpComponent = componentArray2[n4];
                                    if (mpComponent instanceof JLayeredPane) {
                                        Component[] layerComponents;
                                        Component[] componentArray3 = layerComponents = ((JLayeredPane)mpComponent).getComponents();
                                        int n5 = layerComponents.length;
                                        int n6 = 0;
                                        while (n6 < n5) {
                                            Component wComponent = componentArray3[n6];
                                            if (wComponent instanceof JPanel) {
                                                Component[] pComponents;
                                                JPanel panel = (JPanel)wComponent;
                                                ArrayList<Component> componentPanels = new ArrayList<Component>();
                                                Component[] componentArray4 = pComponents = panel.getComponents();
                                                int n7 = pComponents.length;
                                                int n8 = 0;
                                                while (n8 < n7) {
                                                    Component pComponent = componentArray4[n8];
                                                    componentPanels.add(pComponent);
                                                    ++n8;
                                                }
                                                panel.removeAll();
                                                GridBagConstraints compConstraint = new GridBagConstraints();
                                                GridBagLayout gridbag = new GridBagLayout();
                                                compConstraint.fill = 1;
                                                gridbag.setConstraints(panel, compConstraint);
                                                panel.setLayout(gridbag);
                                                int indexComp = 0;
                                                while (indexComp < componentPanels.size()) {
                                                    Insets internalPadding;
                                                    if (indexComp == 0) {
                                                        compConstraint.gridx = 0;
                                                        compConstraint.gridy = 0;
                                                        compConstraint.anchor = 23;
                                                        compConstraint.weightx = 0.5;
                                                        compConstraint.weighty = 0.5;
                                                        compConstraint.insets = internalPadding = new Insets(0, 10, 0, 10);
                                                    } else {
                                                        compConstraint.gridx = 0;
                                                        compConstraint.gridy = 1;
                                                        compConstraint.anchor = 26;
                                                        compConstraint.weightx = 0.0;
                                                        compConstraint.weighty = 0.0;
                                                        compConstraint.insets = internalPadding = new Insets(10, 10, 10, 10);
                                                    }
                                                    gridbag.setConstraints((Component)componentPanels.get(indexComp), compConstraint);
                                                    panel.add((Component)componentPanels.get(indexComp));
                                                    ++indexComp;
                                                }
                                            }
                                            ++n6;
                                        }
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        AnalysisExportCanvasHandler.this.saveAsWindow.setResizable(true);
                        AnalysisExportCanvasHandler.this.saveAsWindow.setVisible(true);
                        boolean vb = AnalysisExportCanvasHandler.this.saveAsWindow.okPressed();
                        if (vb) {
                            Object object = this.obj;
                            synchronized (object) {
                                try {
                                    L.trace("before wait on obj");
                                    this.obj.wait();
                                    L.trace("after wait on obj");
                                }
                                catch (InterruptedException e) {
                                    L.error("error at waiting for export finish", (Throwable)e);
                                }
                            }
                            if (AnalysisExportCanvasHandler.this.saveAsWindow.isExportOk()) {
                                if (GraphTSJobAdapter.this.execExportStatus == null) {
                                    GraphTSJobAdapter.this.execExportStatus = new ExecExportStatus();
                                }
                                ((GraphTSJobAdapter)((AnalysisExportCanvasHandler)AnalysisExportCanvasHandler.this).GraphTSJobAdapter.this).execExportStatus.exportStatus = AnalysisExportCanvasHandler.this.saveAsWindow.isExportOk();
                                ((GraphTSJobAdapter)((AnalysisExportCanvasHandler)AnalysisExportCanvasHandler.this).GraphTSJobAdapter.this).execExportStatus.exportFile = AnalysisExportCanvasHandler.this.saveAsWindow.getExportFile();
                                ((GraphTSJobAdapter)((AnalysisExportCanvasHandler)AnalysisExportCanvasHandler.this).GraphTSJobAdapter.this).execExportStatus.openFileOnExportOk = AnalysisExportCanvasHandler.this.saveAsWindow.isOpenFileOnExportOk();
                                Display.getDefault().syncExec((Runnable)GraphTSJobAdapter.this.execExportStatus);
                            }
                        }
                    } else {
                        L.warn("export;no frame found. frame={}", frame);
                    }
                    L.trace("in, end {}", (Object)Thread.currentThread());
                }
            });
            nt.start();
            L.trace("out, end {}", (Object)Thread.currentThread());
        }
    }

    class AnalysisViewPrintHandler
    extends Action {
        EZPrintPreviewWindow printPreviewWindow;

        AnalysisViewPrintHandler() {
        }

        public void run() {
            Thread nt = new Thread(new Runnable(){

                @Override
                public void run() {
                    L.trace("in, beg {}", (Object)Thread.currentThread());
                    Component frame = GraphTSJobAdapter.this.getGraphInfo().getCanvasComponent();
                    while (frame.getParent() != null) {
                        frame = frame.getParent();
                    }
                    if (frame instanceof Frame) {
                        TSPreferenceData data = new TSPreferenceData();
                        data.setOption(null, "page:orientation", 0);
                        data.setOption(null, "page:width", 595.27);
                        data.setOption(null, "page:height", 841.89);
                        data.setOption(null, "page:rightMargin", 72.0);
                        data.setOption(null, "page:bottomMargin", 72.0);
                        data.setOption(null, "page:topMargin", 72.0);
                        data.setOption(null, "page:leftMargin", 72.0);
                        AnalysisViewPrintHandler.this.printPreviewWindow = new EZPrintPreviewWindow((Frame)frame, Messages.getString(GraphTSJobAdapter.class, "print.dialog.title"), (TSBaseSwingCanvas)((AnalysisViewPrintHandler)AnalysisViewPrintHandler.this).GraphTSJobAdapter.this.canvas);
                        AnalysisViewPrintHandler.this.printPreviewWindow.setPreferenceData(data, true, false);
                        L.debug("pageOrientation before open print preview= {}", data.getValue(null, "page:orientation"));
                        AnalysisViewPrintHandler.this.printPreviewWindow.setVisible(true);
                        L.debug("pageOrientation after closing print preview= {}", data.getValue(null, "page:orientation"));
                    } else {
                        L.warn("print;no frame found. frame={}", (Object)frame);
                    }
                    L.trace("in, end {}", (Object)Thread.currentThread());
                }
            });
            nt.start();
            L.trace("out, end {}", (Object)Thread.currentThread());
        }
    }

    protected abstract class ProgressAction
    extends Action {
        protected Job job;

        public ProgressAction(String name, int style, GraphInfo graphInfo) {
            super(name, style);
            this.job = new ProgressJob(graphInfo);
            this.job.setUser(true);
        }

        public ProgressAction(String name, int style) {
            super(name, style);
            this.job = new ProgressJob();
            this.job.setUser(true);
        }

        public ProgressAction(GraphInfo graphInfo) {
            this.job = new ProgressJob(graphInfo);
            this.job.setUser(true);
        }

        public ProgressAction() {
            this.job = new ProgressJob();
            this.job.setUser(true);
        }

        public abstract void execute(IProgressMonitor var1);

        public void run() {
            this.job.setName(this.getText());
            this.job.schedule();
        }

        public void dispose() {
            this.job = null;
        }

        protected class ProgressJob
        extends Job
        implements GraphTranslateJob {
            private GraphInfo graphInfo;

            public ProgressJob() {
                super(Messages.getString(GraphTSJobAdapter.class, "progress.job.text"));
            }

            public ProgressJob(GraphInfo graphInfo) {
                this();
                this.graphInfo = graphInfo;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (ProgressAction.this.isChecked()) {
                    boolean previousRefreshState = GraphTSJobAdapter.this.getRefreshState();
                    ((ProgressAction)ProgressAction.this).GraphTSJobAdapter.this.reload.setEnabled(false);
                    GraphTSJobAdapter.this.changeActionsState(false);
                    ProgressAction.this.execute(monitor);
                    GraphTSJobAdapter.this.changeActionsState(true);
                    ((ProgressAction)ProgressAction.this).GraphTSJobAdapter.this.reload.setEnabled(previousRefreshState);
                }
                return Status.OK_STATUS;
            }

            public void buildComponents(Composite parent) {
            }

            public GraphInfo getGraphInfo() {
                return this.graphInfo;
            }

            public void init() {
            }

            public boolean isDirty() {
                return false;
            }

            public void markAsDirty() {
            }

            public boolean belongsTo(Object family) {
                if (this.graphInfo != null) {
                    return "GRAPH_JOB".equals(family);
                }
                return super.belongsTo(family);
            }
        }
    }
}

