/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.job;

import com.ez.workspace.analysis.graph.EZNodeHidingManager;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.complexity.TSHidingManager;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.complexity.TSEHidingManager;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import java.util.ArrayList;
import java.util.List;

public class GraphEditor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final int VISIBLE_EDGE = 0;
    public static final int HIDDEN_EDGE = 1;

    public static void showAllEdges(TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo, AbstractAnalysisGraphModel graphModel) {
        GraphEditor.showAllEdges(graphManager, canvas, (TSEOverviewComponent)graphInfo.getOverviewComponent(), canvas.getGraph());
    }

    public static void showAllEdges(TSEGraphManager graphManager, TSSwingCanvas canvas, TSEOverviewComponent overview, TSEGraph graph) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)graphManager.getHidingManager();
        hidingManager.getHiddenObjects((TSDGraph)graph);
        hidingManager.setGroupSource("flag");
        List rnodes = hidingManager.getResultNodeList();
        List redges = hidingManager.getResultEdgeList();
        ArrayList<TSEdge> toShow = new ArrayList<TSEdge>();
        for (TSEdge edge : redges) {
            if (!graph.contains(edge.getSourceNode()) || !graph.contains(edge.getTargetNode())) continue;
            toShow.add(edge);
        }
        TSEGraph intergraph = (TSEGraph)graphManager.queryIntergraph();
        if (intergraph != null) {
            List intergraphEdges;
            List list = intergraphEdges = intergraph.hideOrHideFromGraph != null ? intergraph.hideOrHideFromGraph.disconnectedEdges() : null;
            if (intergraphEdges != null) {
                toShow.addAll(intergraphEdges);
            }
        }
        hidingManager.startEventGroup();
        hidingManager.unhide(null, toShow, true);
        GraphAnalysisJob.createMetaEdges(graphManager);
        hidingManager.endEventGroup();
        toShow.addAll(rnodes);
        canvas.addInvalidRegion(toShow);
        canvas.updateInvalidRegion(true);
        if (overview != null) {
            overview.updateOverview();
        }
    }

    public static void showAllNodes(TSEGraphManager graphManager, TSSwingCanvas canvas, TSEOverviewComponent overview, TSEGraph graph) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)graphManager.getHidingManager();
        hidingManager.getHiddenObjects((TSDGraph)graph);
        hidingManager.setGroupSource("flag");
        List toShow = hidingManager.getResultNodeList();
        hidingManager.startEventGroup();
        hidingManager.unhide((TSDGraph)graph, toShow, null, true);
        hidingManager.endEventGroup();
        canvas.addInvalidRegion(toShow);
        canvas.updateInvalidRegion(true);
        if (overview != null) {
            overview.updateOverview();
        }
    }

    public static void hideAllEdges(TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo, AbstractAnalysisGraphModel graphModel) {
        GraphEditor.hideAllEdges(graphManager, canvas, (TSEOverviewComponent)graphInfo.getOverviewComponent(), canvas.getGraph());
    }

    public static void hideAllEdges(TSEGraphManager graphManager, TSSwingCanvas canvas, TSEOverviewComponent overview, TSEGraph graph) {
        List intergraphEdges;
        EZNodeHidingManager hideManager = (EZNodeHidingManager)graphManager.getHidingManager();
        List edges = graph.buildEdges(1);
        TSGraph intergraph = graphManager.queryIntergraph();
        if (intergraph != null && (intergraphEdges = intergraph.buildEdges(18)) != null) {
            edges.addAll(intergraphEdges);
        }
        hideManager.startEventGroup();
        hideManager.setGroupSource("flag");
        hideManager.hide(null, edges);
        hideManager.endEventGroup();
        canvas.addInvalidRegion(edges);
        canvas.updateInvalidRegion(true);
        if (overview != null) {
            overview.updateOverview();
        }
    }

    public static void hideForwardPath(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)graphManager.getHidingManager();
        ArrayList nodes = new ArrayList();
        ArrayList edges = new ArrayList();
        node.findChildren(nodes, edges, -2L);
        ArrayList tempNodes = new ArrayList();
        ArrayList workNodes = new ArrayList();
        workNodes.addAll(nodes);
        boolean end = false;
        while (!end) {
            end = true;
            tempNodes.clear();
            tempNodes.addAll(workNodes);
            workNodes.clear();
            for (TSENode cnode : tempNodes) {
                boolean out = false;
                for (TSEdge cedge : cnode.inEdges()) {
                    TSNode sourceNode = cedge.getSourceNode();
                    if (node == sourceNode || tempNodes.contains(sourceNode)) continue;
                    out = true;
                    end = false;
                    break;
                }
                if (out) continue;
                workNodes.add(cnode);
            }
        }
        hidingManager.startEventGroup();
        hidingManager.hide(workNodes, edges);
        hidingManager.endEventGroup();
        ArrayList all = new ArrayList();
        all.addAll(nodes);
        all.add(node);
        all.addAll(edges);
        canvas.addInvalidRegion(all);
        canvas.updateInvalidRegion(true);
        ((TSEOverviewComponent)graphInfo.getOverviewComponent()).updateOverview();
    }

    public static List showForwardPath(TSENode node, boolean showAllNodes, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo, AbstractAnalysisGraphModel graphModel) {
        ArrayList result = new ArrayList();
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)graphManager.getHidingManager();
        ArrayList<TSENode> wNodes = new ArrayList<TSENode>();
        ArrayList wEdges = new ArrayList();
        ArrayList<TSENode> vNodes = new ArrayList<TSENode>();
        ArrayList<TSNode> invNodes = new ArrayList<TSNode>();
        wNodes.add(node);
        vNodes.add(node);
        ArrayList<TSEdge> edges = new ArrayList<TSEdge>();
        hidingManager.startEventGroup();
        while (!wNodes.isEmpty()) {
            TSENode cNode = (TSENode)wNodes.remove(0);
            wEdges.clear();
            List edgeList = new ArrayList();
            hidingManager.findHiddenIncidentOutgoingEdgeList((TSDNode)cNode);
            edgeList = hidingManager.getResultEdgeList();
            wEdges.addAll(edgeList);
            edgeList = cNode.buildOutEdges(1);
            wEdges.addAll(edgeList);
            for (TSEdge tmpEdge : wEdges) {
                TSENode tNode = (TSENode)tmpEdge.getTargetNode();
                if (!wNodes.contains(tNode) && !vNodes.contains(tNode)) {
                    wNodes.add(tNode);
                    vNodes.add(tNode);
                }
                edges.add(tmpEdge);
                invNodes.add(tmpEdge.getSourceNode());
                invNodes.add(tmpEdge.getTargetNode());
            }
            hidingManager.unhide(vNodes, edges, true);
        }
        List hiddenNodes = null;
        if (showAllNodes && TSHidingManager.hasHiddenNodes((TSDGraph)graphModel.getGraph())) {
            hidingManager.getHiddenObjects((TSDGraph)graphModel.getGraph());
            hiddenNodes = hidingManager.getResultNodeList();
            hidingManager.unhide(hiddenNodes, null, false);
        }
        hidingManager.endEventGroup();
        ArrayList<Object> all = new ArrayList<Object>();
        all.addAll(invNodes);
        all.addAll(edges);
        if (hiddenNodes != null) {
            all.addAll(hiddenNodes);
        }
        canvas.addInvalidRegion(all);
        canvas.updateInvalidRegion(true);
        ((TSEOverviewComponent)graphInfo.getOverviewComponent()).updateOverview();
        result.addAll(vNodes);
        vNodes.clear();
        invNodes.clear();
        edges.clear();
        wEdges.clear();
        return result;
    }

    public static void showForwardPathAndHideOtherNodes(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo, AbstractAnalysisGraphModel graphModel) {
        List nodesVisible = GraphEditor.showForwardPath(node, false, graphManager, canvas, graphInfo, graphModel);
        GraphEditor.hideUnconnectedNodes(nodesVisible, graphManager, canvas, (TSEOverviewComponent)graphInfo.getOverviewComponent(), (TSEGraph)node.getOwnerGraph());
    }

    public static void hideUnconnectedNodes(List nodesVisible, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo, AbstractAnalysisGraphModel graphModel) {
        GraphEditor.hideUnconnectedNodes(nodesVisible, graphManager, canvas, (TSEOverviewComponent)graphInfo.getOverviewComponent(), canvas.getGraph());
    }

    public static void hideUnconnectedNodes(List nodesVisible, TSEGraphManager graphManager, TSSwingCanvas canvas, TSEOverviewComponent overview, TSEGraph graph) {
        List nodesSet = graph.nodeSet;
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)graphManager.getHidingManager();
        ArrayList<TSENode> toHideNode = new ArrayList<TSENode>();
        for (Object obj : nodesSet) {
            TSENode currentNode;
            if (!(obj instanceof TSENode) || nodesVisible.contains(obj) || (currentNode = (TSENode)obj).inDegree() + currentNode.outDegree() != 0) continue;
            toHideNode.add(currentNode);
        }
        hidingManager.startEventGroup();
        hidingManager.hide(toHideNode, null);
        hidingManager.endEventGroup();
        ArrayList<TSENode> all = new ArrayList<TSENode>();
        all.addAll(toHideNode);
        canvas.addInvalidRegion(all);
        canvas.updateInvalidRegion(true);
        if (overview != null) {
            overview.updateOverview();
        }
    }

    public static void hideUnconnectedNodes(TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo, AbstractAnalysisGraphModel graphModel) {
        GraphEditor.hideUnconnectedNodes(new ArrayList(), graphManager, canvas, graphInfo, graphModel);
    }

    public static void showBackwardPathAndHideOtherNodes(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo, AbstractAnalysisGraphModel graphModel) {
        List nodesVisible = GraphEditor.showBackwardPath(node, false, graphManager, canvas, graphInfo, graphModel);
        GraphEditor.hideUnconnectedNodes(nodesVisible, graphManager, canvas, (TSEOverviewComponent)graphInfo.getOverviewComponent(), (TSEGraph)node.getOwnerGraph());
    }

    public static void showBackwardPathAndHideOtherNodes(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, TSEOverviewComponent overview, TSEGraph graph) {
        List nodesVisible = GraphEditor.showBackwardPath(node, false, graphManager, canvas, overview, graph);
        GraphEditor.hideUnconnectedNodes(nodesVisible, graphManager, canvas, overview, graph);
    }

    public static void hideBackwardPath(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)graphManager.getHidingManager();
        ArrayList nodes = new ArrayList();
        ArrayList edges = new ArrayList();
        node.findParents(nodes, edges, -2L);
        ArrayList tempNodes = new ArrayList();
        ArrayList workNodes = new ArrayList();
        workNodes.addAll(nodes);
        boolean end = false;
        while (!end) {
            end = true;
            tempNodes.clear();
            tempNodes.addAll(workNodes);
            workNodes.clear();
            for (TSENode cnode : tempNodes) {
                boolean out = false;
                for (TSEdge cedge : cnode.outEdges()) {
                    TSNode sourceNode = cedge.getTargetNode();
                    if (node == sourceNode || tempNodes.contains(sourceNode)) continue;
                    out = true;
                    end = false;
                    break;
                }
                if (out) continue;
                workNodes.add(cnode);
            }
        }
        hidingManager.startEventGroup();
        hidingManager.hide(workNodes, edges);
        hidingManager.endEventGroup();
        ArrayList all = new ArrayList();
        all.addAll(nodes);
        all.add(node);
        all.addAll(edges);
        canvas.addInvalidRegion(all);
        canvas.updateInvalidRegion(true);
        ((TSEOverviewComponent)graphInfo.getOverviewComponent()).updateOverview();
    }

    public static List showBackwardPath(TSENode node, boolean showAllNodes, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo, AbstractAnalysisGraphModel graphModel) {
        return GraphEditor.showBackwardPath(node, showAllNodes, graphManager, canvas, (TSEOverviewComponent)graphInfo.getOverviewComponent(), graphModel.getGraph());
    }

    public static List showBackwardPath(TSENode node, boolean showAllNodes, TSEGraphManager graphManager, TSSwingCanvas canvas, TSEOverviewComponent overview, TSEGraph graph) {
        ArrayList result = new ArrayList();
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)graphManager.getHidingManager();
        ArrayList<TSENode> wNodes = new ArrayList<TSENode>();
        ArrayList wEdges = new ArrayList();
        ArrayList<TSENode> vNodes = new ArrayList<TSENode>();
        ArrayList<TSNode> invNodes = new ArrayList<TSNode>();
        wNodes.add(node);
        vNodes.add(node);
        ArrayList<TSEdge> edges = new ArrayList<TSEdge>();
        hidingManager.startEventGroup();
        while (!wNodes.isEmpty()) {
            TSENode cNode = (TSENode)wNodes.remove(0);
            wEdges.clear();
            List edgeList = new ArrayList();
            hidingManager.findHiddenIncidentIncomingEdgeList((TSDNode)cNode);
            edgeList = hidingManager.getResultEdgeList();
            wEdges.addAll(edgeList);
            edgeList = cNode.buildInEdges(1);
            wEdges.addAll(edgeList);
            for (TSEdge tmpEdge : wEdges) {
                TSENode tNode = (TSENode)tmpEdge.getSourceNode();
                if (!wNodes.contains(tNode) && !vNodes.contains(tNode)) {
                    wNodes.add(tNode);
                    vNodes.add(tNode);
                }
                edges.add(tmpEdge);
                invNodes.add(tmpEdge.getSourceNode());
                invNodes.add(tmpEdge.getTargetNode());
            }
            hidingManager.unhide(vNodes, edges, true);
        }
        List hiddenNodes = null;
        if (showAllNodes && TSHidingManager.hasHiddenNodes((TSDGraph)graph)) {
            hidingManager.getHiddenObjects((TSDGraph)graph);
            hiddenNodes = hidingManager.getResultNodeList();
            hidingManager.unhide(hiddenNodes, null, false);
        }
        hidingManager.endEventGroup();
        ArrayList<Object> all = new ArrayList<Object>();
        all.addAll(invNodes);
        all.addAll(edges);
        if (hiddenNodes != null) {
            all.addAll(hiddenNodes);
        }
        canvas.addInvalidRegion(all);
        canvas.updateInvalidRegion(true);
        if (overview != null) {
            overview.updateOverview();
        }
        result.addAll(vNodes);
        vNodes.clear();
        invNodes.clear();
        edges.clear();
        wEdges.clear();
        return result;
    }

    public static void hideSelected(TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        hidingManager.startEventGroup();
        hidingManager.hideSelected();
        hidingManager.endEventGroup();
        canvas.updateInvalidRegion(true);
        ((TSEOverviewComponent)graphInfo.getOverviewComponent()).updateOverview();
    }

    public void hideNode(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo, AbstractAnalysisGraphModel graphModel) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        ArrayList edgesList = new ArrayList();
        ArrayList<TSENode> nodeList = new ArrayList<TSENode>();
        edgesList.addAll(node.inEdges());
        edgesList.addAll(node.outEdges());
        nodeList.add(node);
        hidingManager.startEventGroup();
        hidingManager.hide(nodeList, edgesList);
        hidingManager.endEventGroup();
        canvas.addInvalidRegion(edgesList);
        canvas.addInvalidRegion(nodeList);
        canvas.updateInvalidRegion(true);
        ((TSEOverviewComponent)graphInfo.getOverviewComponent()).updateOverview();
    }

    public static void hideIncomingEdges(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        ArrayList<TSENode> edgesList = new ArrayList<TSENode>();
        edgesList.addAll(node.inEdges());
        hidingManager.startEventGroup();
        hidingManager.hide(null, edgesList);
        hidingManager.endEventGroup();
        edgesList.add(node);
        canvas.addInvalidRegion(edgesList);
        canvas.updateInvalidRegion(true);
        ((TSEOverviewComponent)graphInfo.getOverviewComponent()).updateOverview();
    }

    public static void hideOutgoingEdges(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        ArrayList<TSENode> edgesList = new ArrayList<TSENode>();
        edgesList.addAll(node.outEdges());
        hidingManager.startEventGroup();
        hidingManager.hide(null, edgesList);
        hidingManager.endEventGroup();
        edgesList.add(node);
        canvas.addInvalidRegion(edgesList);
        canvas.updateInvalidRegion(true);
        ((TSEOverviewComponent)graphInfo.getOverviewComponent()).updateOverview();
    }

    public static void unhideIncomingEdges(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        hidingManager.findHiddenIncidentIncomingEdgeList((TSDNode)node);
        List hiddenEdgeList = hidingManager.getResultEdgeList();
        ArrayList<TSENode> nodes = new ArrayList<TSENode>();
        for (TSEdge tmpEdge : hiddenEdgeList) {
            TSENode sNode = (TSENode)tmpEdge.getSourceNode();
            nodes.add(sNode);
        }
        hidingManager.startEventGroup();
        hidingManager.unhide(nodes, hiddenEdgeList, false);
        hidingManager.endEventGroup();
        hiddenEdgeList.add(nodes);
        canvas.addInvalidRegion(hiddenEdgeList);
        canvas.updateInvalidRegion(true);
        ((TSEOverviewComponent)graphInfo.getOverviewComponent()).updateOverview();
    }

    public static void unhideOutgoingEdges(TSENode node, TSEGraphManager graphManager, TSSwingCanvas canvas, GraphInfo graphInfo) {
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)graphManager.getHidingManager();
        hidingManager.findHiddenIncidentOutgoingEdgeList((TSDNode)node);
        ArrayList hiddenEdgeList = new ArrayList(hidingManager.getResultEdgeList());
        ArrayList<TSENode> nodes = new ArrayList<TSENode>();
        for (TSEdge tmpEdge : hiddenEdgeList) {
            TSENode tNode = (TSENode)tmpEdge.getTargetNode();
            nodes.add(tNode);
        }
        hidingManager.startEventGroup();
        hidingManager.unhide(nodes, hiddenEdgeList, false);
        hidingManager.endEventGroup();
        hiddenEdgeList.addAll(nodes);
        canvas.addInvalidRegion(hiddenEdgeList);
        canvas.updateInvalidRegion(true);
        ((TSEOverviewComponent)graphInfo.getOverviewComponent()).updateOverview();
    }

    public static boolean getOUTActionState(TSENode tsNode, int type, TSEGraphManager graphManager) {
        boolean enabled = false;
        TSEHidingManager hidingManager = (TSEHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        int outVisibleEdgesCount = tsNode.outDegree();
        hidingManager.findHiddenIncidentOutgoingEdgeList((TSDNode)tsNode);
        List outHiddenEdges = hidingManager.getResultEdgeList();
        if (type == 0 && outVisibleEdgesCount > 0) {
            enabled = true;
        }
        if (type == 1 && outHiddenEdges.size() != 0) {
            enabled = true;
        }
        return enabled;
    }

    public static boolean getINActionState(TSENode tsNode, int type, TSEGraphManager graphManager) {
        boolean enabled = false;
        TSEHidingManager hidingManager = (TSEHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        int inVisibleEdgesCount = tsNode.inDegree();
        hidingManager.findHiddenIncidentIncomingEdgeList((TSDNode)tsNode);
        List inHiddenEdges = hidingManager.getResultEdgeList();
        if (type == 0 && inVisibleEdgesCount > 0) {
            enabled = true;
        }
        if (type == 1 && inHiddenEdges.size() != 0) {
            enabled = true;
        }
        return enabled;
    }

    public static boolean getFORWARDActionState(TSENode tsNode, TSEGraphManager graphManager) {
        boolean enabled = false;
        TSEHidingManager hidingManager = (TSEHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        int outVisibleEdgesCount = tsNode.outDegree();
        hidingManager.findHiddenIncidentOutgoingEdgeList((TSDNode)tsNode);
        List outHiddenEdges = hidingManager.getResultEdgeList();
        if (outVisibleEdgesCount + outHiddenEdges.size() > 0) {
            enabled = true;
        }
        return enabled;
    }

    public static boolean getBACKWARDActionState(TSENode tsNode, TSEGraphManager graphManager) {
        boolean enabled = false;
        TSEHidingManager hidingManager = (TSEHidingManager)TSEHidingManager.getManager((TSDGraphManager)graphManager);
        int inVisibleEdgesCount = tsNode.inDegree();
        hidingManager.findHiddenIncidentIncomingEdgeList((TSDNode)tsNode);
        List inHiddenEdges = hidingManager.getResultEdgeList();
        if (inVisibleEdgesCount + inHiddenEdges.size() > 0) {
            enabled = true;
        }
        return enabled;
    }
}

