/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.job;

import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.graph.EZNodeHidingManager;
import com.ez.workspace.analysis.graph.gui.GraphFlowViewer;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.AbstractGraphAnalysisJob;
import com.ez.workspace.analysis.graph.job.GraphEditor;
import com.ez.workspace.analysis.graph.job.GraphTSJobAdapter;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.job.SelectionJob;
import com.ez.workspace.resources.InternalLoadResource;
import com.ez.workspace.state.StateManager;
import com.ez.workspace.ui.Activator;
import com.ez.workspace.ui.internal.Messages;
import com.tomsawyer.canvas.TSBaseCanvasInterface;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.complexity.TSHidingManager;
import com.tomsawyer.drawing.complexity.TSNestingManager;
import com.tomsawyer.drawing.complexity.events.TSComplexityChangeEvent;
import com.tomsawyer.drawing.complexity.events.TSComplexityChangeListener;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.TSEObject;
import com.tomsawyer.graphicaldrawing.complexity.TSEFoldingManager;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.TSCommandInterface;
import com.tomsawyer.interactive.command.TSCommandListener;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.command.editing.TSEViewChildGraphCommand;
import com.tomsawyer.interactive.command.editing.TSEViewParentGraphCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;

public abstract class GraphAnalysisJob
extends AbstractGraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected SelectionJob selectJob;
    private HideShowEdgeListener hideShowEdgeListener = null;
    private TSCommandListener switchChildParentGraphListener = null;
    protected StateManager stateManager = StateManager.getInstance();
    protected Action textBoxOnly = null;
    protected Action svgIcon = null;
    protected GraphFilterInfo gfi;
    protected LegendPanel legend = null;
    CreateViewerRunnable viewerRunnable;
    protected Action hideAllEdges = null;
    private Action showAllEdges = null;
    private Action hideSelected = null;
    private Action hideUnconnected = null;
    private Action redrawAll = null;

    public GraphAnalysisJob(EZEntityID id) {
        super(id);
        this.selectJob = new SelectionJob(id);
    }

    @Override
    protected void initGraphDetails() {
        super.initGraphDetails();
        this.switchChildParentGraphListener = new TSCommandListener(){

            public int listen(TSCommandInterface arg0) {
                if (arg0 instanceof TSEViewChildGraphCommand || arg0 instanceof TSEViewParentGraphCommand) {
                    GraphAnalysisJob.this.changeEdgesActionsState();
                }
                return 0;
            }
        };
    }

    @Override
    public void closing() {
        this.selectJob = null;
        this.viewerRunnable = null;
        this.graphManager.getEventManager().removeListener((EventListener)((Object)this.hideShowEdgeListener));
        this.canvas.getCommandManager().removeCommandListener(this.switchChildParentGraphListener);
        this.gfi = null;
        super.closing();
    }

    public SelectionJob getSelectJob() {
        return this.selectJob;
    }

    @Override
    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.hideShowEdgeListener = new HideShowEdgeListener();
        this.graphManager.getEventManager().addListener((Object)this.graphManager, (EventListener)((Object)this.hideShowEdgeListener), 640L, TSComplexityChangeEvent.class);
        if (!this.canvas.getCommandManager().getCommandListeners().contains(this.switchChildParentGraphListener)) {
            this.canvas.getCommandManager().addCommandListener(this.switchChildParentGraphListener);
        }
    }

    protected void createRedrawAction() {
        if (this.redrawAll == null) {
            this.redrawAll = new Action(Messages.getString(GraphAnalysisJob.class, "action.label.redrawAll"), 1){

                public void run() {
                    GraphAnalysisJob.this.redrawAll();
                }
            };
            this.redrawAll.setText(REFRESH_CONTENT);
            this.redrawAll.setToolTipText(REFRESH_CONTENT);
            this.redrawAll.setImageDescriptor(ImageDescriptor.createFromFile(InternalLoadResource.class, (String)"refresh_16.gif"));
        }
    }

    protected void redrawAll() {
        this.jobStartTime = 0L;
        this.refreshLegend();
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)this.graphModel.getGraphManager().getHidingManager();
        hidingManager.setGroupSource("flag");
        hidingManager.unhideAll();
        hidingManager.endEventGroup();
        List<TSCommand> cmds = this.doLayout(this.currentLayoutType);
        this.transmitCommands(cmds);
        ((TSEOverviewComponent)this.graphInfo.getOverviewComponent()).updateOverview();
    }

    protected void refreshLegend() {
        if (this.gfi != null) {
            this.gfi.clearFilters(this.graphModel.getGraph());
        }
        if (this.legend != null && !this.legend.isDisposed() && this.legend.isVisible()) {
            this.legend.refreshButtonsAndLbls();
        }
    }

    protected void changeRedrawActionState(boolean state) {
        this.redrawAll.setEnabled(state);
    }

    protected void createEdgesActions() {
        if (this.hideAllEdges == null) {
            this.hideAllEdges = new Action(Messages.getString(GraphAnalysisJob.class, "action.label.hideAllEdges"), 1){

                public void run() {
                    GraphEditor.hideAllEdges(GraphAnalysisJob.this.graphManager, GraphAnalysisJob.this.canvas, GraphAnalysisJob.this.graphInfo, GraphAnalysisJob.this.graphModel);
                }
            };
            this.hideAllEdges.setEnabled(true);
            this.hideAllEdges.setImageDescriptor(Activator.getImageDescriptor("icons/hideAll.gif"));
        }
        if (this.showAllEdges == null) {
            this.showAllEdges = new Action(Messages.getString(GraphAnalysisJob.class, "action.label.showAllEdges"), 1){

                public void run() {
                    GraphEditor.showAllEdges(GraphAnalysisJob.this.graphManager, GraphAnalysisJob.this.canvas, GraphAnalysisJob.this.graphInfo, GraphAnalysisJob.this.graphModel);
                }
            };
            this.showAllEdges.setEnabled(false);
            this.showAllEdges.setImageDescriptor(Activator.getImageDescriptor("icons/showAll5.gif"));
        }
        if (this.hideSelected == null) {
            this.hideSelected = new Action(Messages.getString(GraphAnalysisJob.class, "action.label.hideSelected"), 1){

                public void run() {
                    GraphEditor.hideSelected(GraphAnalysisJob.this.graphManager, GraphAnalysisJob.this.canvas, GraphAnalysisJob.this.graphInfo);
                }
            };
            this.hideSelected.setEnabled(true);
            this.hideSelected.setImageDescriptor(Activator.getImageDescriptor("icons/hideSelected.png"));
        }
        if (this.hideUnconnected == null) {
            this.hideUnconnected = new Action(Messages.getString(GraphAnalysisJob.class, "action.label.hideUnconnected"), 1){

                public void run() {
                    GraphEditor.hideUnconnectedNodes(GraphAnalysisJob.this.graphManager, GraphAnalysisJob.this.canvas, GraphAnalysisJob.this.graphInfo, GraphAnalysisJob.this.graphModel);
                }
            };
            this.hideUnconnected.setEnabled(true);
            this.hideUnconnected.setImageDescriptor(Activator.getImageDescriptor("icons/hideUnconnected.png"));
        }
    }

    @Override
    public void makeGraphActions() {
        super.makeGraphActions();
        this.createRedrawAction();
    }

    @Override
    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeRedrawEntry(menus);
        return menus;
    }

    @Override
    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeRedrawEntry(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    @Override
    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeRedrawActionState(state);
    }

    protected void contributeEdgesEntries(List menus) {
        menus.add(new Separator());
        menus.add(new ActionContributionItem((IAction)this.hideAllEdges));
        menus.add(new ActionContributionItem((IAction)this.showAllEdges));
        menus.add(new ActionContributionItem((IAction)this.hideSelected));
        menus.add(new ActionContributionItem((IAction)this.hideUnconnected));
    }

    protected void contributeRedrawEntry(List menus) {
        menus.add(new Separator());
        menus.add(new ActionContributionItem((IAction)this.reload));
        menus.add(new ActionContributionItem((IAction)this.redrawAll));
    }

    protected void changeEdgesActionsState() {
        int visibleIntergraphEdges;
        int n = visibleIntergraphEdges = this.graphManager.queryIntergraph() != null ? this.graphManager.queryIntergraph().buildEdges(18).size() : 0;
        if (this.canvas.getGraph() != null && this.canvas.getGraph().numberOfEdges() + visibleIntergraphEdges == 0) {
            this.hideAllEdges.setEnabled(false);
        } else {
            this.hideAllEdges.setEnabled(true);
        }
        if (this.graphManager == null || this.canvas.getGraph() == null || !TSHidingManager.hasHiddenEdges((TSDGraph)this.canvas.getGraph())) {
            this.showAllEdges.setEnabled(false);
        } else {
            this.showAllEdges.setEnabled(true);
        }
        this.hideUnconnected.setEnabled(true);
        this.hideSelected.setEnabled(true);
    }

    protected void createIconActions() {
        if (this.textBoxOnly == null) {
            this.textBoxOnly = new Action(Messages.getString(GraphAnalysisJob.class, "nodesAsTextboxes.action.label"), 8){

                public void run() {
                    if (this.isChecked()) {
                        GraphAnalysisJob.this.graphModel.setUIStyle(0);
                        GraphAnalysisJob.this.status = 32;
                        GraphAnalysisJob.this.schedule();
                    }
                }
            };
            this.textBoxOnly.setEnabled(true);
            this.textBoxOnly.setImageDescriptor(Activator.getImageDescriptor("icons/astext.png"));
        }
        if (this.svgIcon == null) {
            this.svgIcon = new Action(Messages.getString(GraphAnalysisJob.class, "nodesAsDrawings.action.label"), 8){

                public void run() {
                    if (this.isChecked()) {
                        GraphAnalysisJob.this.graphModel.setUIStyle(2);
                        GraphAnalysisJob.this.status = 32;
                        GraphAnalysisJob.this.schedule();
                    }
                }
            };
            this.svgIcon.setEnabled(true);
            this.svgIcon.setChecked(true);
            this.svgIcon.setImageDescriptor(Activator.getImageDescriptor("icons/asimage.png"));
        }
    }

    protected void changeIconsActionsState(boolean state) {
        this.textBoxOnly.setEnabled(state);
        this.svgIcon.setEnabled(state);
    }

    protected void contributeIconEntries(List menus) {
        menus.add(new Separator());
        menus.add(new ActionContributionItem((IAction)this.textBoxOnly));
        menus.add(new ActionContributionItem((IAction)this.svgIcon));
    }

    @Override
    protected void clearBeforeLoadGraph() {
        if (this.gfi != null) {
            this.gfi.clearFilters(this.graphModel.getGraph());
        }
    }

    public static void createMetaEdges(TSEGraphManager graphManager) {
        LinkedList metaEdgeNodePairList = new LinkedList();
        LinkedList metaEdgesToRemove = new LinkedList();
        graphManager.checkMetaEdges(metaEdgeNodePairList, metaEdgesToRemove);
        LinkedList insertedMetaEdges = new LinkedList();
        graphManager.updateMetaEdges(metaEdgeNodePairList, metaEdgesToRemove, insertedMetaEdges);
    }

    public class CollapseAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        public TSENode toCollapseNode;
        public TSEOverviewComponent overview;

        public CollapseAction() {
            super(GraphAnalysisJob.this);
            this.overview = null;
        }

        @Override
        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(GraphAnalysisJob.class, "collapse.task.text"), -1);
            GraphAnalysisJob.this.canvas.addInvalidRegion((TSEObject)this.toCollapseNode);
            TSNestingManager.collapse((TSDNode)this.toCollapseNode);
            GraphAnalysisJob.createMetaEdges(GraphAnalysisJob.this.graphManager);
            GraphAnalysisJob.this.canvas.updateInvalidRegion(true);
            GraphAnalysisJob.this.canvas.requestFocus();
            if (this.overview != null) {
                this.overview.updateOverview();
            }
            monitor.done();
        }
    }

    public class CollapseAllAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public CollapseAllAction() {
            super(GraphAnalysisJob.this);
        }

        @Override
        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(GraphAnalysisJob.class, "collapse.task.text"), -1);
            GraphAnalysisJob.this.graphModel.getGraph().collapseAll();
            GraphAnalysisJob.createMetaEdges(GraphAnalysisJob.this.graphManager);
            List<TSCommand> cmds = GraphAnalysisJob.this.doLayout(GraphAnalysisJob.this.currentLayoutType);
            GraphAnalysisJob.this.transmitCommands(cmds);
            GraphAnalysisJob.this.canvas.requestFocus();
            monitor.done();
        }
    }

    private class CreateViewerRunnable
    implements Runnable {
        Composite composite;
        boolean disposed;

        private CreateViewerRunnable() {
        }

        @Override
        public void run() {
            GraphFlowViewer viewer = new GraphFlowViewer(this.composite);
            GraphAnalysisJob.this.graphInfo.setViewer(viewer);
            GraphAnalysisJob.this.canvas = viewer.getCanvas();
            if (this.disposed) {
                GraphAnalysisJob.this.graphManager.setMainDisplayGraph((TSDGraph)GraphAnalysisJob.this.graphModel.getGraph());
                GraphAnalysisJob.this.canvas.setGraphManager(GraphAnalysisJob.this.graphManager);
                ((TSEOverviewComponent)GraphAnalysisJob.this.graphInfo.getOverviewComponent()).setCanvas((TSBaseCanvasInterface)GraphAnalysisJob.this.canvas);
            }
        }
    }

    public class ExpandAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        private TSENode nodeToExpand;

        public ExpandAction() {
            super(GraphAnalysisJob.this);
        }

        @Override
        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(GraphAnalysisJob.class, "expand.task.text"), -1);
            boolean keepHidden = true;
            TSNestingManager.expand((TSDNode)this.nodeToExpand);
            TSEFoldingManager foldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)GraphAnalysisJob.this.graphManager);
            foldingManager.unfold((TSDNode)this.nodeToExpand, keepHidden);
            GraphAnalysisJob.createMetaEdges(GraphAnalysisJob.this.graphManager);
            TSCommand layout = GraphAnalysisJob.this.doLayout(1, (TSEGraph)this.nodeToExpand.getChildGraph());
            ((TSELayoutCommand)layout).setFitInCanvasAfterOperation(false);
            GraphAnalysisJob.this.transmitCommand(layout);
            GraphAnalysisJob.this.canvas.requestFocus();
            monitor.done();
        }

        public void setNodeToExpand(TSENode nodeToExpand) {
            this.nodeToExpand = nodeToExpand;
        }
    }

    public class ExpandAllAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public ExpandAllAction() {
            super(GraphAnalysisJob.this);
        }

        @Override
        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(GraphAnalysisJob.class, "expand.task.text"), -1);
            GraphAnalysisJob.this.graphModel.getGraph().expandAll();
            GraphAnalysisJob.createMetaEdges(GraphAnalysisJob.this.graphManager);
            List<TSCommand> cmds = GraphAnalysisJob.this.doLayout(GraphAnalysisJob.this.currentLayoutType);
            GraphAnalysisJob.this.transmitCommands(cmds);
            GraphAnalysisJob.this.canvas.requestFocus();
            monitor.done();
        }
    }

    class HideShowEdgeListener
    implements TSComplexityChangeListener {
        public void complexityChanged(TSComplexityChangeEvent event) {
            TSEEdge edge = (TSEEdge)event.getSource();
            TSDNode sourceNode = (TSDNode)edge.getSourceNode();
            TSDNode targetNode = (TSDNode)edge.getTargetNode();
            if (event.getType() == 128L) {
                if (!edge.isDiscarded()) {
                    GraphAnalysisJob.this.graphManager.getHidingManager();
                    if (!TSHidingManager.isHidden((TSGraphMember)sourceNode)) {
                        GraphAnalysisJob.this.graphManager.getHidingManager();
                        if (!TSHidingManager.isHidden((TSGraphMember)targetNode)) {
                            GraphAnalysisJob.this.showAllEdges.setEnabled(true);
                        }
                    }
                }
                if (GraphAnalysisJob.this.canvas.getGraph().numberOfEdges() + GraphAnalysisJob.this.canvas.getGraph().numberOfDisconnectedEdges() == 0) {
                    GraphAnalysisJob.this.hideAllEdges.setEnabled(false);
                }
            } else if (event.getType() == 512L) {
                GraphAnalysisJob.this.hideAllEdges.setEnabled(true);
                GraphAnalysisJob.this.graphManager.getHidingManager();
                if (!TSHidingManager.hasHiddenEdges((TSDGraph)GraphAnalysisJob.this.canvas.getGraph())) {
                    GraphAnalysisJob.this.showAllEdges.setEnabled(false);
                }
            }
        }
    }
}

