/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.job;

import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.protection.Registry;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.EZFitInCanvasCommand;
import com.ez.workspace.analysis.graph.gui.GraphFlowViewer;
import com.ez.workspace.analysis.graph.job.GraphTSJobAdapter;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.job.GraphTranslateJob;
import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.ui.Activator;
import com.ez.workspace.ui.internal.Messages;
import com.ez.workspace.utils.WorkspaceLogUtil;
import com.tomsawyer.canvas.TSBaseCanvasInterface;
import com.tomsawyer.canvas.TSViewportCanvas;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.TSInteractivePreferenceTailor;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.TSCommandInterface;
import com.tomsawyer.interactive.command.TSCommandListener;
import com.tomsawyer.interactive.command.editing.TSBaseLayoutWorker;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.command.editing.TSLayoutOperationCommand;
import com.tomsawyer.interactive.command.editing.TSSwingLayoutWorker;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolManager;
import com.tomsawyer.licensing.TSLicenseManager;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSCircularLayoutInputTailor;
import com.tomsawyer.service.layout.TSHierarchicalLayoutInputTailor;
import com.tomsawyer.service.layout.TSOrthogonalLayoutInputTailor;
import com.tomsawyer.service.layout.TSSymmetricLayoutInputTailor;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphAnalysisJob
extends GraphTSJobAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(AbstractGraphAnalysisJob.class);
    private static final String OPERATION_CANCELED = Messages.getString(AbstractGraphAnalysisJob.class, "operationCanceled.exception");
    protected GraphTSJobAdapter.ProgressAction hierarchical = null;
    protected GraphTSJobAdapter.ProgressAction circular = null;
    protected GraphTSJobAdapter.ProgressAction orthogonal = null;
    protected GraphTSJobAdapter.ProgressAction symmetric = null;
    protected int currentLayoutType = this.getDefaultLayout();
    protected AbstractAnalysisGraphModel graphModel;
    private String name;
    protected int hierarchicalDirection = 3;

    public AbstractGraphAnalysisJob(EZEntityID id) {
        super("");
        this.id = id;
        this.initialize(id);
        this.setUser(true);
        this.status = 2;
        TSLicenseManager.setUserName((String)System.getProperty("user.name"));
        TSLicenseManager.axSuzszgQomlyiri();
    }

    protected void initialize(EZEntityID id) {
        EZSegment sg = id.getSegment(AnalysisIDSegment.class);
        if (sg != null) {
            this.analysis = (AbstractAnalysis)((AnalysisIDSegment)sg).getAnalysis();
            this.name = this.analysis.getType().getName();
            this.setName(this.name);
        }
    }

    protected int getDefaultLayout() {
        return 1;
    }

    protected void initGraphDetails() {
        this.graphManager = this.graphModel.getGraphManager();
        if (this.analysis.getContextValue("projects") != null) {
            this.graphManager.setAttribute("projects", this.analysis.getContextValue("projects"));
        }
    }

    @Override
    public void buildComponents(Composite composite) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        boolean disposed = false;
        this.graphInfo.getViewer();
        if (this.graphInfo.getViewer() == null || disposed) {
            GraphFlowViewer viewer = new GraphFlowViewer(composite);
            this.graphInfo.setViewer(viewer);
            this.createCanvas();
            this.graphInfo.setCanvasComponent((Component)this.canvas);
            this.registerTools();
            this.makeGraphActions();
            this.createProcessGraphs();
            this.graphInfo.setToolBarItems(this.getToolBarItems());
            this.graphInfo.setMenuItems(this.getMenuItems());
            this.graphInfo.setCloseHook(this);
            this.graphInfo.setGlobalActionsContributions(this.getGlobalActions());
        }
        if (this.graphInfo.getOverviewComponent() == null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        L.debug("TSEOverviewComponent invokeAndWait");
                        AbstractGraphAnalysisJob.this.graphInfo.setOverviewComponent(new TSEOverviewComponent((TSBaseCanvasInterface)AbstractGraphAnalysisJob.this.canvas));
                    }
                });
            }
            catch (Throwable t) {
                L.warn("Could not create TSEOverviewComponent()", t);
            }
            L.debug("TSEOverviewComponent() created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IStatus run(IProgressMonitor pmonitor) {
        IStatus result = null;
        TSEGraph oldGraph = null;
        boolean noGraph = false;
        this.jobStartTime = System.currentTimeMillis();
        L.info("{} - start time: {}", (Object)this.analysis.getType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)500);
        try {
            if (this.canvas != null) {
                ((TSEOverviewComponent)this.graphInfo.getOverviewComponent()).setToolEnabled(false);
                if (this.status == 2) {
                    this.status = 4;
                    monitor.setTaskName(Messages.getString(AbstractGraphAnalysisJob.class, "prepareResult.task.text"));
                    if (this.beginJob((IProgressMonitor)monitor.newChild(20))) {
                        TSEGraph oGraph;
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                AbstractGraphAnalysisJob.this.graphManager.setMainDisplayGraph((TSDGraph)AbstractGraphAnalysisJob.this.processGraph);
                                AbstractGraphAnalysisJob.this.canvas.setGraphManager(AbstractGraphAnalysisJob.this.graphManager);
                                ((TSEOverviewComponent)AbstractGraphAnalysisJob.this.graphInfo.getOverviewComponent()).setCanvas((TSBaseCanvasInterface)AbstractGraphAnalysisJob.this.canvas);
                            }
                        });
                        Map map = this.graphModel.getOutForStructView();
                        this.graphInfo.setContentProviderInputTree(map);
                        L.debug("before compute analysis results");
                        if (this.shouldStop((IProgressMonitor)monitor)) {
                            throw new OperationCanceledException(OPERATION_CANCELED);
                        }
                        this.computeResults(this.graphModel, (IProgressMonitor)monitor.newChild(50));
                        L.debug("after compute analysis results");
                        if (this.shouldStop((IProgressMonitor)monitor)) {
                            throw new OperationCanceledException(OPERATION_CANCELED);
                        }
                        oldGraph = this.graphModel.getGraph();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                AbstractGraphAnalysisJob.this.graphManager.setMainDisplayGraph((TSDGraph)AbstractGraphAnalysisJob.this.processGraph);
                                AbstractGraphAnalysisJob.this.canvas.setGraphManager(AbstractGraphAnalysisJob.this.graphManager);
                                ((TSEOverviewComponent)AbstractGraphAnalysisJob.this.graphInfo.getOverviewComponent()).setCanvas((TSBaseCanvasInterface)AbstractGraphAnalysisJob.this.canvas);
                            }
                        });
                        L.debug("after refresh overview");
                        Map treeInput = this.graphModel.getOutForStructView();
                        this.graphInfo.setContentProviderInputTree(treeInput);
                        result = Status.OK_STATUS;
                        this.clearBeforeLoadGraph();
                        if (this.shouldStop((IProgressMonitor)monitor)) {
                            throw new OperationCanceledException(OPERATION_CANCELED);
                        }
                        L.debug("before load graph");
                        this.graphModel.loadGraph((IProgressMonitor)monitor.newChild(300));
                        L.debug("after load graph");
                        if (this.shouldStop((IProgressMonitor)monitor)) {
                            throw new OperationCanceledException(OPERATION_CANCELED);
                        }
                        oldGraph = oGraph = this.graphModel.getGraph();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                AbstractGraphAnalysisJob.this.graphManager.setMainDisplayGraph((TSDGraph)oGraph);
                                AbstractGraphAnalysisJob.this.canvas.setGraphManager(AbstractGraphAnalysisJob.this.graphManager);
                                ((TSEOverviewComponent)AbstractGraphAnalysisJob.this.graphInfo.getOverviewComponent()).setCanvas((TSBaseCanvasInterface)AbstractGraphAnalysisJob.this.canvas);
                            }
                        });
                        treeInput = this.graphModel.getOutForStructView();
                        this.graphInfo.setContentProviderInputTree(treeInput);
                    } else {
                        throw new OperationCanceledException(OPERATION_CANCELED);
                    }
                }
                if (this.shouldStop((IProgressMonitor)monitor)) {
                    throw new OperationCanceledException(OPERATION_CANCELED);
                }
                monitor.setWorkRemaining(40);
                if (this.status == 32) {
                    monitor.subTask(Messages.getString(AbstractGraphAnalysisJob.class, "updateGraphSettings.subtask.text"));
                    this.graphModel.updateDrawing();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            AbstractGraphAnalysisJob.this.canvas.setGraphManager(AbstractGraphAnalysisJob.this.graphManager);
                            ((TSEOverviewComponent)AbstractGraphAnalysisJob.this.graphInfo.getOverviewComponent()).setCanvas((TSBaseCanvasInterface)AbstractGraphAnalysisJob.this.canvas);
                        }
                    });
                    result = Status.OK_STATUS;
                }
                if (this.shouldStop((IProgressMonitor)monitor)) {
                    throw new OperationCanceledException(OPERATION_CANCELED);
                }
                monitor.worked(10);
                TSEGraph tgraph = null;
                if (result == Status.OK_STATUS) {
                    result = Status.OK_STATUS;
                    this.status = 8;
                    tgraph = this.graphModel.getGraph();
                } else if (result == Status.CANCEL_STATUS) {
                    this.status = 2;
                    if (this.graphInfo != null) {
                        this.graphInfo.setDirty(DirtyStatus.BUILT_REQUIRE_REFRESH);
                    }
                    if (this.graphManager != null) {
                        if (oldGraph != null) {
                            this.graphModel.setGraph(oldGraph);
                            tgraph = oldGraph;
                        } else {
                            tgraph = noGraph ? this.graphNotAvailable : this.processCanceled;
                        }
                    }
                }
                final TSEGraph ttGraph = tgraph;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AbstractGraphAnalysisJob.this.graphManager.setMainDisplayGraph((TSDGraph)ttGraph);
                        AbstractGraphAnalysisJob.this.canvas.setGraphManager(AbstractGraphAnalysisJob.this.graphManager);
                        ((TSEOverviewComponent)AbstractGraphAnalysisJob.this.graphInfo.getOverviewComponent()).setCanvas((TSBaseCanvasInterface)AbstractGraphAnalysisJob.this.canvas);
                    }
                });
                if (this.shouldStop((IProgressMonitor)monitor)) {
                    throw new OperationCanceledException(OPERATION_CANCELED);
                }
                final boolean[] wait = new boolean[]{this.status == 8};
                TSCommandListener cl = new TSCommandListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public int listen(TSCommandInterface arg0) {
                        L.trace("command listener: {} state: {}", (Object)arg0, (Object)arg0.getState().toString());
                        if (!arg0.getState().toString().equals("done")) return 0;
                        boolean[] blArray = wait;
                        synchronized (wait) {
                            L.trace("mark wait[0]=true");
                            wait[0] = true;
                            wait.notifyAll();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return 0;
                        }
                    }
                };
                this.canvas.getCommandManager().addCommandListener(cl);
                result = this.finalTSGraphOperations((IProgressMonitor)monitor.newChild(20), result);
                if (this.shouldStop((IProgressMonitor)monitor)) {
                    throw new OperationCanceledException(OPERATION_CANCELED);
                }
                this.wait4Finish();
                boolean[] blArray = wait;
                synchronized (wait) {
                    if (!wait[0]) {
                        wait.wait();
                    }
                    long startTime = 0L;
                    long timeout = 10000L;
                    while (this.canvas != null && this.canvas.isInRunMode()) {
                        L.trace("waiting for canvas.isOperationInProgress");
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        if (monitor.isCanceled()) {
                            this.canvas.cancelAction();
                            this.canvas.cancelLayout();
                            startTime = System.currentTimeMillis();
                        }
                        if (System.currentTimeMillis() - startTime <= timeout) continue;
                        L.info("tired to wait for layout");
                        break;
                    }
                    // ** MonitorExit[var10_12] (shouldn't be in output)
                    if (this.canvas != null) {
                        this.canvas.getCommandManager().removeCommandListener(cl);
                    }
                    if (this.shouldStop((IProgressMonitor)monitor)) {
                        throw new OperationCanceledException(OPERATION_CANCELED);
                    }
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (AbstractGraphAnalysisJob.this.graphManager != null && AbstractGraphAnalysisJob.this.graphModel != null) {
                                AbstractGraphAnalysisJob.this.graphManager.setMainDisplayGraph((TSDGraph)AbstractGraphAnalysisJob.this.graphModel.getGraph());
                                AbstractGraphAnalysisJob.this.canvas.setGraphManager(AbstractGraphAnalysisJob.this.graphManager);
                            }
                            if (AbstractGraphAnalysisJob.this.graphInfo != null) {
                                ((TSEOverviewComponent)AbstractGraphAnalysisJob.this.graphInfo.getOverviewComponent()).setCanvas((TSBaseCanvasInterface)AbstractGraphAnalysisJob.this.canvas);
                            }
                        }
                    });
                    TSToolManager toolManager = this.canvas.getToolManager();
                    toolManager.switchTool(this.currentTool);
                    boolean state = result == Status.OK_STATUS;
                    this.changeActionsState(state);
                    monitor.worked(10);
                }
            } else {
                result = Status.CANCEL_STATUS;
            }
            {
                if (result == Status.CANCEL_STATUS) {
                    if (this.wasDenied) {
                        this.analysis.analysisDenied(null);
                    }
                } else if (this.analysis != null) {
                    this.analysis.jobFinished(null);
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            this.status = 2;
            if (this.wasDenied && this.analysis != null) {
                this.analysis.analysisDenied(null);
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AbstractGraphAnalysisJob.this.graphManager.setMainDisplayGraph((TSDGraph)AbstractGraphAnalysisJob.this.processCanceled);
                        if (AbstractGraphAnalysisJob.this.canvas != null) {
                            AbstractGraphAnalysisJob.this.canvas.setGraphManager(AbstractGraphAnalysisJob.this.graphManager);
                        }
                        if (AbstractGraphAnalysisJob.this.graphInfo != null) {
                            ((TSEOverviewComponent)AbstractGraphAnalysisJob.this.graphInfo.getOverviewComponent()).setCanvas((TSBaseCanvasInterface)AbstractGraphAnalysisJob.this.canvas);
                            ((TSEOverviewComponent)AbstractGraphAnalysisJob.this.graphInfo.getOverviewComponent()).updateOverview();
                        }
                    }
                });
            }
            catch (Throwable t) {
                L.warn("could not set graphManager", t);
            }
            WorkspaceLogUtil.info((String)Messages.getString(AbstractGraphAnalysisJob.class, "errorlog.infoMessage.analysisCanceled"));
            L.debug("operation was canceled");
            result = Status.CANCEL_STATUS;
        }
        catch (Throwable t) {
            this.status = 2;
            LogUtil.displayErrorMessage((Throwable)t, (String)Messages.getString(AbstractGraphAnalysisJob.class, "errorwhileGraph.errorLog.message"), (Plugin)Activator.getDefault(), (boolean)true);
            L.error("error while generating graph", t);
            result = Status.CANCEL_STATUS;
        }
        return result;
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        if (result != null && this.graphManager != null) {
            monitor.subTask(Messages.getString(AbstractGraphAnalysisJob.class, "layout.subtask.text"));
            if (this.shouldStop(monitor)) {
                throw new OperationCanceledException(OPERATION_CANCELED);
            }
            Map treeInput = this.graphModel.getOutForStructView();
            this.graphInfo.setContentProviderInputTree(treeInput);
            boolean doLayoutDecision = true;
            String message = this.graphModel.getMsgForLayoutDecision();
            if (message != null) {
                LayoutDecisionMessage msgRunn = new LayoutDecisionMessage(message);
                Display.getDefault().syncExec((Runnable)msgRunn);
                doLayoutDecision = msgRunn.getDoLayoutDecision();
            }
            if (doLayoutDecision) {
                List<TSCommand> layCmds = this.doLayout(this.currentLayoutType);
                EZFitInCanvasCommand fit = new EZFitInCanvasCommand(this.canvas);
                ArrayList<TSCommand> cmds = new ArrayList<TSCommand>();
                cmds.addAll(layCmds);
                cmds.add(fit);
                this.transmitCommands(cmds, false);
            } else {
                result = Status.CANCEL_STATUS;
            }
        } else {
            result = Status.OK_STATUS;
            this.changeActionsState(true);
        }
        if (this.reload != null) {
            this.reload.setEnabled(true);
        }
        if (this.graphInfo != null) {
            ((TSEOverviewComponent)this.graphInfo.getOverviewComponent()).setToolEnabled(true);
        }
        return result;
    }

    protected void wait4Finish() {
    }

    protected abstract void clearBeforeLoadGraph();

    protected abstract void computeResults(AbstractAnalysisGraphModel var1, IProgressMonitor var2);

    public void init() {
        String className = this.analysis.getClass().getName();
        Registry reg = Registry.getInstance();
        boolean enabled = reg.check(className);
        PlatformUI.getPreferenceStore().firePropertyChangeEvent("action", (Object)new Boolean(false), (Object)new Boolean(enabled));
        if (enabled) {
            this.scheduleJob();
        }
    }

    @Override
    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        if (this.hierarchical != null) {
            this.hierarchical.setEnabled(state);
        }
        if (this.circular != null) {
            this.circular.setEnabled(state);
        }
        if (this.orthogonal != null) {
            this.orthogonal.setEnabled(state);
        }
        if (this.symmetric != null) {
            this.symmetric.setEnabled(state);
        }
    }

    @Override
    public void makeGraphActions() {
        super.makeGraphActions();
        int dl = this.getDefaultLayout();
        this.hierarchical = new GraphTSJobAdapter.ProgressAction(this, Messages.getString(AbstractGraphAnalysisJob.class, "hierarchicalLay.action.text"), 8){

            @Override
            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString(AbstractGraphAnalysisJob.class, "hierarchicalLay.task.text"), -1);
                List<TSCommand> cmds = AbstractGraphAnalysisJob.this.doLayout(1);
                AbstractGraphAnalysisJob.this.transmitCommands(cmds);
                AbstractGraphAnalysisJob.this.currentLayoutType = 1;
                monitor.done();
            }
        };
        if (dl == 1) {
            this.hierarchical.setChecked(true);
        } else {
            this.hierarchical.setChecked(false);
        }
        this.hierarchical.setToolTipText(Messages.getString(AbstractGraphAnalysisJob.class, "hierarchicalLay.action.tooltip"));
        ImageDescriptor id = Activator.getImageDescriptor("icons//hierarchical.gif");
        this.hierarchical.setImageDescriptor(id);
        this.circular = new GraphTSJobAdapter.ProgressAction(this, Messages.getString(AbstractGraphAnalysisJob.class, "circularLay.action.text"), 8){

            @Override
            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString(AbstractGraphAnalysisJob.class, "circularLay.task.text"), -1);
                List<TSCommand> cmds = AbstractGraphAnalysisJob.this.doLayout(2);
                AbstractGraphAnalysisJob.this.transmitCommands(cmds);
                AbstractGraphAnalysisJob.this.currentLayoutType = 2;
                monitor.done();
            }
        };
        if (dl == 2) {
            this.circular.setChecked(true);
        } else {
            this.circular.setChecked(false);
        }
        this.circular.setToolTipText(Messages.getString(AbstractGraphAnalysisJob.class, "circularLay.action.tooltip"));
        id = Activator.getImageDescriptor("icons//circular.gif");
        this.circular.setImageDescriptor(id);
        this.orthogonal = new GraphTSJobAdapter.ProgressAction(this, Messages.getString(AbstractGraphAnalysisJob.class, "orthogLay.action.text"), 8){

            @Override
            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString(AbstractGraphAnalysisJob.class, "orthogLay.task.text"), -1);
                List<TSCommand> cmds = AbstractGraphAnalysisJob.this.doLayout(3);
                AbstractGraphAnalysisJob.this.transmitCommands(cmds);
                AbstractGraphAnalysisJob.this.currentLayoutType = 3;
                monitor.done();
            }
        };
        if (dl == 3) {
            this.orthogonal.setChecked(true);
        } else {
            this.orthogonal.setChecked(false);
        }
        this.orthogonal.setToolTipText(Messages.getString(AbstractGraphAnalysisJob.class, "orthogLay.action.tooltip"));
        id = Activator.getImageDescriptor("icons//orthogonal.gif");
        this.orthogonal.setImageDescriptor(id);
        this.symmetric = new GraphTSJobAdapter.ProgressAction(this, Messages.getString(AbstractGraphAnalysisJob.class, "symetricLay.action.text"), 8){

            @Override
            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString(AbstractGraphAnalysisJob.class, "symetricLay.task.text"), -1);
                List<TSCommand> cmds = AbstractGraphAnalysisJob.this.doLayout(4);
                AbstractGraphAnalysisJob.this.transmitCommands(cmds);
                AbstractGraphAnalysisJob.this.currentLayoutType = 4;
                monitor.done();
            }
        };
        if (dl == 4) {
            this.symmetric.setChecked(true);
        } else {
            this.symmetric.setChecked(false);
        }
        this.symmetric.setToolTipText(Messages.getString(AbstractGraphAnalysisJob.class, "symetricLay.action.tooltip"));
        id = Activator.getImageDescriptor("icons//symmetric.gif");
        this.symmetric.setImageDescriptor(id);
    }

    @Override
    public List getMenuItems() {
        List defaultItems = super.getMenuItems();
        defaultItems.add(new Separator());
        defaultItems.add(new ActionContributionItem((IAction)this.hierarchical));
        defaultItems.add(new ActionContributionItem((IAction)this.symmetric));
        defaultItems.add(new ActionContributionItem((IAction)this.circular));
        defaultItems.add(new ActionContributionItem((IAction)this.orthogonal));
        return defaultItems;
    }

    @Override
    public List getToolBarItems() {
        List defaultItems = super.getToolBarItems();
        defaultItems.add(new Separator());
        defaultItems.add(new ActionContributionItem((IAction)this.hierarchical));
        defaultItems.add(new ActionContributionItem((IAction)this.symmetric));
        defaultItems.add(new ActionContributionItem((IAction)this.circular));
        defaultItems.add(new ActionContributionItem((IAction)this.orthogonal));
        return defaultItems;
    }

    @Override
    protected List<TSCommand> doLayout(int type) {
        ArrayList<TSCommand> cmds = new ArrayList<TSCommand>();
        int nodesTotalCount = 0;
        int edgesTotalCount = 0;
        for (TSEGraph graph : this.graphModel.getGraphs()) {
            nodesTotalCount += graph.numberOfNodes();
            edgesTotalCount += graph.numberOfEdges();
            L.debug("(sub)graph nodes count: {}", (Object)graph.numberOfNodes());
            L.debug("(sub)graph edges count: {}", (Object)graph.numberOfEdges());
            TSCommand command = this.doLayout(type, graph);
            if (command == null) continue;
            cmds.add(command);
        }
        L.debug("intergraph edges count: {}", (Object)this.graphManager.numberOfIntergraphEdges());
        L.debug("total nodes count: {}", (Object)nodesTotalCount);
        L.debug("total edges count: {}", (Object)(edgesTotalCount + this.graphManager.numberOfIntergraphEdges()));
        return cmds;
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSELayoutCommand layoutCommand = null;
        TSServiceInputData inputData = ((AnalysisGraphManager)this.graphManager).inputData;
        TSInteractivePreferenceTailor layoutPreferenceTailor = new TSInteractivePreferenceTailor(this.canvas.getPreferenceData());
        layoutPreferenceTailor.setThreadedLayout(true);
        layoutPreferenceTailor.setShowLayoutProgress(false);
        switch (type) {
            case 1: {
                TSHierarchicalLayoutInputTailor hierarchicalLayoutTailor = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData);
                hierarchicalLayoutTailor.setGraph((TSDGraph)graph);
                hierarchicalLayoutTailor.setLevelDirection(this.hierarchicalDirection);
                hierarchicalLayoutTailor.setLevelAlignment(1);
                hierarchicalLayoutTailor.setOrthogonalRouting(false);
                hierarchicalLayoutTailor.setKeepNodeSizes(true);
                hierarchicalLayoutTailor.setConstantHorizontalSpacingBetweenNodes(40.0);
                hierarchicalLayoutTailor.setConstantVerticalSpacingBetweenNodes(40.0);
                hierarchicalLayoutTailor.setHorizontalSpacingBetweenEdges(10.0);
                hierarchicalLayoutTailor.setVerticalSpacingBetweenEdges(10.0);
                hierarchicalLayoutTailor.setKeepNodeSizes(true);
                hierarchicalLayoutTailor.setVariableLevelSpacing(false);
                this.graphModel.setOptions(hierarchicalLayoutTailor);
                layoutCommand = new TSELayoutCommand(graph, (TSViewportCanvas)this.canvas, (TSServiceInputDataInterface)inputData, 1){

                    protected TSBaseLayoutWorker createLayoutWorker() {
                        return new TSSwingLayoutWorker((TSLayoutOperationCommand)this){

                            public void processEventsAfterLayout() {
                                L.debug("nothing to process after layout");
                            }
                        };
                    }
                };
                layoutCommand.setCoalesced(true);
                break;
            }
            case 2: {
                TSCircularLayoutInputTailor circularLayoutTailor = new TSCircularLayoutInputTailor((TSServiceInputDataInterface)inputData);
                circularLayoutTailor.setGraph((TSDGraph)graph);
                circularLayoutTailor.setAsCurrentLayoutStyle();
                layoutCommand = new TSELayoutCommand(graph, (TSViewportCanvas)this.canvas, (TSServiceInputDataInterface)inputData, 4){

                    protected TSBaseLayoutWorker createLayoutWorker() {
                        return new TSSwingLayoutWorker((TSLayoutOperationCommand)this){

                            public void processEventsAfterLayout() {
                                L.debug("nothing to process after layout");
                            }
                        };
                    }
                };
                layoutCommand.setCoalesced(true);
                break;
            }
            case 4: {
                TSSymmetricLayoutInputTailor symmetricLayoutTailor = new TSSymmetricLayoutInputTailor((TSServiceInputDataInterface)inputData);
                symmetricLayoutTailor.setGraph((TSDGraph)graph);
                symmetricLayoutTailor.setAsCurrentLayoutStyle();
                symmetricLayoutTailor.setNodeSpacing(1.0);
                symmetricLayoutTailor.setDetectComponents(false);
                layoutCommand = new TSELayoutCommand(graph, (TSViewportCanvas)this.canvas, (TSServiceInputDataInterface)inputData, 3){

                    protected TSBaseLayoutWorker createLayoutWorker() {
                        return new TSSwingLayoutWorker((TSLayoutOperationCommand)this){

                            public void processEventsAfterLayout() {
                                L.debug("nothing to process after layout");
                            }
                        };
                    }
                };
                layoutCommand.setCoalesced(true);
                break;
            }
            case 3: {
                TSOrthogonalLayoutInputTailor orthogonalLayoutTailor = new TSOrthogonalLayoutInputTailor((TSServiceInputDataInterface)inputData);
                orthogonalLayoutTailor.setGraph((TSDGraph)graph);
                orthogonalLayoutTailor.setAsCurrentLayoutStyle();
                orthogonalLayoutTailor.setKeepNodeSizes(true);
                layoutCommand = new TSELayoutCommand(graph, (TSViewportCanvas)this.canvas, (TSServiceInputDataInterface)inputData, 2){

                    protected TSBaseLayoutWorker createLayoutWorker() {
                        return new TSSwingLayoutWorker((TSLayoutOperationCommand)this){

                            public void processEventsAfterLayout() {
                                L.debug("nothing to process after layout");
                            }
                        };
                    }
                };
                layoutCommand.setCoalesced(true);
                break;
            }
            default: {
                L.warn("unknown layout change ");
            }
        }
        return layoutCommand;
    }

    @Override
    public TSCommand getFitCommand() {
        return new EZFitInCanvasCommand(this.canvas);
    }

    @Override
    public void closing() {
        EZWorkspace ws = EZWorkspace.getInstance();
        ws.removeJob(this.id, ((Object)((Object)this)).getClass(), (GraphTranslateJob)this);
        this.circular = null;
        this.hierarchical = null;
        this.orthogonal = null;
        this.symmetric = null;
        this.graphModel.dispose();
        this.graphModel = null;
        this.analysis = null;
        super.closing();
    }

    @Deprecated
    protected IProgressMonitor isCanceled(IProgressMonitor monitor) {
        return monitor;
    }

    protected boolean shouldStop(IProgressMonitor monitor) {
        return monitor.isCanceled();
    }

    private class LayoutDecisionMessage
    implements Runnable {
        private boolean doLayoutDecision;
        private String message;

        public LayoutDecisionMessage(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            Shell parent = Display.getDefault().getActiveShell();
            String title = Messages.getString(AbstractGraphAnalysisJob.class, "graph.exceed.title");
            MessageDialog dialog = new MessageDialog(parent, title, null, this.message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.doLayoutDecision = dialog.open() == 0;
        }

        public boolean getDoLayoutDecision() {
            return this.doLayoutDecision;
        }
    }
}

