/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.gui;

import com.ez.common.ui.ImageDescriptorProvider;
import com.ez.internal.utils.Pair;
import com.ez.workspace.analysis.graph.model.GraphFilter;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import java.awt.SystemColor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class LegendPanel
extends Composite {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Map<String, Pair<Image, Cursor>> imageMap = new HashMap<String, Pair<Image, Cursor>>();
    private static final int COLUMNS = 3;
    private ImageDescriptorProvider idProvider;
    private GraphFilterInfo filterInfo = null;

    public LegendPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
    }

    public void setImageDescriptorProvider(ImageDescriptorProvider idProvider) {
        this.idProvider = idProvider;
    }

    private Image getImage(String image, Cursor cursor) {
        Image img = null;
        if (this.imageMap.containsKey(image)) {
            Pair<Image, Cursor> pair = this.imageMap.get(image);
            img = (Image)pair.getFirst();
            if (cursor != null) {
                pair.setSecond((Object)cursor);
            }
        } else {
            img = this.idProvider.getImageDescriptor(image).createImage();
            this.imageMap.put(image, (Pair<Image, Cursor>)new Pair((Object)img, (Object)cursor));
        }
        return img;
    }

    public void placeLegendEntry(Class nodeType, String image, String text) {
        this.placeVSeparator();
        Button img = new Button((Composite)this, 2);
        img.setImage(this.getImage(image, null));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        img.setLayoutData((Object)gridData);
        GraphFilter gf = new GraphFilter();
        gf.type = nodeType;
        img.setData((Object)gf);
        Label l = new Label((Composite)this, 0);
        l.setText(text);
        this.placeHSeparator();
        ImageSelectionAdapter selectionAdapter = new ImageSelectionAdapter(l);
        img.addSelectionListener((SelectionListener)selectionAdapter);
        boolean isSelected = !this.filterInfo.getSelection(gf);
        img.setSelection(isSelected);
        final String textCopy = text;
        img.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = textCopy;
            }
        });
        this.setControlBacgroundIfHighContrastEnabled((Control)img);
        if (isSelected) {
            SystemColor disabledTextColor = SystemColor.textInactiveText;
            l.setForeground(new Color((Device)this.getDisplay(), disabledTextColor.getRed(), disabledTextColor.getGreen(), disabledTextColor.getBlue()));
        } else {
            l.setForeground(Display.getCurrent().getSystemColor(21));
        }
    }

    public void setFilters(GraphFilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void placeLegendEntry(String image, String text) {
        this.placeVSeparator();
        ImageHyperlink imgH = new ImageHyperlink((Composite)this, 8);
        Cursor cursor = new Cursor((Device)this.getDisplay(), 0);
        Image img = this.getImage(image, cursor);
        imgH.setImage(img);
        imgH.setCursor(cursor);
        final String textCopy = text;
        imgH.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = textCopy;
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        imgH.setLayoutData((Object)gridData);
        this.setControlBacgroundIfHighContrastEnabled((Control)imgH);
        Label l = new Label((Composite)this, 0);
        l.setText(text);
        this.placeHSeparator();
    }

    private void placeVSeparator() {
        Label separator = new Label((Composite)this, 514);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        separator.setLayoutData((Object)gridData);
    }

    private void placeHSeparator() {
        Label separator = new Label((Composite)this, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        separator.setLayoutData((Object)gridData);
    }

    public void dispose() {
        for (Pair<Image, Cursor> pair : this.imageMap.values()) {
            Image img = (Image)pair.getFirst();
            img.dispose();
            Cursor cursor = (Cursor)pair.getSecond();
            if (cursor == null) continue;
            cursor.dispose();
        }
        this.imageMap.clear();
        super.dispose();
    }

    public void refreshButtonsAndLbls() {
        Control[] ctrls = this.getChildren();
        if (ctrls == null) {
            return;
        }
        int i = 0;
        while (i < ctrls.length) {
            if (ctrls[i] instanceof Button) {
                ((Button)ctrls[i]).setSelection(false);
            } else if (ctrls[i] instanceof Label) {
                ctrls[i].setForeground(Display.getCurrent().getSystemColor(21));
            }
            ++i;
        }
    }

    private void setControlBacgroundIfHighContrastEnabled(Control element) {
        Color blackColor;
        Color backgroundColor = Display.getCurrent().getSystemColor(22);
        if (backgroundColor.equals((Object)(blackColor = Display.getCurrent().getSystemColor(2)))) {
            element.setBackground(new Color((Device)this.getDisplay(), 255, 255, 255));
        }
    }

    private class ImageSelectionAdapter
    extends SelectionAdapter {
        private Label l;

        public ImageSelectionAdapter(Label l) {
            this.l = l;
        }

        public void widgetSelected(SelectionEvent e) {
            GraphFilter gf = (GraphFilter)((Button)e.getSource()).getData();
            boolean isSelected = ((Button)e.getSource()).getSelection();
            LegendPanel.this.filterInfo.selectionChanged(gf, !isSelected);
            if (isSelected) {
                SystemColor disabledTextColor = SystemColor.textInactiveText;
                this.l.setForeground(new Color((Device)LegendPanel.this.getDisplay(), disabledTextColor.getRed(), disabledTextColor.getGreen(), disabledTextColor.getBlue()));
            } else {
                this.l.setForeground(Display.getCurrent().getSystemColor(21));
            }
        }
    }
}

