/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.gui;

import com.ez.workspace.analysis.graph.gui.PathComparator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Group
implements Comparable<Group> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static final PathComparator pathComparator = new PathComparator();
    String direction;
    static final String EMPTY_STRING = "";
    public String prgName;
    public int index = 0;
    public List<LinkedList<String>> rows = new ArrayList<LinkedList<String>>();

    public Group(int direction) {
        this.direction = direction == 0 ? "->" : "<-";
    }

    public String getRowAsString() {
        LinkedList<String> oldRow = null;
        String root = this.prgName;
        StringBuilder buf = new StringBuilder();
        LinkedList<String> row = this.getRow();
        if (this.index != 0) {
            oldRow = this.rows.get(this.index - 1);
            root = EMPTY_STRING;
        }
        String pName = root;
        buf.append(pName);
        int idx = this.commonChain(row, oldRow);
        int i = 1;
        while (i < row.size()) {
            pName = row.get(i);
            if (idx != -1 && idx >= i) {
                pName = EMPTY_STRING;
            }
            buf.append(";" + (pName.equals(EMPTY_STRING) ? EMPTY_STRING : this.direction) + ";").append(pName);
            ++i;
        }
        String s = buf.toString();
        return s;
    }

    LinkedList<String> getRow() {
        return this.rows.get(this.index);
    }

    boolean subchain(LinkedList<String> row1, LinkedList<String> row2) {
        boolean ret = false;
        if (row1 == null || row2 == null) {
            ret = false;
        } else {
            ret = true;
            int i = 0;
            while (i < row1.size()) {
                if (row1.get(i) != null && !row1.get(i).equals(row2.get(i))) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    int commonChain(LinkedList<String> row1, LinkedList<String> row2) {
        int idx = -1;
        if (row1 != null && row2 != null) {
            int i = 0;
            while (i < row1.size()) {
                if (row1.get(i) == null || !row1.get(i).equals(row2.get(i))) break;
                idx = i++;
            }
        }
        return idx;
    }

    public void clear() {
        this.rows.clear();
        this.rows = null;
    }

    @Override
    public int compareTo(Group o) {
        return this.prgName.compareTo(o.prgName);
    }
}

