/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.gui;

import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.AbstractExportManager;
import com.ez.workspace.analysis.graph.gui.EZExportGraphUtils;
import com.ez.workspace.ui.internal.Messages;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportAsCSV
extends AbstractExportManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    JTextField fileText = null;

    @Override
    public String getActionKey() {
        return "exp_csv";
    }

    @Override
    public String[] getGroupSelectorDetails() {
        return new String[]{Messages.getString(ExportAsCSV.class, "exportAsCsv"), this.getActionKey(), "C"};
    }

    @Override
    public void createPanel(Font font, int width) {
        this.panel = this.createCSVPanel(font, width);
    }

    private JPanel createCSVPanel(Font font, int width) {
        JPanel localJPanelCSV = new JPanel();
        this.createBorder(localJPanelCSV, "", 0, 6, 5, 5, font);
        localJPanelCSV.setLayout(new BoxLayout(localJPanelCSV, 1));
        JLabel localJLabel2 = this.createLabel("File_Name:", font);
        this.fileText = new JTextField();
        String path = String.valueOf(System.getProperty("user.home")) + File.separator + "Untitled.csv";
        this.fileText.setText(path);
        this.fileText.setPreferredSize(new Dimension(width, (int)this.fileText.getPreferredSize().getHeight()));
        this.fileText.setMaximumSize(this.fileText.getPreferredSize());
        localJLabel2.setDisplayedMnemonic('f');
        localJLabel2.setLabelFor(this.fileText);
        JButton localJButton = this.createButton(Messages.getString(ExportAsCSV.class, "browse.button"), "browse", 'b');
        localJButton.setFont(font);
        localJButton.setMaximumSize(new Dimension(40, 35));
        JPanel localJPanel6 = new JPanel();
        localJPanel6.setLayout(new BoxLayout(localJPanel6, 0));
        localJLabel2.setAlignmentY(0.5f);
        this.fileText.setAlignmentY(0.5f);
        localJButton.setAlignmentY(0.5f);
        localJPanel6.add(localJLabel2);
        localJPanel6.add(Box.createRigidArea(new Dimension(9, 0)));
        localJPanel6.add(this.fileText);
        localJPanel6.add(Box.createRigidArea(new Dimension(9, 0)));
        localJPanel6.add(Box.createHorizontalGlue());
        localJPanel6.add(localJButton);
        localJPanel6.setAlignmentX(0.0f);
        localJPanelCSV.add(Box.createRigidArea(new Dimension(0, 5)));
        localJPanelCSV.add(localJPanel6);
        return localJPanelCSV;
    }

    @Override
    public String getFileName() {
        return this.fileText.getText();
    }

    @Override
    public void setFileName(String fName) {
        this.fileText.setText(fName);
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileNameExtensionFilter(Messages.getString(ExportAsCSV.class, "extensionFilter.text"), "csv");
    }

    @Override
    public boolean doExport(AnalysisGraphManager graphMngr) {
        return this.generateCSVFile(graphMngr);
    }

    private boolean generateCSVFile(AnalysisGraphManager graphMngr) {
        boolean isExportOk = true;
        TSEGraph graph = (TSEGraph)graphMngr.getMainDisplayGraph();
        if (graph != null) {
            List nodes = graph.nodes();
            isExportOk = graphMngr.getAttributeValue("IS_CROSS_ANALYSIS_GRAPH") != null ? (graphMngr.hasAttribute("isCrossSrv") ? EZExportGraphUtils.generateCSVFileForCrossSrvMainframe(this.getFileName(), graphMngr) : EZExportGraphUtils.generateCSVFileForCrossMainframe(this.getFileName(), graphMngr)) : EZExportGraphUtils.generateCSVFileForPrgCg(this.getFileName(), graphMngr, nodes);
        }
        return isExportOk;
    }
}

