/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.gui;

import com.tomsawyer.drawing.geometry.shared.TSConstRect;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import java.util.List;

public class EZFitInCanvasCommand
extends TSCommand {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private TSSwingCanvas canvas = null;
    private TSENode node = null;
    private List parents = null;

    public EZFitInCanvasCommand(TSSwingCanvas canvas) {
        this.canvas = canvas;
    }

    protected void doAction() throws Throwable {
        if (this.node == null) {
            this.canvas.fitInCanvas(true);
        } else {
            TSConstRect rect = null;
            rect = this.parents != null ? this.findSurrounding(this.parents, this.node) : this.findSurrounding(this.node.getOwnerGraph().nodes(), this.node);
            this.canvas.fitRectInCanvas(rect, true);
        }
    }

    public void setNode(TSENode node) {
        this.node = node;
    }

    public void setParents(List parents) {
        this.parents = parents;
    }

    private TSConstRect findSurrounding(List nodes, TSENode node) {
        TSConstRect bounds = null;
        bounds = node.getBounds();
        double xlt = bounds.getLeft();
        double ylt = bounds.getTop();
        double xbr = bounds.getRight();
        double ybr = bounds.getBottom();
        if (nodes != null) {
            for (TSENode n : nodes) {
                bounds = n.getBounds();
                if (xlt > bounds.getLeft()) {
                    xlt = bounds.getLeft();
                }
                if (ylt < bounds.getTop()) {
                    ylt = bounds.getTop();
                }
                if (xbr < bounds.getRight()) {
                    xbr = bounds.getRight();
                }
                if (!(ybr > bounds.getBottom())) continue;
                ybr = bounds.getBottom();
            }
        }
        TSConstRect ret = new TSConstRect(xlt, ylt, xbr, ybr);
        return ret;
    }
}

