/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.gui;

import com.ez.internal.utils.CSVWriter;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.EZExportGraphDialog;
import com.ez.workspace.analysis.graph.gui.Group;
import com.ez.workspace.ui.internal.Messages;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZExportGraphUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZExportGraphUtils.class);

    protected static boolean generateCSVFileForPrgCg(String exportFile, AnalysisGraphManager graphMngr, List<TSENode> nodes) {
        ArrayList<TSENode> startNodes = new ArrayList<TSENode>();
        ArrayList<String> startNames = new ArrayList<String>();
        for (TSENode node : nodes) {
            boolean isStartNode;
            boolean bl = isStartNode = node.getAttributeValue("node is input for callgraph") != null;
            if (!isStartNode) continue;
            startNodes.add(node);
            startNames.add(node.getText());
        }
        int graphDirection = (Integer)graphMngr.getAttributeValue("graph direction");
        Integer graphLimitation = (Integer)graphMngr.getAttributeValue("graph limitation");
        ArrayList<Group> allGroups = new ArrayList<Group>();
        int maxLevel = 0;
        for (TSENode startNode : startNodes) {
            Group group = new Group(graphDirection);
            group.prgName = startNode.getText();
            allGroups.add(group);
            LinkedList<String> chain = new LinkedList<String>();
            chain.add(startNode.getText());
            maxLevel = EZExportGraphUtils.dfs(startNode, chain, graphDirection, group, maxLevel, false);
            if (maxLevel != 0) continue;
            chain.add(startNode.getText());
            group.rows.add(new LinkedList<String>(chain));
        }
        Collections.sort(allGroups);
        Collections.sort(startNames);
        String prjName = (String)graphMngr.getAttributeValue("mainframe project name");
        boolean isExportOk = EZExportGraphUtils.printGroupsToCSV(exportFile, allGroups, startNames, prjName, graphDirection, maxLevel, graphLimitation, new Boolean[0]);
        return isExportOk;
    }

    private static int dfs(TSENode startNode, LinkedList<String> chain, int graphDirection, Group group, int maxLevel, boolean withPrjInfo) {
        String prjName;
        List edges;
        List list = edges = graphDirection == 0 ? startNode.buildOutEdges() : startNode.buildInEdges();
        if (edges != null && !edges.isEmpty()) {
            for (TSEEdge edge : edges) {
                String prjName2;
                TSENode child = graphDirection == 0 ? (TSENode)edge.getTargetNode() : (TSENode)edge.getSourceNode();
                boolean isPrgNode = child.getAttributeValue("program_type") != null;
                Object resType = child.getAttributeValue("resourceType");
                boolean isTransactionNode = resType != null ? 14 == (Integer)resType || 20 == (Integer)resType : false;
                String name = child.getText();
                if (withPrjInfo && (prjName2 = (String)child.getOwnerGraph().getAttributeValue("mainframe project name")) != null) {
                    name = Messages.getString(EZExportGraphUtils.class, "name.for.cross", new String[]{name, prjName2});
                }
                if (chain.contains(name) || !isPrgNode && !isTransactionNode) continue;
                if (isPrgNode) {
                    chain.add(name);
                }
                maxLevel = EZExportGraphUtils.dfs(child, chain, graphDirection, group, maxLevel, withPrjInfo);
            }
        }
        if (chain.size() > 1 && !group.rows.contains(chain)) {
            maxLevel = maxLevel < chain.size() ? chain.size() : maxLevel;
            boolean isSubChain = false;
            while (group.index <= group.rows.size() - 1) {
                LinkedList<String> chain1 = group.getRow();
                if (chain1.size() >= chain.size() && (isSubChain = group.subchain(chain, chain1))) break;
                ++group.index;
            }
            if (!isSubChain) {
                group.rows.add(new LinkedList<String>(chain));
            }
        }
        String startName = startNode.getText();
        if (withPrjInfo && (prjName = (String)startNode.getOwnerGraph().getAttributeValue("mainframe project name")) != null) {
            startName = Messages.getString(EZExportGraphUtils.class, "name.for.cross", new String[]{startName, prjName});
        }
        chain.remove(startName);
        return maxLevel;
    }

    private static boolean printGroupsToCSV(String exportFile, List<Group> allGroups, List<String> startNames, String prjName, int graphDirection, int maxLevel, Integer graphLimitation, Boolean ... withoutHeader) {
        boolean ok = false;
        boolean append = withoutHeader != null && withoutHeader.length > 0 && withoutHeader[0] != false;
        CSVWriter writer = CSVWriter.open((File)new File(exportFile), (boolean)append);
        if (writer != null) {
            writer.setSeparator(";");
            if (prjName != null) {
                writer.writeLine(Messages.getString(EZExportGraphDialog.class, "prj.row.lbl", new String[]{prjName}));
            }
            if (!startNames.isEmpty()) {
                StringBuilder rowStringBuilder = new StringBuilder();
                rowStringBuilder.append(Messages.getString(EZExportGraphDialog.class, "prgs.row.lbl"));
                Iterator<String> it = startNames.iterator();
                while (it.hasNext()) {
                    rowStringBuilder.append((Object)it.next());
                    if (!it.hasNext()) continue;
                    rowStringBuilder.append(",");
                }
                writer.writeLine(rowStringBuilder.toString());
            }
            if (!append) {
                String direction = graphDirection == 0 ? Messages.getString(EZExportGraphDialog.class, "graph.direction.fw") : Messages.getString(EZExportGraphDialog.class, "graph.direction.bk");
                writer.writeLine(Messages.getString(EZExportGraphDialog.class, "graph.direction.lbl", new String[]{direction}));
                writer.writeLine(graphLimitation == null ? Messages.getString(EZExportGraphDialog.class, "levels.threshold.unlimit.lbl") : Messages.getString(EZExportGraphDialog.class, "levels.threshold.lbl", new Integer[]{(int)graphLimitation}));
                writer.writeLine("");
            }
            if (maxLevel == 0) {
                writer.writeLine(Messages.getString(EZExportGraphDialog.class, "level0.lbl"));
            } else {
                String[] levels = new String[2 * maxLevel];
                levels[0] = Messages.getString(EZExportGraphDialog.class, "level0.lbl");
                levels[1] = "";
                int i = 0;
                while (i <= maxLevel - 2) {
                    levels[2 + 2 * i] = Messages.getString(EZExportGraphDialog.class, "level.lbl", new Integer[]{i + 1});
                    levels[2 + 2 * i + 1] = "";
                    ++i;
                }
                writer.write(levels);
            }
            for (Group currentGroup : allGroups) {
                currentGroup.index = 0;
                List<LinkedList<String>> rows = currentGroup.rows;
                Collections.sort(rows, Group.pathComparator);
                while (currentGroup.index <= rows.size() - 1) {
                    String stringToPrint = currentGroup.getRowAsString();
                    ++currentGroup.index;
                    writer.writeLine(stringToPrint);
                }
            }
            writer.close();
            ok = writer.isExportOK();
        } else {
            ok = false;
        }
        return ok;
    }

    protected static boolean generateCSVFileForCrossSrvMainframe(String exportFile, AnalysisGraphManager graphMngr) {
        boolean isExportOk = false;
        int graphDirection = (Integer)graphMngr.getAttributeValue("graph direction");
        Integer graphLimitation = (Integer)graphMngr.getAttributeValue("graph limitation");
        Set startPrj = (Set)graphMngr.getAttributeValue("markPrjAsInput");
        Map prjTSMap = (Map)graphMngr.getAttributeValue("Projects_TS_map");
        boolean startedOnPrgs = startPrj.size() == 1 && graphMngr.hasAttribute("startedOnPrgs") && (Boolean)graphMngr.getAttributeValue("startedOnPrgs") != false;
        int maxLevel = 0;
        int i = 0;
        for (String prjName : startPrj) {
            boolean isStartNode;
            TSENode prjNode = (TSENode)prjTSMap.get(prjName);
            ArrayList<Group> allGroups = new ArrayList<Group>();
            boolean bl = isStartNode = prjNode.getAttributeValue("node is input for callgraph") != null;
            if (!isStartNode) continue;
            TSEGraph prjGraph = (TSEGraph)prjNode.getChildGraph();
            ArrayList<String> startPrgNames = new ArrayList<String>();
            List nodes = prjGraph.nodes();
            for (TSENode n : nodes) {
                if (startedOnPrgs) {
                    boolean isPrgStartNode;
                    boolean bl2 = isPrgStartNode = n.getAttributeValue("node is input for callgraph") != null;
                    if (!isPrgStartNode) continue;
                    startPrgNames.add(n.getText());
                }
                Group group = new Group(graphDirection);
                group.prgName = Messages.getString(EZExportGraphUtils.class, "name.for.cross", new String[]{n.getText(), prjName});
                allGroups.add(group);
                LinkedList<String> chain = new LinkedList<String>();
                chain.add(group.prgName);
                maxLevel = EZExportGraphUtils.dfs(n, chain, graphDirection, group, maxLevel, true);
                if (maxLevel != 0) continue;
                chain.add(group.prgName);
                group.rows.add(new LinkedList<String>(chain));
            }
            Collections.sort(allGroups);
            Collections.sort(startPrgNames);
            isExportOk = EZExportGraphUtils.printGroupsToCSV(exportFile, allGroups, startPrgNames, prjName, graphDirection, maxLevel, graphLimitation, i > 0);
            ++i;
            if (isExportOk) continue;
            L.debug("error when try to write chains in csv for project {}", (Object)prjName);
            break;
        }
        return isExportOk;
    }

    protected static boolean generateCSVFileForCrossMainframe(String exportFile, AnalysisGraphManager graphMngr) {
        boolean isExportOk;
        CSVWriter writer = CSVWriter.open((File)new File(exportFile));
        if (writer != null) {
            writer.setSeparator(";");
            List startNodes = (List)graphMngr.getAttributeValue("inputNode");
            Boolean isBack = (Boolean)graphMngr.getAttributeValue("isBackward");
            for (TSENode startNode : startNodes) {
                List invokededges = isBack != false ? startNode.buildInEdges() : startNode.buildOutEdges();
                for (TSEEdge edge : invokededges) {
                    TSNode transactionNode = isBack != false ? edge.getSourceNode() : edge.getTargetNode();
                    List mappededges = isBack != false ? transactionNode.buildInEdges() : transactionNode.buildOutEdges();
                    for (TSEEdge medge : mappededges) {
                        TSNode prjNode = isBack != false ? medge.getSourceNode() : medge.getTargetNode();
                        String[] row = new String[]{startNode.getText(), transactionNode.getText(), prjNode.getText()};
                        writer.write(row);
                    }
                }
            }
            writer.close();
            isExportOk = writer.isExportOK();
        } else {
            isExportOk = false;
        }
        return isExportOk;
    }
}

