/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph.gui;

import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.IExtraExportAsManager;
import com.ez.workspace.ui.internal.Messages;
import com.tomsawyer.application.swing.export.TSESaveAsImageDialog;
import com.tomsawyer.canvas.TSBaseCanvasInterface;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.interactive.swing.TSSwingCanvasPool;
import com.tomsawyer.util.TSSystem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZExportGraphDialog
extends TSESaveAsImageDialog {
    private static final long serialVersionUID = -6833309489149554822L;
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZExportGraphDialog.class);
    public static final String HEIGHT_KEY = "height";
    public static final String WIDTH_KEY = "width";
    public static final String SELECTED_KEY = "selected";
    public static final String FIT_IN_CANVAS_KEY = "fitInCanvas";
    public static final String ZOOM_LEVEL_KEY = "zoomLevel";
    public static final String ACTUAL_KEY = "actual";
    public static final String VISIBLE_KEY = "visible";
    private static final String IMG_ACTIONKEY = "exp_img";
    private boolean isExportOk = false;
    private boolean openFileOnExportOk = true;
    private String exportFile = null;
    private String imgType;
    private String actionKey = "exp_img";
    JPanel localJPanelImage;
    Job job = new ProgressJob();
    private Object objToWait = null;
    boolean okPressed = false;
    private Map<String, IExtraExportAsManager> extraExport;

    public EZExportGraphDialog(Frame frame, String s, TSSwingCanvas tsswingcanvas, int i, Object obj) {
        super(frame, s, (TSBaseCanvasInterface)tsswingcanvas, i);
        this.objToWait = obj;
        if (this.width.getText().trim().isEmpty()) {
            this.width.setText("100");
        }
        if (this.height.getText().trim().isEmpty()) {
            this.height.setText("100");
        }
    }

    private String getFileName() {
        String fName = null;
        if (this.actionKey.equals(IMG_ACTIONKEY)) {
            fName = this.fileName.getText();
        } else {
            IExtraExportAsManager m = this.extraExport.get(this.actionKey);
            fName = m.getFileName();
        }
        return fName;
    }

    private void setFileName(String fName) {
        if (this.actionKey.equals(IMG_ACTIONKEY)) {
            this.fileName.setText(fName);
        } else {
            IExtraExportAsManager m = this.extraExport.get(this.actionKey);
            m.setFileName(fName);
        }
    }

    public void onBrowse() {
        File file;
        JFileChooser jfilechooser = new JFileChooser();
        String selectedFileName = this.getFileName();
        if (selectedFileName != null) {
            jfilechooser.setSelectedFile(new File(selectedFileName));
        }
        if (!this.actionKey.equals(IMG_ACTIONKEY)) {
            IExtraExportAsManager m = this.extraExport.get(this.actionKey);
            FileFilter filter = m.getFileFilter();
            jfilechooser.setFileFilter(filter);
        }
        jfilechooser.setApproveButtonText(this.translateText("OK"));
        int i1 = jfilechooser.showOpenDialog(null);
        if (i1 == 0 && (file = jfilechooser.getSelectedFile()) != null) {
            String s = file.getPath();
            if (this.actionKey.equals(IMG_ACTIONKEY)) {
                this.fileType.setSelectedItem(jfilechooser.getFileFilter());
                if (s.lastIndexOf(".") > 0) {
                    String extension = s.substring(s.lastIndexOf(".") + 1, s.length());
                    if (!(extension.equalsIgnoreCase("gif") || extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") || extension.equalsIgnoreCase("svg") || extension.equalsIgnoreCase("png") || extension.equalsIgnoreCase("pdf"))) {
                        s = s.concat("." + this.type);
                    }
                } else {
                    s = s.concat("." + this.type);
                }
            }
            this.setFileName(s);
        }
    }

    public EZExportGraphDialog(Frame frame, String s, TSSwingCanvas tsswingcanvas, int i) {
        super(frame, s, (TSBaseCanvasInterface)tsswingcanvas, i);
    }

    public EZExportGraphDialog(Frame frame, String s, TSSwingCanvas tsswingcanvas) {
        super(frame, s, (TSBaseCanvasInterface)tsswingcanvas);
    }

    private void configureExtraExport() {
        if (this.extraExport == null) {
            this.extraExport = new HashMap<String, IExtraExportAsManager>();
        }
        ArrayList classes = new ArrayList();
        List ex = (List)this.getCanvas().getGraphManager().getAttributeValue("extraExportListImplementors");
        if (ex != null) {
            classes.addAll(ex);
        }
        for (Class c : classes) {
            try {
                Map data;
                IExtraExportAsManager m = (IExtraExportAsManager)c.newInstance();
                String propKey = m.getPropertiesKey();
                if (propKey != null && (data = (Map)this.getCanvas().getGraphManager().getAttributeValue(propKey)) != null) {
                    m.setData(data);
                }
                m.setActionListener((ActionListener)((Object)this));
                this.extraExport.put(m.getActionKey(), m);
            }
            catch (Exception e) {
                L.debug("could not instantiate {}", (Object)c.getName(), (Object)e);
            }
        }
    }

    public JPanel createMainPanel() {
        JPanel mainPanel = null;
        this.configureExtraExport();
        if (this.extraExport.size() > 0) {
            mainPanel = new JPanel();
            GridBagConstraints compConstraint = new GridBagConstraints();
            GridBagLayout gridbag = new GridBagLayout();
            compConstraint.fill = 1;
            gridbag.setConstraints(mainPanel, compConstraint);
            mainPanel.setLayout(gridbag);
            this.localJPanelImage = this.createImgPanel();
            ButtonGroup localButtonGroup = new ButtonGroup();
            JRadioButton imgExportButton = this.createRadioButton(this.translateText("Export_as_Image"), IMG_ACTIONKEY, 'I');
            imgExportButton.setSelected(true);
            localButtonGroup.add(imgExportButton);
            compConstraint.gridx = 0;
            compConstraint.gridy = 0;
            compConstraint.anchor = 23;
            compConstraint.weightx = 0.5;
            compConstraint.weighty = 0.5;
            gridbag.setConstraints(imgExportButton, compConstraint);
            mainPanel.add(imgExportButton);
            compConstraint.gridx = 0;
            compConstraint.gridy = 1;
            gridbag.setConstraints(this.localJPanelImage, compConstraint);
            mainPanel.add(this.localJPanelImage);
            for (IExtraExportAsManager m : this.extraExport.values()) {
                String[] gd = m.getGroupSelectorDetails();
                m.createPanel(this.font, (int)this.fileType.getPreferredSize().getWidth());
                JPanel extraPanel = m.getPanel();
                JRadioButton button = this.createRadioButton(gd[0], gd[1], gd[2].charAt(0));
                localButtonGroup.add(button);
                compConstraint.gridx = 0;
                compConstraint.gridy = 2;
                gridbag.setConstraints(button, compConstraint);
                mainPanel.add(button);
                compConstraint.gridx = 0;
                compConstraint.gridy = 3;
                gridbag.setConstraints(extraPanel, compConstraint);
                mainPanel.add(extraPanel);
                this.enableComponents(extraPanel, false);
            }
        } else {
            mainPanel = super.createMainPanel();
        }
        this.actionKey = IMG_ACTIONKEY;
        return mainPanel;
    }

    private JPanel createImgPanel() {
        JPanel localJPanelImage = new JPanel();
        localJPanelImage.setLayout(new BoxLayout(localJPanelImage, 1));
        this.createBorder(localJPanelImage, "", 0, 6, 5, 5);
        JPanel localJPanel2 = this.createImagePanel();
        JPanel localJPanel3 = this.createImageContent();
        JPanel localJPanel5 = this.createImageSize();
        localJPanel2.setAlignmentX(0.0f);
        localJPanel3.setAlignmentX(0.0f);
        localJPanel5.setAlignmentX(0.0f);
        localJPanelImage.add(localJPanel2);
        localJPanelImage.add(localJPanel3);
        localJPanelImage.add(localJPanel5);
        return localJPanelImage;
    }

    public EZExportGraphDialog(Frame frame, String s, TSSwingCanvasPool tsswingcanvaspool, int i) {
        super(frame, s, tsswingcanvaspool, i);
    }

    public EZExportGraphDialog(Frame frame, String s, TSSwingCanvasPool tsswingcanvaspool) {
        super(frame, s, tsswingcanvaspool);
    }

    private void enableComponents(Container container, boolean enable) {
        Component[] components;
        if (container == null) {
            return;
        }
        Component[] componentArray = components = container.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.setEnabled(enable);
            if (component instanceof Container) {
                this.enableComponents((Container)component, enable);
            }
            ++n2;
        }
    }

    public boolean isExportOk() {
        return this.isExportOk;
    }

    public boolean isOpenFileOnExportOk() {
        return this.openFileOnExportOk;
    }

    public void setOpenFileOnExportOk(boolean openFileOnExportOk) {
        this.openFileOnExportOk = openFileOnExportOk;
    }

    public String getExportFile() {
        return this.exportFile;
    }

    public void actionPerformed(ActionEvent paramActionEvent) {
        super.actionPerformed(paramActionEvent);
        String str1 = paramActionEvent.getActionCommand();
        if (str1.equals(IMG_ACTIONKEY)) {
            this.enableComponents(this.localJPanelImage, true);
            for (IExtraExportAsManager m : this.extraExport.values()) {
                this.enableComponents(m.getPanel(), false);
            }
            if (this.imgType != null) {
                this.type = this.imgType;
            }
            this.actionKey = str1;
        } else if (this.extraExport.keySet().contains(str1)) {
            this.enableComponents(this.localJPanelImage, false);
            this.imgType = this.type;
            for (IExtraExportAsManager m : this.extraExport.values()) {
                if (m.getActionKey().equals(str1)) {
                    this.enableComponents(m.getPanel(), true);
                    this.type = "csv";
                    continue;
                }
                this.enableComponents(m.getPanel(), false);
            }
            this.actionKey = str1;
        }
    }

    public boolean onOK() {
        this.okPressed = true;
        this.exportFile = this.getFileName();
        this.job.schedule(1000L);
        return true;
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    private boolean checks() {
        boolean checks = true;
        File localFile = new File(this.getExportFile());
        if (this.getExportFile().trim().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.translateText("Enter_a_valid_file_name."), this.translateText("File_Name_Not_Specified"), 0);
            return false;
        }
        if (localFile.exists()) {
            if (localFile.isDirectory()) {
                JOptionPane.showMessageDialog((Component)((Object)this), this.translateText("Cannot_overwrite_a_directory."), this.translateText("Invalid_File_Name"), 0);
                return false;
            }
            checks = JOptionPane.showConfirmDialog((Component)((Object)this), String.valueOf(this.getExportFile()) + this.translateText("%X%_already_exists.\nDo_you_want_to_replace_it?"), this.translateText("Overwrite_Confirmation"), 0) == 0;
        } else if (localFile.getParentFile() == null || !localFile.getParentFile().exists()) {
            String localObject1 = TSSystem.replace((String)this.translateText("Cannot_create_file_%X%."), (String)"%X%", (String)this.getExportFile());
            JOptionPane.showMessageDialog((Component)((Object)this), localObject1, this.translateText("Invalid_File_Name"), 0);
            return false;
        }
        return checks;
    }

    public String translateText(String paramString) {
        paramString = paramString.replaceAll(" ", "_");
        boolean i1 = true;
        try {
            Integer.parseInt(paramString);
        }
        catch (Exception exception) {
            i1 = false;
        }
        if (paramString.equals("") || i1) {
            return paramString;
        }
        return this.getString(paramString);
    }

    public String getString(String paramString) {
        boolean i;
        if (paramString.endsWith(":")) {
            paramString = paramString.substring(0, paramString.length() - 1);
            i = true;
        } else {
            i = false;
        }
        String str = Messages.getString(EZExportGraphDialog.class, paramString);
        if (i) {
            return String.valueOf(str) + Messages.getString(EZExportGraphDialog.class, "Colon");
        }
        return str;
    }

    private class ProgressJob
    extends Job {
        public ProgressJob() {
            super(Messages.getString(EZExportGraphDialog.class, "exportJob.name"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(EZExportGraphDialog.class, "exportJob.name"), -1);
            EZExportGraphDialog.this.setOpenFileOnExportOk(true);
            if (EZExportGraphDialog.this.extraExport.keySet().contains(EZExportGraphDialog.this.actionKey)) {
                for (IExtraExportAsManager m : EZExportGraphDialog.this.extraExport.values()) {
                    if (!EZExportGraphDialog.this.checks()) continue;
                    EZExportGraphDialog.this.isExportOk = m.doExport((AnalysisGraphManager)EZExportGraphDialog.this.getCanvas().getGraphManager());
                    EZExportGraphDialog.this.setOpenFileOnExportOk(m.isOpenFileOnExportOk());
                }
            } else {
                EZExportGraphDialog.this.isExportOk = EZExportGraphDialog.super.onOK();
            }
            monitor.done();
            Object object = EZExportGraphDialog.this.objToWait;
            synchronized (object) {
                L.trace("before notify on obj");
                EZExportGraphDialog.this.objToWait.notifyAll();
                L.trace("after notify on obj");
            }
            L.trace("end, beg {}", (Object)Thread.currentThread());
            return Status.OK_STATUS;
        }
    }
}

